/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.brtm.wrapper;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.brtm.utilities.ResponseDecorationUtils;
import com.wily.introscope.agent.brtm.wrapper.BRTHttpServletResponseWrapper;
import com.wily.introscope.agent.trace.BTThreadLocalAdministrator;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.util.feedback.DelegatingFeedbackChannel;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BrtmWrapperFactory {
    private static BrtmWrapperFactory singleton = new BrtmWrapperFactory();
    private static final Module BRTM_MODULE = new Module("BrowserAgent");
    public static String g_snippetJavaScriptContent;
    public static String[] g_excludePatternList;
    private static IAgent agent;
    private static IModuleFeedbackChannel feedback;
    private static boolean enableCookieFlag;

    static {
        enableCookieFlag = true;
    }

    private BrtmWrapperFactory() {
    }

    public static BrtmWrapperFactory getInstance(IAgent arg0) {
        agent = arg0;
        feedback = new DelegatingFeedbackChannel(arg0.IAgent_getModuleFeedback(), BRTM_MODULE);
        return singleton;
    }

    public static String getJSSnippet() {
        return g_snippetJavaScriptContent;
    }

    public static boolean enableCookie() {
        return enableCookieFlag;
    }

    public static void setJSExcludePatternList(String[] excludePatternList) {
        g_excludePatternList = excludePatternList;
    }

    public static String[] getJSExcludePatternList() {
        return g_excludePatternList;
    }

    public Boolean callSameMethodWithWrapperResponse(Object invocationDataObject, String methodName, String className, String methodDesc, Map argMap, String url) {
        try {
            Object[] argArray = (Object[])argMap.get("argPassArray");
            Map methodItem = (Map)argMap.get("methodItem");
            g_snippetJavaScriptContent = (String)argMap.get("snippetJS");
            InvocationData data = (InvocationData)argMap.get("invocationData");
            long maxResponseContentLengthForSearching = (Long)argMap.get("maxResponseContentLengthForSearching");
            if (!(argArray[1] instanceof HttpServletResponse)) {
                if (feedback.isTraceEnabled()) {
                    feedback.trace(BRTM_MODULE, "...Get non HttpServletResponse: " + argArray[1].getClass().getName());
                }
                return Boolean.FALSE;
            }
            argArray[1] = new BRTHttpServletResponseWrapper((HttpServletResponse)argArray[1], url, maxResponseContentLengthForSearching);
            BTThreadLocalAdministrator.getInstance().insert("brtm-response-wrapper-created", (Object)Boolean.TRUE);
            Class[] cfr_ignored_0 = new Class[argArray.length];
            Class<?> oClass = invocationDataObject.getClass();
            Method m = null;
            if (methodItem != null) {
                m = (Method)methodItem.get("method");
                Class[] cfr_ignored_1 = (Class[])methodItem.get("argClassArray");
            }
            try {
                if (oClass != null && m != null) {
                    data.IMethodTracer_setShouldStub(true);
                    data.IMethodTracer_setReentrancyOverwrite(true);
                    m.setAccessible(true);
                    if (feedback.isTraceEnabled()) {
                        feedback.trace(BRTM_MODULE, "...3 wrapperfactory... start reflection call to ... class=" + oClass.getName() + "...method=" + m.getName());
                    }
                } else {
                    if (feedback.isTraceEnabled()) {
                        feedback.trace(BRTM_MODULE, "...No method is found, skip reflection call");
                    }
                    return Boolean.FALSE;
                }
                m.invoke(invocationDataObject, argArray);
            }
            catch (SecurityException e) {
                feedback.error(BRTM_MODULE, "SecurityException: ", e);
                this.restoreAppRequest(data);
            }
            catch (IllegalArgumentException e) {
                feedback.error(BRTM_MODULE, "IllegalArgumentException: ", e);
                this.restoreAppRequest(data);
            }
            catch (IllegalAccessException e) {
                feedback.error(BRTM_MODULE, "IllegalAccessException: ", e);
                this.restoreAppRequest(data);
            }
            catch (InvocationTargetException e) {
                data.IParameterizedMethodTracer_setThrownException((Object)e.getTargetException());
            }
            if (feedback.isTraceEnabled()) {
                feedback.trace(BRTM_MODULE, "...4 wrapperfactory... finish reflection call to ... class=" + oClass.getName() + "...method=" + m.getName());
            }
        }
        catch (Exception e) {
            feedback.error(BRTM_MODULE, "...wrapperfactory... exception =" + e.toString());
            InvocationData data = (InvocationData)argMap.get("invocationData");
            this.restoreAppRequest(data);
        }
        return Boolean.TRUE;
    }

    private void restoreAppRequest(InvocationData data) {
        data.IMethodTracer_setShouldStub(false);
        data.IMethodTracer_setReentrancyOverwrite(false);
    }

    public String[] readRequestURLCookieHeader(Object request, Object data, Boolean enableCookie) {
        try {
            String origin;
            enableCookieFlag = enableCookie;
            String[] result = new String[3];
            HttpServletRequest req = (HttpServletRequest)request;
            result[0] = req.getRequestURI();
            String queryString = req.getQueryString();
            result[1] = queryString != null ? req.getRequestURL().append("?").append(queryString).toString() : req.getRequestURL().toString();
            Cookie[] requestCookies = req.getCookies();
            boolean getBrowserCookie = false;
            if (requestCookies != null) {
                Cookie[] cookieArray = requestCookies;
                int n = requestCookies.length;
                int n2 = 0;
                while (n2 < n) {
                    Cookie c = cookieArray[n2];
                    if (c.getName().equals("x-apm-brtm-gaptime")) {
                        if (c.getValue() != null) {
                            BTThreadLocalAdministrator.getInstance().insert("x-apm-brtm-gaptime", (Object)c.getValue());
                        }
                    } else if (c.getName().equals("x-apm-brtm-bt-p")) {
                        if (c.getValue() != null) {
                            BTThreadLocalAdministrator.getInstance().insert("x-apm-brtm-bt-p", (Object)c.getValue());
                            getBrowserCookie = true;
                        }
                    } else if (c.getName().equals("x-apm-brtm-bt-pv")) {
                        if (c.getValue() != null) {
                            BTThreadLocalAdministrator.getInstance().insert("x-apm-brtm-bt-pv", (Object)c.getValue());
                        }
                    } else if (c.getName().equals("x-apm-brtm-response-bt-id") && c.getValue() != null) {
                        try {
                            BTThreadLocalAdministrator.getInstance().insert("x-apm-brtm-response-bt-id", (Object)URLDecoder.decode(c.getValue(), "UTF-8"));
                            BTThreadLocalAdministrator.getInstance().insert("isAjaxCall", (Object)Boolean.TRUE);
                        }
                        catch (UnsupportedEncodingException e) {
                            feedback.error(BRTM_MODULE, "UnsupportedEncodingException: ", e);
                        }
                    }
                    ++n2;
                }
            }
            if (!getBrowserCookie) {
                result[2] = req.getHeader("user-agent");
            }
            if (req.getHeader("x-apm-bt") != null) {
                BTThreadLocalAdministrator.getInstance().insert("p", (Object)"mobile");
            }
            if ((origin = req.getHeader("Origin")) != null) {
                BTThreadLocalAdministrator.getInstance().insert("Origin", (Object)origin);
            }
            return result;
        }
        catch (Exception e) {
            feedback.error(BRTM_MODULE, "...wrapperfactory... readRequestURLCookieHeader exception =" + e.toString());
            return null;
        }
    }

    public void decorateCookieAndHeader(Object response) {
        HttpServletResponse resp;
        if (response instanceof HttpServletResponse && !(resp = (HttpServletResponse)response).isCommitted()) {
            ResponseDecorationUtils.createCookiesAndHeader(agent, feedback, resp);
        }
    }

    public void getUserID(Object request, String userIDCookieName) {
        Cookie[] requestCookies;
        if (request instanceof HttpServletRequest && (requestCookies = ((HttpServletRequest)request).getCookies()) != null) {
            Cookie[] cookieArray = requestCookies;
            int n = requestCookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie c = cookieArray[n2];
                if (c.getName().equals(userIDCookieName) && c.getValue() != null) {
                    BTThreadLocalAdministrator.getInstance().insert("userID", (Object)c.getValue());
                }
                ++n2;
            }
        }
    }
}

