/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.preflight.modules;

import com.wily.util.preflight.KPreflightErrorMessages;
import com.wily.util.preflight.PreflightMessage;
import com.wily.util.preflight.modules.LibraryDescriptor;
import com.wily.util.preflight.modules.LibraryListModule;
import com.wily.utilities.properties.Messages;
import java.lang.reflect.Field;

public class SnmpServicesModule
extends LibraryListModule
implements KPreflightErrorMessages {
    public static final int kExpectedSnmpMajorVersion = 2;
    public static final int kExpectedSnmpMinorVersion = 0;
    public static final String kExpectedSnmpMajorVersionString = Integer.toString(2);
    public static final String kExpectedSnmpMinorVersionString = Integer.toString(0);
    private static final String kSnmpVersionClassName = "com.wily.introscope.server.enterprise.entity.snmp.KSnmpVersion";
    private static final String kSnmpMajorVersionFieldName = "kSnmpMajorVersion";
    private static final String kSnmpMinorVersionFieldName = "kSnmpMinorVersion";

    public SnmpServicesModule() {
        super(new LibraryDescriptor[]{new LibraryDescriptor(new String[]{"monfox.toolkit.snmp.agent.SnmpAgent", "monfox.toolkit.snmp.agent.SnmpMib", "monfox.toolkit.snmp.metadata.SnmpMetadata", "org.jdom.Document"}, "The SNMP libraries could not be found.")}, "These libraries are stored in SNMPAdapter.jar, which should be in your classpath.");
    }

    @Override
    public PreflightMessage[] IPreflightModule_doCheck() {
        PreflightMessage[] messages = super.IPreflightModule_doCheck();
        boolean successSoFar = true;
        int x = 0;
        while (x < messages.length) {
            successSoFar = successSoFar && messages[x].isSuccessful();
            ++x;
        }
        if (successSoFar) {
            Class<?> snmpVersionClass = null;
            Field snmpMajorVersionField = null;
            Field snmpMinorVersionField = null;
            int actualSnmpMajorVersion = -1;
            int actualSnmpMinorVersion = 1;
            try {
                snmpVersionClass = Class.forName(kSnmpVersionClassName);
                snmpMajorVersionField = snmpVersionClass.getDeclaredField(kSnmpMajorVersionFieldName);
                snmpMinorVersionField = snmpVersionClass.getDeclaredField(kSnmpMinorVersionFieldName);
                actualSnmpMajorVersion = snmpMajorVersionField.getInt(null);
                actualSnmpMinorVersion = snmpMinorVersionField.getInt(null);
            }
            catch (Exception exception) {}
            if (2 != actualSnmpMajorVersion) {
                String lineSeparator = System.getProperty("line.separator");
                StringBuffer errorMessage = new StringBuffer();
                errorMessage.append(String.valueOf(Messages.getString("SnmpServicesModule.SNMPReportedVersion_Log")) + actualSnmpMajorVersion + "." + actualSnmpMinorVersion + "\"");
                errorMessage.append(lineSeparator);
                errorMessage.append(Messages.getString("SnmpServicesModule.ExpectedVersion_Log", (Object)kExpectedSnmpMajorVersionString, (Object)kExpectedSnmpMinorVersionString));
                return new PreflightMessage[]{new PreflightMessage(errorMessage.toString(), false, true)};
            }
        }
        return messages;
    }
}

