/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.properties.hot;

import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class HostSetConfigurationProperty
extends ConfigurationProperty {
    public HostSetConfigurationProperty(String name, String descriptionKey, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
        super(name, new HashSet(), descriptionKey, feedback, module, localizer);
    }

    public HostSetConfigurationProperty(String name, Set defaultValue, String description, String unitsKey, boolean isHot, boolean isNullValid, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
        super(name, defaultValue, description, unitsKey, isHot, isNullValid, feedback, module, localizer);
    }

    @Override
    public Object convert(String s) {
        HashSet<InetAddress> convertedValue = new HashSet<InetAddress>();
        Set rawValues = StringUtils.parseAndTrimListToSet(s, ",");
        Iterator i = rawValues.iterator();
        while (i.hasNext()) {
            String rv = ((String)i.next()).trim();
            try {
                convertedValue.add(InetAddress.getByName(rv));
            }
            catch (UnknownHostException e) {
                this.getFeedback().warn(this.formatLocalizedMessage("Hot_Property_Invalid_Message", e.getLocalizedMessage(), rv));
            }
            catch (SecurityException e) {
                this.getFeedback().warn(this.formatLocalizedMessage("Hot_Property_Invalid_Message", e.getLocalizedMessage(), rv));
            }
        }
        return convertedValue;
    }

    @Override
    public String toString(Object v) {
        StringBuffer result = new StringBuffer();
        result.append('\"');
        if (v != null) {
            Iterator i = ((Set)v).iterator();
            String sep = "";
            while (i.hasNext()) {
                result.append(sep);
                sep = ",";
                result.append(((InetAddress)i.next()).getHostName());
            }
        }
        result.append('\"');
        return result.toString();
    }
}

