/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.http.dataresolver;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.backend.http.dataresolver.HttpDataResolver;
import com.wily.introscope.agent.trace.backendprotocols.BackendProtocolsConstants;
import com.wily.introscope.agent.util.ReflectionUtils;
import com.wily.util.feedback.Module;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;

public class ApacheHttpComponentsClientDataResolver
implements HttpDataResolver {
    private static Module module = new Module("ApacheHttpComponentsClientDataResolver");
    private static final HttpDataResolver instance = new ApacheHttpComponentsClientDataResolver();

    private ApacheHttpComponentsClientDataResolver() {
    }

    public static HttpDataResolver getInstance() {
        return instance;
    }

    @Override
    public URI getUri(IAgent agent, InvocationData data) {
        try {
            Object req = this.getRequestObject(data);
            Object url = this.determineURI(agent, req);
            if (url instanceof URI) {
                URI uri = (URI)url;
                if (!uri.isAbsolute()) {
                    Object params;
                    Object hostObject = this.getHostObject(data);
                    if (hostObject == null && (params = ReflectionUtils.invokeMethodOnObject((Object)req, (String)"getParams", (Class[])new Class[0], (Object[])new Object[0])) != null && (hostObject = this.resolveHostObject(params)) == null) {
                        params = ReflectionUtils.invokeMethodOnObject((Object)data.getInvocationObject(), (String)"getParams", (Class[])new Class[0], (Object[])new Object[0]);
                        hostObject = this.resolveHostObject(params);
                    }
                    if (hostObject != null) {
                        Object uriObj = ReflectionUtils.invokeMethodOnObject((Object)hostObject, (String)"toURI", (Class[])new Class[0], (Object[])new Object[0]);
                        if (uriObj != null) {
                            return URI.create(String.valueOf((String)uriObj) + uri.toString());
                        }
                    } else {
                        return BackendProtocolsConstants.UNKNOWN_URI;
                    }
                }
                return uri;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                agent.IAgent_getModuleFeedback().error(module, "getURI : Unable to get URL for Apache Http components client");
                agent.IAgent_getModuleFeedback().verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        return BackendProtocolsConstants.UNKNOWN_URI;
    }

    private Object determineURI(IAgent agent, Object req) throws Throwable {
        Object returnValue = null;
        if (req != null) {
            Object requestLine = this.getRequestLine(agent, req);
            if (requestLine != null) {
                Object uri = ReflectionUtils.invokeMethodOnObject((Object)requestLine, (String)"getUri", (Class[])new Class[0], (Object[])new Object[0]);
                if (uri != null) {
                    returnValue = URI.create(uri.toString());
                }
            } else {
                returnValue = ReflectionUtils.invokeMethodOnObject((Object)req, (String)"getURI", (Class[])new Class[0], (Object[])new Object[0]);
            }
        } else {
            agent.IAgent_getModuleFeedback().warn(module, "determineURI : Expecting to find non-null request object");
        }
        return returnValue != null ? returnValue : BackendProtocolsConstants.UNKNOWN_URI;
    }

    private Object getRequestLine(IAgent agent, Object req) throws Throwable {
        String className;
        Object returnValue = null;
        if (req != null && "org.apache.http.message.BasicHttpRequest".equals(className = req.getClass().getName())) {
            String requestLineClass;
            Object requestLine = ReflectionUtils.invokeMethodOnObject((Object)req, (String)"getRequestLine", (Class[])new Class[0], (Object[])new Object[0]);
            String string = requestLineClass = requestLine != null ? requestLine.getClass().getName() : null;
            if ("org.apache.http.message.BasicRequestLine".equals(requestLineClass)) {
                returnValue = requestLine;
            } else {
                agent.IAgent_getModuleFeedback().warn(module, "getRequestLine : Expecting to find org.apache.http.RequestLine object");
            }
        }
        return returnValue;
    }

    @Override
    public String getHttpMethod(IAgent agent, InvocationData data) {
        String methodValueReturn = null;
        try {
            Object req = this.getRequestObject(data);
            Object requestLine = this.getRequestLine(agent, req);
            Object reqToUse = requestLine != null ? requestLine : req;
            Object httpMethod = ReflectionUtils.invokeMethodOnObject((Object)reqToUse, (String)"getMethod", (Class[])new Class[0], (Object[])new Object[0]);
            if (httpMethod != null && httpMethod instanceof String) {
                methodValueReturn = (String)httpMethod;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                agent.IAgent_getModuleFeedback().error(module, "getHttpMethod() : Unable to get HTTP method");
                agent.IAgent_getModuleFeedback().verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        return methodValueReturn;
    }

    @Override
    public int getHttpStatusCode(IAgent agent, InvocationData data) {
        try {
            Object statusLine = ReflectionUtils.invokeMethodOnObject((Object)data.getInvocationReturnValueAsObject(), (String)"getStatusLine", (Class[])new Class[0], (Object[])new Object[0]);
            if (statusLine != null) {
                Object responseCode = ReflectionUtils.invokeMethodOnObject((Object)statusLine, (String)"getStatusCode", (Class[])new Class[0], (Object[])new Object[0]);
                return (Integer)responseCode;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                agent.IAgent_getModuleFeedback().error(module, "getStatusCode() : Unable to get http status code");
                agent.IAgent_getModuleFeedback().verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        return -1;
    }

    @Override
    public String getHttpStatusMessage(IAgent agent, InvocationData data) {
        try {
            Object statusLine = ReflectionUtils.invokeMethodOnObject((Object)data.getInvocationReturnValueAsObject(), (String)"getStatusLine", (Class[])new Class[0], (Object[])new Object[0]);
            if (statusLine != null) {
                Object reasonPhrase = ReflectionUtils.invokeMethodOnObject((Object)statusLine, (String)"getReasonPhrase", (Class[])new Class[0], (Object[])new Object[0]);
                return (String)reasonPhrase;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                agent.IAgent_getModuleFeedback().error(module, "getReasonPhrase() : Unable to get http status message");
                agent.IAgent_getModuleFeedback().verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    private Object getRequestObject(InvocationData data) {
        Object reqObj = data.getInvocationParameterAsObject(0);
        if (reqObj == null || reqObj.getClass().getName().endsWith("apache.http.HttpHost")) {
            reqObj = data.getInvocationParameterAsObject(1);
        }
        return reqObj;
    }

    private Object getHostObject(InvocationData data) {
        return data.getInvocationParameterAsObject(0);
    }

    private Object resolveHostObject(Object httpParams) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return ReflectionUtils.invokeMethodOnObject((Object)httpParams, (String)"getParameter", (Class[])new Class[]{String.class}, (Object[])new String[]{"http.default-host"});
    }
}

