/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.frontend.jms;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.backend.jms.helper.JMSHelper;
import com.wily.introscope.agent.trace.backendprotocols.BackendProtocolsConstants;
import com.wily.introscope.agent.trace.hc2.FrontendTracer;
import com.wily.introscope.agent.util.ReflectionUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.util.Map;

public class JMSFrontendTracer
extends FrontendTracer
implements IInvocationDataParameterCallback,
BackendProtocolsConstants {
    final IModuleFeedbackChannel logger;
    final Module module = new Module("JmsFrontendTracer");
    private final String START_TRACE_QUALIFIED_FRONTEND_LISTENER = "frontend.jms.JMSFrontendTracer";

    public JMSFrontendTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.logger = agent.IAgent_getModuleFeedback();
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        try {
            Object message = data.getInvocationParameterAsObject(0);
            if (message == null) {
                return;
            }
            Object dest = null;
            try {
                dest = JMSHelper.getDestination(data, this.getModuleFeedback());
                if (dest == null) {
                    return;
                }
                boolean isQueue = this.isQueue(data, dest);
                if (isQueue) {
                    this.getQueueName(data, dest);
                } else if (this.isTopic(data, dest)) {
                    this.getTopicName(data, dest);
                }
                data.put("frontend.jms.JMSFrontendTracer", (Object)Boolean.TRUE);
                data.setParameterCallback((IInvocationDataParameterCallback)this);
                super.ITracer_startTrace(tracerIndex, data);
            }
            catch (Throwable e) {
                data.put("frontend.jms.JMSFrontendTracer", (Object)Boolean.FALSE);
                throw e;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.logger.error(this.module, "Unable to run JMSFrontendTracer: " + t.toString());
                this.logger.verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    private Object getDestination(InvocationData data) {
        Object dest = null;
        try {
            dest = ReflectionUtils.invokeMethodOnObject((Object)data.getInvocationParameterAsObject(0), (String)"getJMSDestination", (Class[])new Class[0], (Object[])new Object[0]);
        }
        catch (Exception e) {
            this.logger.error(this.module, "Could not get Destination Object" + e);
            return null;
        }
        return dest;
    }

    private boolean isQueue(InvocationData data, Object dest) {
        Class<?> queueClass = null;
        Boolean isQueue = (Boolean)data.get("Jms.is.Queue.Key");
        if (isQueue != null) {
            return isQueue;
        }
        boolean result = false;
        if (dest != null) {
            try {
                queueClass = Class.forName("javax.jms.Queue", true, dest.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                this.logger.error(this.module, "Could not get Class information for Queue " + e.getMessage());
                data.put("Jms.is.Queue.Key", (Object)false);
                return false;
            }
            result = queueClass.isAssignableFrom(dest.getClass());
            data.put("Jms.is.Queue.Key", (Object)result);
        }
        return result;
    }

    private boolean isTopic(InvocationData data, Object dest) {
        Class<?> topicClass = null;
        Boolean isTopic = (Boolean)data.get("Jms.is.Topic.Key");
        if (isTopic != null) {
            return isTopic;
        }
        boolean result = false;
        if (dest != null) {
            try {
                topicClass = Class.forName("javax.jms.Topic", true, dest.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                this.logger.error(this.module, "Could not get Class information for Queue " + e.getMessage());
                data.put("Jms.is.Topic.Key", (Object)false);
                return false;
            }
            result = topicClass.isAssignableFrom(dest.getClass());
            data.put("Jms.is.Topic.Key", (Object)result);
        }
        return result;
    }

    private String getQueueName(InvocationData data, Object queue) {
        String queueName = "Unknown Queue";
        String cachedQueueName = (String)data.get("Jms.Queue.Key");
        if (cachedQueueName != null) {
            return cachedQueueName;
        }
        if (queue != null) {
            try {
                queueName = (String)ReflectionUtils.invokeMethodOnObject((Object)queue, (String)"getQueueName", (Class[])new Class[0], (Object[])new Object[0]);
            }
            catch (Exception e) {
                this.logger.error(this.module, "Unable to get Queue Name" + e.getCause().getMessage());
            }
        }
        data.put("Jms.Queue.Key", (Object)queueName);
        return queueName;
    }

    private String getTopicName(InvocationData data, Object topic) {
        String topicName = "Unknown Topic";
        String cachedtopicName = (String)data.get("Jms.Topic.Key");
        if (cachedtopicName != null) {
            return cachedtopicName;
        }
        if (topic != null) {
            try {
                topicName = (String)ReflectionUtils.invokeMethodOnObject((Object)topic, (String)"getTopicName", (Class[])new Class[0], (Object[])new Object[0]);
            }
            catch (Exception e) {
                this.logger.error(this.module, "Unable to get Topic Name" + e.getCause().getMessage());
            }
        }
        data.put("Jms.Topic.Key", (Object)topicName);
        return topicName;
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        Boolean wasStartTraceQualified = (Boolean)data.get("frontend.jms.JMSFrontendTracer");
        if (wasStartTraceQualified != null && wasStartTraceQualified.booleanValue()) {
            super.ITracer_finishTrace(tracerIndex, data);
        } else {
            JMSHelper.debug(this.module, "Failed to run JMSFrontendTracer.ITracer_finishTrace because the value of the attribute START_TRACE_QUALIFIED_FRONTEND_LISTENER was found as false ");
        }
    }

    public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map parameters) {
        String hostName;
        String queueManagerName = JMSHelper.getCachedQueueManagerName(data);
        if (queueManagerName != null && !queueManagerName.equals("Unknown")) {
            parameters.put("ATTR_QueueManager Name", queueManagerName);
        }
        if ((hostName = JMSHelper.getCachedHostName(data)) != null && !hostName.equals("Unknown")) {
            parameters.put("ATTR_QueueManager Hostname", hostName);
        }
        if (this.isQueue(data, null)) {
            String queueName = this.getQueueName(data, null);
            if (queueManagerName != null && !queueManagerName.equals("Unknown") && queueName != null && (queueName = JMSHelper.substituteMetricSeparatorChars(queueName)) != null) {
                queueName = queueName.contains("mdWriteEnabled") ? queueName.substring(9, queueName.indexOf("?")) : queueName.replace("queue_", "").replaceAll("/", "");
            }
            parameters.put("Queue Name", queueName);
        } else if (this.isTopic(data, null)) {
            String topicName = this.getTopicName(data, null);
            if (queueManagerName != null && !queueManagerName.equals("Unknown") && topicName != null && (topicName = JMSHelper.substituteMetricSeparatorChars(topicName)) != null) {
                topicName = topicName.contains("mdWriteEnabled") ? topicName.substring(9, topicName.indexOf("?")) : topicName.replace("topic_", "").replaceAll("/", "");
            }
            parameters.put("Topic Name", topicName);
        }
    }
}

