/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.urlgrouper;

import com.wily.util.urlgrouper.Tree;
import com.wily.util.urlgrouper.UrlGroup;
import java.util.Iterator;
import java.util.Set;

public class UrlGrouper {
    private UrlGroup[] groups;

    public UrlGrouper(Set urlPaths) {
        Iterator it = urlPaths.iterator();
        Tree t = new Tree();
        while (it.hasNext()) {
            String urlPath = (String)it.next();
            t.addNode(urlPath);
        }
        int bestLevel = this.getBestLevel(t);
        this.groups = t.getUrlGroupsInLevel(bestLevel);
    }

    private int getBestLevel(Tree t) {
        int curLevel = 0;
        while (t.getNumberOfNodesInLevel(curLevel) == 1) {
            ++curLevel;
        }
        return curLevel;
    }

    public UrlGroup[] getGroups() {
        return this.groups;
    }

    public static String sanitize(String urlSegment) {
        return urlSegment.replace('.', '_');
    }
}

