/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlagent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.sqlagent.SQLAgentConfiguration;
import com.wily.introscope.agent.sqlagent.SQLExecuteTimer;
import com.wily.introscope.agent.sqlagent.StatementNormalizer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.util.properties.AttributeListing;

public final class DynamicSQLExecuteTimer
extends SQLExecuteTimer {
    public static final String kNormalizedDynamicSQLCacheKey = "com.wily.introscope.agent.sqlagent.dynamic.query.normalized.sql.cache";
    private final SQLAgentConfiguration fConfiguration;

    public DynamicSQLExecuteTimer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.fConfiguration = SQLAgentConfiguration.getInstance(agent);
    }

    @Override
    protected String getSQLSubtype(InvocationData data) {
        return "Dynamic";
    }

    @Override
    protected String getNormalizedSQL(InvocationData data) {
        String normalizedSQL = (String)data.get(kNormalizedDynamicSQLCacheKey);
        if (normalizedSQL == null) {
            String rawSQL = (String)data.getInvocationParameterAsObject(0);
            if (rawSQL == null) {
                rawSQL = "null";
            }
            normalizedSQL = StatementNormalizer.normalizeSQL(rawSQL, this.fConfiguration.getNormalizedMaxSQLLength());
            data.put(kNormalizedDynamicSQLCacheKey, (Object)normalizedSQL);
        }
        return normalizedSQL;
    }

    @Override
    protected String createMetricPath(InvocationData data) {
        String method = this.getProbeIdentification().getProbeMethodName();
        String normalizedSQL = this.getNormalizedSQL(data);
        StringBuffer sb = new StringBuffer(200);
        sb.append("JDBC|SQL");
        sb.append("|");
        sb.append("Dynamic");
        sb.append("|");
        sb.append(SQLExecuteTimer.sMethodToSQLSubtypeMap.get(method));
        sb.append("|");
        sb.append(normalizedSQL);
        return sb.toString();
    }
}

