/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlagent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.sqlagent.DatabaseNameFormatter;
import com.wily.introscope.agent.sqlagent.StatementToSQLMappingTracer;
import com.wily.introscope.agent.sqlagent.hc2.SQLObjectKeyHelper;
import com.wily.introscope.agent.sqlagent.hc2.StatementToConnectionMappingTracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.IBlameComponent;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;

public class StatementNameFormatter
extends DatabaseNameFormatter {
    private static final int kDebugErrorClamp = 50;
    private static volatile int nConsecutiveErrors = 0;

    public StatementNameFormatter(IAgent agent) {
        super(agent);
    }

    @Override
    protected Connection getConnection(IModuleFeedbackChannel feedback, Object tracedObject, InvocationData data) {
        Connection result;
        block14: {
            result = null;
            if (tracedObject != null) {
                if (tracedObject instanceof Statement) {
                    Statement stmt = (Statement)tracedObject;
                    try {
                        try {
                            Object sybaseConn;
                            result = stmt.getConnection();
                            if (result == null && (sybaseConn = data.get("SybaseConnection")) != null) {
                                result = (Connection)sybaseConn;
                            }
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable throwable) {
                            result = StatementToConnectionMappingTracer.getConnection(stmt);
                        }
                        nConsecutiveErrors = 0;
                    }
                    catch (Exception sqle) {
                        if (++nConsecutiveErrors < 50) {
                            feedback.debug("An unexpected error occurred getting a database connection: ", (Throwable)sqle);
                        }
                        break block14;
                    }
                }
                if (tracedObject instanceof Connection) {
                    result = (Connection)tracedObject;
                } else {
                    feedback.debug("[StatementNameFormatter] unexpected traced object type: " + tracedObject.getClass().getName());
                }
            } else {
                feedback.debug("[StatementNameFormatter] traced object is null");
            }
        }
        return result;
    }

    @Override
    public String getCommandType(IModuleFeedbackChannel feedback, InvocationData data) {
        Statement stmt;
        block4: {
            try {
                Object invocationObject = data.getInvocationObject();
                stmt = (Statement)invocationObject;
                if (!(stmt instanceof CallableStatement)) break block4;
                return "Stored Procedures";
            }
            catch (Exception e) {
                feedback.debug("An error occurred while attempting to get command type: ", (Throwable)e);
                return super.getCommandType(feedback, data);
            }
        }
        if (stmt instanceof PreparedStatement) {
            return "Prepared";
        }
        return "Dynamic";
    }

    @Override
    public IBlameComponent getKey(IModuleFeedbackChannel feedback, String name, InvocationData data) {
        Object invocationObject = data.getInvocationObject();
        Statement stmt = (Statement)invocationObject;
        if (stmt != null) {
            String formattedName = name;
            try {
                formattedName = this.INameFormatter_format(name, data);
            }
            catch (Exception exception) {}
            try {
                Object URL2 = SQLObjectKeyHelper.getURL(data, feedback, this.getConnection(this.getFeedback(), invocationObject, data), this);
                if (stmt instanceof PreparedStatement) {
                    if (data.getInvocationParameterCount() > 0) {
                        return this.createKey(new Object[]{StatementType.PREPARED, formattedName, URL2, data.getInvocationParameterAsObject(0)});
                    }
                    return this.createKey(new Object[]{StatementType.PREPARED, formattedName, URL2, StatementToSQLMappingTracer.getSQL(stmt, true)});
                }
                if (stmt instanceof CallableStatement) {
                    return this.createKey(new Object[]{StatementType.CALLABLE, formattedName, URL2, StatementToSQLMappingTracer.getSQL(stmt, true)});
                }
                if (data.getInvocationParameterCount() > 0) {
                    String normalizedSQL = super.getNormalizedSQL(feedback, data);
                    return this.createKey(new Object[]{StatementType.REGULAR, formattedName, URL2, normalizedSQL});
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return null;
    }

    public Object getObjectKey(IModuleFeedbackChannel feedback, int tracerIndex, InvocationData data) {
        return null;
    }

    private ABlameComponent createKey(Object ... elements) {
        return ABlameComponent.getArrayInstance((Object[])elements);
    }

    private static enum StatementType {
        REGULAR,
        PREPARED,
        CALLABLE;

    }
}

