/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlparamagent;

import com.wily.introscope.agent.IAgent;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;

final class SQLAgentConfiguration {
    public final IModuleFeedbackChannel fFeedback;
    public static final Module kModule = new Module("SqlParamAgent");
    private static SQLAgentConfiguration sInstance;
    private final int fNormalizedMaxSQLLength;
    private final int fMaxSQLParamLength;
    private final boolean fShowSQLParams;
    private final boolean fShowConnUrl;
    private final boolean fCountRows;
    private final boolean resolveBindParams;
    private final boolean kResolveBindParams = false;
    private final int fMaxPreparedStatemnts;
    private final int fMaxResultSets;
    private static final int kNormalizedMaxSQLLength = 400;
    private static final int kMaxSQLParamLength = 100;
    private static final boolean kShowSQLParams = false;
    private static final int kMaxStatements = 1000;
    private static final int kMaxResultSets = 1000;
    private static final String kResolveBindParamsProp = "introscope.agent.sqlagent.resolveBindParams";
    private static final String kSqlMaxLengthProp = "introscope.agent.sqlagent.sql.maxlength";
    private static final String kSqlMaxParamLengthProp = "introscope.agent.sqlagent.maxparamlength";
    private static final String kSqlShowUrlProp = "introscope.agent.sqlagent.showurl";
    private static final String kSqlShowParamsProp = "introscope.agent.sqlagent.showparams";
    private static final String kSqlCountRowsProp = "introscope.agent.sqlagent.countrows";
    private static final String kSqlMaxStatementsProp = "introscope.agent.sqlagent.statements.max";
    private static final String kSqlMaxResultSetsProp = "introscope.agent.sqlagent.resultsets.max";

    public static synchronized SQLAgentConfiguration getInstance(IAgent agent) {
        if (sInstance == null) {
            sInstance = new SQLAgentConfiguration(agent);
        }
        return sInstance;
    }

    public int getNormalizedMaxSQLLength() {
        return this.fNormalizedMaxSQLLength;
    }

    public boolean shouldShowConnUrl() {
        return this.fShowConnUrl;
    }

    public boolean shouldShowSQLParams() {
        return this.fShowSQLParams;
    }

    public boolean shouldCountRows() {
        return this.fCountRows;
    }

    public int getMaxSQLParamLength() {
        return this.fMaxSQLParamLength;
    }

    public boolean resolveBindParams() {
        return this.resolveBindParams;
    }

    public int getMaxPreparedStatements() {
        return this.fMaxPreparedStatemnts;
    }

    public int getMaxResultSets() {
        return this.fMaxResultSets;
    }

    private SQLAgentConfiguration(IAgent agent) {
        this.fFeedback = agent.IAgent_getModuleFeedback();
        this.fNormalizedMaxSQLLength = agent.IAgent_getIndexedProperties().safeGetIntProperty(kSqlMaxLengthProp, 400, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        this.fFeedback.info(kModule, "Configured max sql query string length at " + this.fNormalizedMaxSQLLength);
        this.fMaxSQLParamLength = agent.IAgent_getIndexedProperties().safeGetIntProperty(kSqlMaxParamLengthProp, 100, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        this.fFeedback.info(kModule, "Configured max sql param string length at " + this.fMaxSQLParamLength);
        this.fShowConnUrl = agent.IAgent_getIndexedProperties().safeGetBooleanProperty(kSqlShowUrlProp, false, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        this.fFeedback.info(kModule, "Configured show connection URL to " + this.fShowConnUrl);
        this.fShowSQLParams = agent.IAgent_getIndexedProperties().safeGetBooleanProperty(kSqlShowParamsProp, false, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        this.fFeedback.info(kModule, "Configured show params to " + this.fShowSQLParams);
        this.fCountRows = agent.IAgent_getIndexedProperties().safeGetBooleanProperty(kSqlCountRowsProp, false, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        this.fFeedback.info(kModule, "Configured result set row counting to " + this.fCountRows);
        this.resolveBindParams = agent.IAgent_getIndexedProperties().safeGetBooleanProperty(kResolveBindParamsProp, false, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        this.fFeedback.info(kModule, "Configured resolve Bind-Params to " + this.resolveBindParams);
        this.fMaxPreparedStatemnts = agent.IAgent_getIndexedProperties().safeGetIntProperty(kSqlMaxStatementsProp, 1000, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        this.fFeedback.info(kModule, "Configured max tracked prepared statements " + this.fMaxPreparedStatemnts);
        this.fMaxResultSets = agent.IAgent_getIndexedProperties().safeGetIntProperty(kSqlMaxResultSetsProp, 1000, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        this.fFeedback.info(kModule, "Configured max tracked result sets " + this.fMaxResultSets);
    }
}

