/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives;

import com.wily.diagnos.cmp.classmatcher.IClassMatcher;
import com.wily.diagnos.cmp.directives.ClassModificationFilter;
import com.wily.diagnos.cmp.directives.FlagName;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;

public final class TracerGroup {
    private final FlagName fFlagName;
    private final boolean fEnabled;
    private final boolean fStaticChangeable;
    private final boolean fLockedDisabled;
    private final IClassMatcher fClassMatcher;
    private final ClassModificationFilter fFilter;

    public TracerGroup(FlagName flagName, boolean enabled, boolean lockedDisabled, boolean changeable, IClassMatcher classMatcher, ClassModificationFilter filter) {
        this.fFlagName = flagName;
        this.fEnabled = enabled;
        this.fLockedDisabled = lockedDisabled;
        this.fStaticChangeable = changeable;
        this.fClassMatcher = classMatcher.IClassMatcher_generateImmutableMatcher();
        this.fFilter = filter;
    }

    public TracerGroup(FlagName flagName, boolean enabled, boolean lockedDisabled, IClassMatcher classMatcher, ClassModificationFilter filter) {
        this(flagName, enabled, lockedDisabled, true, classMatcher, filter);
    }

    public FlagName getName() {
        return this.fFlagName;
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public boolean isLockedDisabled() {
        return this.fLockedDisabled;
    }

    public boolean isChangeable() {
        return this.fStaticChangeable;
    }

    public IClassMatcher getClassMatcher() {
        return this.fClassMatcher;
    }

    public boolean shouldSkipInstrumentationInClass(IModeledClass theClass) {
        return this.fFilter.shouldSkip(theClass);
    }

    public boolean shouldSkipInstrumentationInClassForMethod(IModeledClass theClass, IModeledMethod theMethod) {
        return this.fFilter.shouldSkip(theClass, theMethod);
    }

    public boolean shouldSkipFlaggedMethod(IModeledMethod theMethod) {
        return this.fFilter.shouldSkip(theMethod);
    }

    public ClassModificationFilter getClassFilter() {
        return this.fFilter;
    }

    public String toString() {
        return this.fFlagName.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TracerGroup) {
            TracerGroup tracerGroup = (TracerGroup)obj;
            return this.fFlagName.equals(tracerGroup.fFlagName) && this.fEnabled == tracerGroup.fEnabled && this.fClassMatcher.equals(tracerGroup.fClassMatcher) && this.fFilter.equals(tracerGroup.fFilter);
        }
        return false;
    }

    public int hashCode() {
        return this.fFlagName.hashCode();
    }
}

