/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.tracer.builder;

import com.wily.diagnos.cmp.classmatcher.IClassMatcher;
import com.wily.diagnos.cmp.classmatcher.IDynamicClassMatcher;
import com.wily.diagnos.cmp.directives.TracerName;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.directives.builder.TracerGroupBuilder;
import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.diagnos.cmp.tracer.MethodTracer;
import com.wily.diagnos.cmp.tracer.builder.MethodTracerBuilder;
import com.wily.util.classfile.IClassName;
import com.wily.util.properties.AttributeListing;

public class DynamicMethodTracerBuilder
extends MethodTracerBuilder {
    private final IClassName fDeclaringClassName;
    private final boolean fTemporary;
    private final boolean fPermanent;
    private final String fLabel;

    public DynamicMethodTracerBuilder(String sourceFile, int lineNumber, IClassMatcher classMatcher, IMethodMatcher methodMatcher, TracerName tracerName, String name, TracerGroupBuilder flag, String labelName, boolean isTemporary, boolean isPermanent, IClassName declaringName) {
        super(sourceFile, lineNumber, classMatcher, methodMatcher, tracerName, name, null, flag, false);
        this.fLabel = labelName;
        this.fTemporary = isTemporary;
        this.fPermanent = isPermanent;
        this.fDeclaringClassName = declaringName;
    }

    public DynamicMethodTracerBuilder(CompilerSettingsBuilder builder, MethodTracer tracer) {
        super(null, 0, tracer.getClassMatcher(), tracer.getMethodMatcher(), null, tracer.getTracerClass(), tracer.getTracerOrdering(), new AttributeListing(tracer.getTracerParameters()), builder.getTracerGroupBuilder(tracer.getTracerGroup()), tracer.needsParameterAccess());
        this.fLabel = null;
        this.fTemporary = false;
        this.fPermanent = true;
        this.fDeclaringClassName = ((IDynamicClassMatcher)((Object)tracer.getClassMatcher())).getClassName();
    }

    public void postValidate() {
        if (this.fDeclaringClassName != null) {
            this.addParameter("declaringClass", this.fDeclaringClassName.getReflectionFriendlyQualifiedNameString());
        }
        this.addParameter("dynamic", this.fPermanent ? "false" : "true");
        this.addParameter("label", this.fLabel);
        this.addParameter("groupName", this.getFlag().getName().getName());
        this.addParameter("tracerName", this.getTracerName().getName());
        this.addParameter("temporary", this.fTemporary ? "true" : "false");
    }
}

