/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.detection.rules;

import com.wily.introscope.agent.intelligent.detection.rules.AbstractFailFastRule;
import com.wily.introscope.agent.intelligent.entrypoint.apis.ExecutionStatus;
import com.wily.introscope.agent.intelligent.entrypoint.apis.IndexAwareTraceElement;
import com.wily.util.HashCodeUtils;
import java.io.Serializable;

public class SkipClassMethodRule
extends AbstractFailFastRule
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String className;
    private final String methodName;

    public SkipClassMethodRule(String className, String methodName) {
        this.className = className;
        this.methodName = methodName;
    }

    @Override
    public boolean doExecute(int currentElementIndex, IndexAwareTraceElement[] trace, ExecutionStatus status) {
        IndexAwareTraceElement traceElement = trace[currentElementIndex];
        return !this.className.equals(traceElement.getClassName()) || !this.methodName.equals(traceElement.getMethodName());
    }

    public int hashCode() {
        return HashCodeUtils.accumulateHashCode(this.className.hashCode(), this.methodName.hashCode());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SkipClassMethodRule) {
            SkipClassMethodRule otherRule = (SkipClassMethodRule)obj;
            return this.className.equals(otherRule.className) && this.methodName.equals(otherRule.methodName);
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("{class=%s, fields={className=%s, methodName=%s}}", this.getClass().getName(), this.className, this.methodName);
    }
}

