/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.transactiontrace;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.transactiontrace.ITransactionEnvironment;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.spec.server.transactiontrace.ATransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.IFailFastTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Locale;
import java.util.Map;

public class CrossJVMSympatheticTransactionTraceFilter
extends ATransactionTraceFilter
implements IFailFastTransactionTraceFilter {
    private IModuleFeedbackChannel fFeedback;
    private ITransactionEnvironment fTransactionEnv;

    public CrossJVMSympatheticTransactionTraceFilter(IModuleFeedbackChannel feedback, ITransactionEnvironment transactionEnv) {
        this.fFeedback = feedback;
        this.fTransactionEnv = transactionEnv;
    }

    public int ITransactionTraceFilter_getFilterType() {
        return -1;
    }

    private Boolean isMarked() {
        Boolean isMarked = null;
        try {
            SharedCrossProcessData cache = AgentShim.getAgent().IAgent_getComponentTracer().getCrossProcessDataCache();
            if (cache != null) {
                isMarked = cache.isMarkedForSympatheticCrossJVMTracing();
            }
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
        if (this.fFeedback.isTraceEnabled()) {
            this.fFeedback.trace("CrossJVMSympatheticTransactionTraceFilter: isMarked " + isMarked);
        }
        return isMarked;
    }

    public boolean ITransactionTraceFilter_passesFilter(TransactionComponentData root) {
        return this.shouldCollectFinal();
    }

    public boolean shouldCollect(Map parameters) {
        return this.shouldCollectFinal();
    }

    public String ITransactionTraceFilter_getLocalizedDescription(IStringLocalizer localizer) {
        return null;
    }

    public void ITransactionTraceFilter_write(DataOutput out) throws IOException {
    }

    public String ITransactionTraceFilter_getLocalizedStatusMessage(IStringLocalizer localizer) {
        return null;
    }

    public String ITransactionTraceFilter_getLocalizedStatusMessage(IStringLocalizer localizer, Locale locale) {
        return null;
    }

    public boolean isHeadFilter() {
        return true;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public Boolean shouldCollectHead(Map parameters) {
        return this.isMarked();
    }

    public boolean shouldCollectFinal() {
        Boolean marked = this.isMarked();
        return marked == null ? false : marked;
    }
}

