/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.db;

import com.wily.diagnos.cmp.batch.DGFileSettings;
import com.wily.diagnos.cmp.directives.FlagName;
import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.diagnos.cmp.log.CompilerLogDetails;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.log.ISummaryInfo;
import com.wily.diagnos.cmp.tracer.MethodTracer;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.db.ClassMethodId;
import com.wily.introscope.agent.db.CompilerLogDatabaseTransaction;
import com.wily.introscope.agent.db.ConnectionManager;
import com.wily.introscope.agent.db.IConnectionManager;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IMethodName;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.task.IExecutableItem;
import com.wily.util.task.IExecutionQueue;
import com.wily.util.text.IStringLocalizer;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DGCompilerDatabaseLog
implements ICompilerLog {
    private int countLogMethodNotTraced;
    private int countLogMethodTraced;
    private int countLogClassTraced;
    private int countLogSkippedMethodDetails;
    private int countLogSkippedClassDetails;
    private int countLogMethodTracer;
    private IModuleFeedbackChannel fModuleFeedback;
    private IStringLocalizer fLocalizer;
    private IExecutionQueue fQueue;
    private List fMethodsTraced;
    private List fMethodsNotTraced;
    private List fSkipClassDetails;
    private List fClassTraced;
    private List fMethodTracers;
    private IConnectionManager manager = null;
    private int kBatchSize = 2500;
    private boolean kStoreClassSkip = false;

    public DGCompilerDatabaseLog(IStringLocalizer localizer, IModuleFeedbackChannel feedback, IAgent heartbeatSource, IExecutionQueue queue) {
        this.fModuleFeedback = feedback;
        this.fLocalizer = localizer;
        this.fQueue = queue;
        this.fMethodsTraced = new ArrayList();
        this.fMethodsNotTraced = new ArrayList();
        this.fClassTraced = new ArrayList();
        this.fSkipClassDetails = new ArrayList();
        this.fMethodTracers = new ArrayList();
        IntervalHeartbeat heartbeat = heartbeatSource.IAgent_getCommonHeartbeat();
        heartbeat.addBehavior((ITimestampedRunnable)new DatabaseFlushBehavior(), "database dump", true, 5000L, false);
        this.kBatchSize = heartbeatSource.IAgent_getIndexedProperties().safeGetIntProperty("introscope.agent.remoteagentdynamicinstrumentation.logBatchSize", 2500, heartbeatSource.IAgent_getModuleFeedback(), heartbeatSource.IAgent_getStringLocalizer());
        this.kStoreClassSkip = heartbeatSource.IAgent_getIndexedProperties().safeGetBooleanProperty("introscope.agent.remoteagentdynamicinstrumentation.storeSkips", false, heartbeatSource.IAgent_getModuleFeedback(), heartbeatSource.IAgent_getStringLocalizer());
    }

    public void ICompilerLog_logMethodTraced(IModeledMethod m) {
        if (this.getManager() != null) {
            this.setCountLogMethodNotTraced(this.getCountLogMethodNotTraced() + 1);
            this.logMethodTraced(m);
        }
    }

    public void ICompilerLog_logClassTraced(String className) {
        if (this.getManager() != null && this.kStoreClassSkip) {
            this.setCountLogClassTraced(this.getCountLogClassTraced() + 1);
            this.logClassTraced(className);
        }
    }

    public void ICompilerLog_logDetails(CompilerLogDetails details) {
        if (this.getManager() != null && details.isSkip() && this.kStoreClassSkip) {
            this.setCountLogSkippedClassDetails(this.getCountLogSkippedClassDetails() + 1);
            this.logSkipClassDetails(details);
        }
    }

    public void ICompilerLog_logMethodCalls(IModeledMethod method, List methodCalls) {
        if (this.getManager() != null) {
            this.setCountLogMethodTraced(this.getCountLogMethodTraced() + 1);
            this.logMethodNotTraced(method, methodCalls);
        }
    }

    public void ICompilerLog_logMethodTracer(IModeledMethod method, int lineNumber, MethodTracer tracer) {
        if (this.getManager() != null) {
            this.setCountLogMethodTracer(this.getCountLogMethodTracer() + 1);
            this.logMethodTracers(method, tracer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMethodTraced(IModeledMethod m) {
        List list = this.fMethodsTraced;
        synchronized (list) {
            this.fMethodsTraced.add(m);
            if (this.fMethodsTraced.size() > this.kBatchSize) {
                this.storeMethodsTraced(true, this.fMethodsTraced);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMethodNotTraced(IModeledMethod m, List methodCalls) {
        List list = this.fMethodsNotTraced;
        synchronized (list) {
            this.fMethodsNotTraced.add(m);
            this.fMethodsNotTraced.add(methodCalls);
            if (this.fMethodsNotTraced.size() > this.kBatchSize) {
                this.storeMethodsNotTraced(true, this.fMethodsNotTraced);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logClassTraced(String className) {
        List list = this.fClassTraced;
        synchronized (list) {
            this.fClassTraced.add(className);
            if (this.fClassTraced.size() > this.kBatchSize) {
                this.storeClassTraced(true, this.fClassTraced);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logSkipClassDetails(CompilerLogDetails detail) {
        List list = this.fSkipClassDetails;
        synchronized (list) {
            this.fSkipClassDetails.add(detail);
            if (this.fSkipClassDetails.size() > this.kBatchSize) {
                this.storeSkipClassDetails(true, this.fSkipClassDetails);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMethodTracers(IModeledMethod method, MethodTracer tracer) {
        List list = this.fMethodTracers;
        synchronized (list) {
            this.fMethodTracers.add(method);
            this.fMethodTracers.add(tracer);
            if (this.fMethodTracers.size() > this.kBatchSize) {
                this.storeMethodTracers(true, this.fMethodTracers);
            }
        }
    }

    private void storeMethodsTraced(boolean immediate, List methodsTraced) {
        final ArrayList methodsToBeTraced = new ArrayList();
        methodsToBeTraced.addAll(methodsTraced);
        methodsTraced.clear();
        IExecutableItem item = new IExecutableItem(){

            public void IExecutableItem_execute() {
                long start = System.currentTimeMillis();
                new CompilerLogDatabaseTransaction(DGCompilerDatabaseLog.this.getManager()){

                    protected void defineTransaction() throws SQLException {
                        int k = 0;
                        long start = System.currentTimeMillis();
                        if (DGCompilerDatabaseLog.this.fModuleFeedback.isTraceEnabled()) {
                            DGCompilerDatabaseLog.this.fModuleFeedback.trace("start stored " + methodsToBeTraced.size() + " methods");
                        }
                        Iterator i = methodsToBeTraced.iterator();
                        while (i.hasNext()) {
                            IModeledMethod method = (IModeledMethod)i.next();
                            i.remove();
                            this.tryStoreClassAndMethod(method, null, 1, 1);
                            ++k;
                        }
                        long end = System.currentTimeMillis();
                        if (DGCompilerDatabaseLog.this.fModuleFeedback.isTraceEnabled()) {
                            DGCompilerDatabaseLog.this.fModuleFeedback.trace("Stored " + k + " method in " + (end - start));
                        }
                    }
                }.executeTransaction();
                long end = System.currentTimeMillis();
                if (DGCompilerDatabaseLog.this.fModuleFeedback.isTraceEnabled()) {
                    DGCompilerDatabaseLog.this.fModuleFeedback.trace("Stored methods in " + (end - start));
                }
            }

            public void IExecutableItem_executionAborted() {
                DGCompilerDatabaseLog.this.fModuleFeedback.debug("IExecutableItem_executionAborted");
            }

            public boolean IExecutableItem_shouldStillExecute() {
                return true;
            }
        };
        if (this.fQueue != null && !immediate) {
            this.fQueue.IExecutionQueue_addExecutableItem(item);
        } else {
            item.IExecutableItem_execute();
        }
    }

    private void storeMethodsNotTraced(boolean immediate, List methodsNotTraced) {
        final ArrayList methodsToBeTraced = new ArrayList();
        methodsToBeTraced.addAll(methodsNotTraced);
        methodsNotTraced.clear();
        IExecutableItem item = new IExecutableItem(){

            public void IExecutableItem_execute() {
                long start = System.currentTimeMillis();
                new CompilerLogDatabaseTransaction(DGCompilerDatabaseLog.this.getManager()){

                    protected void defineTransaction() throws SQLException {
                        int k = 0;
                        long start = System.currentTimeMillis();
                        if (DGCompilerDatabaseLog.this.fModuleFeedback.isTraceEnabled()) {
                            DGCompilerDatabaseLog.this.fModuleFeedback.trace("start stored " + methodsToBeTraced.size() + " methods not traced");
                        }
                        Iterator i = methodsToBeTraced.iterator();
                        while (i.hasNext()) {
                            IModeledMethod method = (IModeledMethod)i.next();
                            i.remove();
                            List methodCalls = (List)i.next();
                            i.remove();
                            this.tryStoreClassAndMethod(method, methodCalls, 1, 2);
                            ++k;
                        }
                        long end = System.currentTimeMillis();
                        if (DGCompilerDatabaseLog.this.fModuleFeedback.isTraceEnabled()) {
                            DGCompilerDatabaseLog.this.fModuleFeedback.trace("Stored " + k + " method not traced in " + (end - start));
                        }
                    }
                }.executeTransaction();
                long end = System.currentTimeMillis();
                if (DGCompilerDatabaseLog.this.fModuleFeedback.isTraceEnabled()) {
                    DGCompilerDatabaseLog.this.fModuleFeedback.trace("Stored methods not traced in " + (end - start));
                }
            }

            public void IExecutableItem_executionAborted() {
                DGCompilerDatabaseLog.this.fModuleFeedback.debug("IExecutableItem_executionAborted");
            }

            public boolean IExecutableItem_shouldStillExecute() {
                return true;
            }
        };
        if (this.fQueue != null && !immediate) {
            this.fQueue.IExecutionQueue_addExecutableItem(item);
        } else {
            item.IExecutableItem_execute();
        }
    }

    private void storeClassTraced(boolean immediate, List classTraced) {
        final ArrayList classToBeTraced = new ArrayList();
        classToBeTraced.addAll(classTraced);
        classTraced.clear();
        IExecutableItem item = new IExecutableItem(){

            public void IExecutableItem_execute() {
                long start = System.currentTimeMillis();
                new CompilerLogDatabaseTransaction(DGCompilerDatabaseLog.this.getManager()){

                    protected void defineTransaction() throws SQLException {
                        int k = 0;
                        long start = System.currentTimeMillis();
                        if (DGCompilerDatabaseLog.this.fModuleFeedback.isTraceEnabled()) {
                            DGCompilerDatabaseLog.this.fModuleFeedback.trace("start storing " + classToBeTraced.size() + " classes");
                        }
                        Iterator i = classToBeTraced.iterator();
                        while (i.hasNext()) {
                            String className = (String)i.next();
                            ClassMethodId id = this.tryStoreClass(className);
                            this.tryUpdateClass(className, 1, id);
                            i.remove();
                            ++k;
                        }
                        long end = System.currentTimeMillis();
                        if (DGCompilerDatabaseLog.this.fModuleFeedback.isTraceEnabled()) {
                            DGCompilerDatabaseLog.this.fModuleFeedback.trace("Stored " + k + " classes in " + (end - start));
                        }
                    }
                }.executeTransaction();
                long end = System.currentTimeMillis();
                if (DGCompilerDatabaseLog.this.fModuleFeedback.isTraceEnabled()) {
                    DGCompilerDatabaseLog.this.fModuleFeedback.trace("Stored classes in " + (end - start));
                }
            }

            public void IExecutableItem_executionAborted() {
                DGCompilerDatabaseLog.this.fModuleFeedback.debug("IExecutableItem_executionAborted");
            }

            public boolean IExecutableItem_shouldStillExecute() {
                return true;
            }
        };
        if (this.fQueue != null && !immediate) {
            this.fQueue.IExecutionQueue_addExecutableItem(item);
        } else {
            item.IExecutableItem_execute();
        }
    }

    private void storeSkipClassDetails(boolean immediate, List skipClassDetails) {
        final ArrayList detailsToBeTraced = new ArrayList();
        detailsToBeTraced.addAll(skipClassDetails);
        skipClassDetails.clear();
        IExecutableItem item = new IExecutableItem(){

            public void IExecutableItem_execute() {
                long start = System.currentTimeMillis();
                new CompilerLogDatabaseTransaction(DGCompilerDatabaseLog.this.getManager()){

                    protected void defineTransaction() throws SQLException {
                        int k = 0;
                        long start = System.currentTimeMillis();
                        DGCompilerDatabaseLog.this.fModuleFeedback.trace("start storing " + detailsToBeTraced.size() + " details");
                        Iterator i = detailsToBeTraced.iterator();
                        while (i.hasNext()) {
                            CompilerLogDetails details = (CompilerLogDetails)i.next();
                            String className = details.getClassName();
                            ClassMethodId id = this.tryStoreClass(className);
                            this.tryUpdateClass(className, 2, id);
                            int skipCause = details.getSkipCause();
                            java.util.Date skipTime = details.getCreationTime();
                            String methodName = details.getMethodName();
                            PreparedStatement s = this.getPreparedStatement("insertSkips", "insert into skip values (DEFAULT, ?, ?, ?, ?)");
                            s.setString(1, className);
                            s.setString(2, methodName);
                            s.setDate(3, new Date(skipTime.getTime()));
                            s.setInt(4, skipCause);
                            s.execute();
                            int skipId = this.getLastIdCreated();
                            PreparedStatement s1 = this.getPreparedStatement("insertSkipDetails", "insert into skip_details values (?,?," + skipId + ")");
                            for (Map.Entry entry : details.getDetails().entrySet()) {
                                s1.setString(1, (String)entry.getKey());
                                s1.setString(2, (String)entry.getValue());
                                s1.execute();
                                s1.clearParameters();
                            }
                            i.remove();
                            ++k;
                        }
                        long end = System.currentTimeMillis();
                        DGCompilerDatabaseLog.this.fModuleFeedback.trace("Stored " + k + " details in " + (end - start));
                    }
                }.executeTransaction();
                long end = System.currentTimeMillis();
                DGCompilerDatabaseLog.this.fModuleFeedback.trace("Stored details in " + (end - start));
            }

            public void IExecutableItem_executionAborted() {
                DGCompilerDatabaseLog.this.fModuleFeedback.debug("IExecutableItem_executionAborted");
            }

            public boolean IExecutableItem_shouldStillExecute() {
                return true;
            }
        };
        if (this.fQueue != null && !immediate) {
            this.fQueue.IExecutionQueue_addExecutableItem(item);
        } else {
            item.IExecutableItem_execute();
        }
    }

    private void storeMethodTracers(boolean immediate, List methodTracers) {
        final ArrayList detailsToBeTraced = new ArrayList();
        detailsToBeTraced.addAll(methodTracers);
        methodTracers.clear();
        IExecutableItem item = new IExecutableItem(){

            public void IExecutableItem_execute() {
                long start = System.currentTimeMillis();
                new CompilerLogDatabaseTransaction(DGCompilerDatabaseLog.this.getManager()){

                    protected void defineTransaction() throws SQLException {
                        int k = 0;
                        long start = System.currentTimeMillis();
                        DGCompilerDatabaseLog.this.fModuleFeedback.trace("start storing " + detailsToBeTraced.size() + " tracers");
                        Iterator i = detailsToBeTraced.iterator();
                        while (i.hasNext()) {
                            FlagName name;
                            final IModeledMethod method = (IModeledMethod)i.next();
                            i.remove();
                            MethodTracer tracer = (MethodTracer)i.next();
                            i.remove();
                            final String tracerName = tracer.getTracerClass().getContainerAndPackageAndNameString();
                            final String tracerParameters = tracer.getTracerParameters();
                            String tracerGroupNameBuffer = "";
                            TracerGroup group = tracer.getTracerGroup();
                            if (group != null && (name = group.getName()) != null) {
                                tracerGroupNameBuffer = name.getName();
                            }
                            final String tracerGroupName = tracerGroupNameBuffer;
                            new CompilerLogDatabaseTransaction(DGCompilerDatabaseLog.this.getManager()){

                                protected void defineTransaction() throws SQLException {
                                    ClassMethodId methodIdInfo = this.getClassMethodId(method);
                                    if (methodIdInfo == null) {
                                        methodIdInfo = this.tryStoreClassAndMethod(method, null, 1, 1);
                                    }
                                    PreparedStatement s = this.getPreparedStatement("insert into method_trace values (?, ?, ?, ?)");
                                    s.setString(1, tracerName);
                                    s.setString(2, tracerGroupName);
                                    s.setInt(3, methodIdInfo.getMethodId());
                                    s.setString(4, tracerParameters);
                                    s.execute();
                                }
                            }.executeTransaction();
                            ++k;
                        }
                        long end = System.currentTimeMillis();
                        DGCompilerDatabaseLog.this.fModuleFeedback.trace("Stored " + k + " tracers in " + (end - start));
                    }
                }.executeTransaction();
                long end = System.currentTimeMillis();
                DGCompilerDatabaseLog.this.fModuleFeedback.trace("Stored details in " + (end - start));
            }

            public void IExecutableItem_executionAborted() {
                DGCompilerDatabaseLog.this.fModuleFeedback.debug("IExecutableItem_executionAborted");
            }

            public boolean IExecutableItem_shouldStillExecute() {
                return true;
            }
        };
        if (this.fQueue != null && !immediate) {
            this.fQueue.IExecutionQueue_addExecutableItem(item);
        } else {
            item.IExecutableItem_execute();
        }
    }

    public void ICompilerLog_close() {
    }

    public void ICompilerLog_dumpFile(String context, String filename, List contents) {
    }

    public void ICompilerLog_finishAborted(String element) {
    }

    public void ICompilerLog_finishArchive(String archive) {
    }

    public void ICompilerLog_finishDirectory(String directory) {
    }

    public void ICompilerLog_finishException(String element) {
    }

    public String ICompilerLog_getPath() {
        return null;
    }

    public ISummaryInfo ICompilerLog_getSummaryInfo() {
        return null;
    }

    public void ICompilerLog_logClassAlreadyInstrumented() {
    }

    public void ICompilerLog_logClassSubstitution(IModeledMethod method, int lineNumber, String originalClassName, String substituteClassName) {
    }

    public void ICompilerLog_logErrorMessage(String error) {
    }

    public void ICompilerLog_logException(Throwable e) {
    }

    public void ICompilerLog_logException(String context, Throwable e) {
    }

    public void ICompilerLog_logFileSettings(DGFileSettings fileSettings) {
    }

    public void ICompilerLog_logHeader(String copyright, String releaseAndBuildVersion, String dgVersion) {
    }

    public void ICompilerLog_logInheritanceChange(IClassName originalSuperClass, IClassName newSuperClass) {
    }

    public void ICompilerLog_logInstrumentation(IModeledMethod method, int lineNumber, String fullyQualifiedMethodName) {
    }

    public void ICompilerLog_logInternalError(IModeledMethod method, int lineNumber, String msg) {
    }

    public void ICompilerLog_logInvalidSettings(String specifics) {
    }

    public void ICompilerLog_logMemberReferenceChange(String originalMember, String newMember) {
    }

    public void ICompilerLog_logMessage(String message) {
    }

    public void ICompilerLog_logNoticeConstructorCompletion(IModeledMethod method, String notificationMethod) {
    }

    public void ICompilerLog_logNoticeFieldAssignment(IModeledMethod method, String fieldClass, String fieldName, IClassName notificationClass) {
    }

    public void ICompilerLog_logNoticeObjectCreation(IModeledMethod method, String createdType, IClassName notificationClass) {
    }

    public void ICompilerLog_logSkippedBootstrapClass(String className) {
    }

    public void ICompilerLog_logSkippedClass(String className) {
    }

    public void ICompilerLog_logSkippedClassForFlag(String flagName) {
    }

    public void ICompilerLog_logSkippedMethod(IClassName className, IMethodName methodName) {
    }

    public void ICompilerLog_logStartupCallInsertion(IModeledMethod method, int lineNumber, IClassName traceClassName) {
    }

    public void ICompilerLog_logSubstituteResult(IModeledMethod method, String substituteMethod) {
    }

    public void ICompilerLog_logTitleMessage(String title) {
    }

    public void ICompilerLog_setCopiedFile(String filename) {
    }

    public void ICompilerLog_setCurrentClass(IClassName className) {
    }

    public void ICompilerLog_setCurrentMethod(IClassName className, IMethodName methodName) {
    }

    public void ICompilerLog_setSkippedClass(IClassName className) {
    }

    public void ICompilerLog_setSkippedFile(String filename) {
    }

    public void ICompilerLog_startArchive(String archive) {
    }

    public void ICompilerLog_startDirectory(String directory) {
    }

    public void ICompilerLog_suggestFlush() {
        this.executeDatabaseFlush(true);
    }

    private void setManager(IConnectionManager manager) {
        this.manager = manager;
    }

    private IConnectionManager getManager() {
        if (this.manager == null) {
            this.manager = ConnectionManager.Instance();
        }
        return this.manager;
    }

    private void setCountLogMethodNotTraced(int countLogMethodNotTraced) {
        this.countLogMethodNotTraced = countLogMethodNotTraced;
    }

    private int getCountLogMethodNotTraced() {
        return this.countLogMethodNotTraced;
    }

    private void setCountLogMethodTraced(int countLogMethodTraced) {
        this.countLogMethodTraced = countLogMethodTraced;
    }

    private int getCountLogMethodTraced() {
        return this.countLogMethodTraced;
    }

    private void setCountLogClassTraced(int countLogClassTraced) {
        this.countLogClassTraced = countLogClassTraced;
    }

    private int getCountLogClassTraced() {
        return this.countLogClassTraced;
    }

    private void setCountLogSkippedMethodDetails(int countLogSkippedMethodDetails) {
        this.countLogSkippedMethodDetails = countLogSkippedMethodDetails;
    }

    private int getCountLogSkippedMethodDetails() {
        return this.countLogSkippedMethodDetails;
    }

    private void setCountLogSkippedClassDetails(int countLogSkippedClassDetails) {
        this.countLogSkippedClassDetails = countLogSkippedClassDetails;
    }

    private int getCountLogSkippedClassDetails() {
        return this.countLogSkippedClassDetails;
    }

    private void setCountLogMethodTracer(int countLogMethodTracer) {
        this.countLogMethodTracer = countLogMethodTracer;
    }

    private int getCountLogMethodTracer() {
        return this.countLogMethodTracer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDatabaseFlush(boolean immediate) {
        List list = this.fClassTraced;
        synchronized (list) {
            this.storeClassTraced(immediate, this.fClassTraced);
        }
        list = this.fMethodsNotTraced;
        synchronized (list) {
            this.storeMethodsNotTraced(immediate, this.fMethodsNotTraced);
        }
        list = this.fMethodsTraced;
        synchronized (list) {
            this.storeMethodsTraced(immediate, this.fMethodsTraced);
        }
        list = this.fSkipClassDetails;
        synchronized (list) {
            this.storeSkipClassDetails(immediate, this.fSkipClassDetails);
        }
        list = this.fMethodTracers;
        synchronized (list) {
            this.storeMethodTracers(immediate, this.fMethodTracers);
        }
    }

    public boolean ICompilerLog_isLogDynamicInstrEnabled() {
        return true;
    }

    public void ICompilerLog_saveLastMutatedClass(IModeledClass mutatedClass) {
    }

    public void ICompilerLog_logLastMutatedClass() {
    }

    public void ICompilerLog_logFieldInjection(IModeledClass targetClass, String fieldName, String fieldDesc) {
    }

    private final class DatabaseFlushBehavior
    implements ITimestampedRunnable {
        private DatabaseFlushBehavior() {
        }

        public void ITimestampedRunnable_execute(long nowInMillis) {
            DGCompilerDatabaseLog.this.executeDatabaseFlush(false);
        }
    }
}

