/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.async;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.async.AsyncTransactionContext;
import com.wily.introscope.agent.async.AsyncVirtualStack;
import com.wily.introscope.agent.async.IAsyncMetricUpdater;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.cas.ICounterRepository;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.IUpdater;
import com.wily.introscope.agent.trace.hc2.FrontendTracer;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;

public class AsyncFrontendEndTracer
extends FrontendTracer
implements IAsyncMetricUpdater {
    protected final IModuleFeedbackChannel feedback;
    protected static Module module = new Module("AsyncFrontendEndTracer");
    protected final AsyncVirtualStack asyncStack;
    private final IAgent agent;

    public AsyncFrontendEndTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.feedback = agent.IAgent_getModuleFeedback();
        this.asyncStack = AsyncVirtualStack.getInstance(agent);
        this.agent = agent;
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        AsyncTransactionContext.AsyncComponentInvocation frontendInfo = this.asyncStack.getAsyncFrontendInfoFromTransactionCache(data);
        if (frontendInfo == null) {
            if (this.feedback.isDebugEnabled(module)) {
                this.feedback.debug(module, "Failed to find correlated frontend info. " + data.getProbeInformation().getProbeIdentification().getProbeClassName() + "." + data.getProbeInformation().getProbeIdentification().getProbeMethodName());
            }
        } else {
            this.asyncStack.pop(frontendInfo, data, this);
        }
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    @Override
    public void updateAsyncComponentMetricsAtEnd(AsyncVirtualStack.AsyncMetricHolder[] metrics, long startTime, long endTime, boolean didStall) {
        IRepository rep;
        ICounterRepository cin = (ICounterRepository)metrics[0].sds;
        long elapsed = endTime - startTime;
        if (cin != null) {
            cin.decrease(endTime);
        }
        if ((rep = metrics[1].sds) != null) {
            rep.update((IUpdater)updater, elapsed, endTime, 0);
        }
        if ((rep = metrics[2].sds) != null) {
            rep.update(increaser, 0L, endTime, 0);
        }
        if (didStall && (cin = (ICounterRepository)metrics[3].sds) != null) {
            cin.decrease(endTime);
        }
    }
}

