/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.stat.IIntegerAggregatingDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.BlamePointTracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.util.StringUtils;
import com.wily.util.properties.AttributeListing;
import java.util.Set;

public class FrontendTracer
extends BlamePointTracer {
    private static final String kIsFrontendUnless = "is.frontend.unless";
    private Set fIsFrontendUnless;
    private static final String kFrontendsCategoryPrefix = "Frontends|";
    private boolean isSkippedClass = false;

    public FrontendTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        String isFrontendUnless = this.getParameter(kIsFrontendUnless);
        this.fIsFrontendUnless = StringUtils.parseAndTrimListToSet(isFrontendUnless, ",");
    }

    protected Set getClassesToSkip() {
        return this.fIsFrontendUnless;
    }

    protected void setSkippedClass() {
        this.isSkippedClass = true;
    }

    protected boolean isSkippedClass() {
        return this.isSkippedClass;
    }

    protected boolean hasFrontend() {
        return this.getComponentTracer().hasFrontend();
    }

    protected String getFrontendNameForComponent(String rootName) {
        return kFrontendsCategoryPrefix + rootName;
    }

    protected void addComponentToBlameStack(String component, InvocationData data) {
        super.addComponentToBlameStack(component, data);
        IBlameStack stack = data.getStack(this.getComponentTracer(), false);
        this.getComponentTracer().setFrontend(stack, component);
    }

    protected String getComponentName(InvocationData data) {
        return this.getFrontendNameForComponent(super.formatParameterizedName(data));
    }

    protected void doStartFrontendTrace(int tracerIndex, InvocationData data, String component) {
        this.doStartBlamePointTrace(tracerIndex, data, component);
    }

    protected void doFinishFrontendTrace(int tracerIndex, InvocationData data, String component) {
        this.doFinishBlamePointTrace(tracerIndex, data, component);
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        String className;
        Object invocationObject = data.getInvocationObject();
        String string = className = invocationObject == null ? data.getProbeInformation().getProbeIdentification().getProbeClassName() : invocationObject.getClass().getName();
        if (this.getClassesToSkip().contains(className)) {
            this.isSkippedClass = true;
            return;
        }
        super.ITracer_startTrace(tracerIndex, data);
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (this.isDisabled()) {
            return;
        }
        super.ITracer_finishTrace(tracerIndex, data);
        String component = data.getComponentNameAt(tracerIndex);
        this.getComponentTracer().frontBoundaryPopped(component);
    }

    public boolean ITracerFactory_isShutoff() {
        return this.hasFrontend();
    }

    protected boolean isDisabled() {
        return this.isSkippedClass;
    }

    protected IIntegerAggregatingDataAccumulator createTimerDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetFrontendIntegerAverageDataAccumulator(formattedMetricName);
    }

    protected ILongIntervalCounterDataAccumulator createPerIntervalDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetFrontendLongIntervalCounterDataAccumulator(formattedMetricName);
    }

    protected IIntegerFluctuatingCounterDataAccumulator createConcurrentInvocationDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetFrontendIntegerFluctuatingCounterDataAccumulator(formattedMetricName);
    }

    protected ILongIntervalCounterDataAccumulator createErrorsDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetFrontendLongIntervalCounterDataAccumulator(formattedMetricName);
    }

    protected IIntegerFluctuatingCounterDataAccumulator createStallsDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetFrontendIntegerAggregatingFluctuatingCounterDataAccumulator(formattedMetricName);
    }
}

