/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.nio;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.nio.ChannelConcurrentInvocationCounter;
import com.wily.introscope.agent.trace.nio.DatagramChannelMap;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;

public final class DatagramConcurrentInvocationCounter
extends ChannelConcurrentInvocationCounter {
    public DatagramConcurrentInvocationCounter(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public final ITracer ITracerFactory_allocateTracer(int tracerIndex, InvocationData data) {
        if (data.isSocketClamped()) {
            return null;
        }
        Object invocationObject = data.getInvocationObject();
        if (invocationObject instanceof DatagramChannel) {
            String formattedName;
            DatagramChannel channel = (DatagramChannel)invocationObject;
            InetSocketAddress remoteAddress = (InetSocketAddress)channel.socket().getRemoteSocketAddress();
            if (DatagramChannelMap.isRequired(channel, remoteAddress, this.getAgent()) && (formattedName = this.formatParameterizedName(data)) != null) {
                return this.allocateTracer(data, formattedName);
            }
        } else {
            Assertion.wilyAssert("Instrumentation error: invocation object not a DatagramChannel");
        }
        return null;
    }
}

