/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.container;

import com.wily.isengard.messageprimitives.service.IMessageService;
import java.util.Arrays;

public class MessageServiceRegistration {
    private final IMessageService fHandler;
    private final Class fInterfaceClass;
    private final String[] fSecurityGroups;
    private final boolean fIsGrouped;
    private String fRelativeServiceName;
    private boolean fPrependHubNameToRelativeServiceName;

    public MessageServiceRegistration(IMessageService handler, Class interfaceClass, String relativeServiceName, String[] securityGroups, boolean isGrouped) {
        this.fHandler = handler;
        this.fInterfaceClass = interfaceClass;
        this.fSecurityGroups = securityGroups;
        this.fIsGrouped = isGrouped;
        this.fRelativeServiceName = relativeServiceName;
        this.fPrependHubNameToRelativeServiceName = false;
    }

    public MessageServiceRegistration(IMessageService handler, Class interfaceClass, String[] securityGroups, boolean isGrouped) {
        this(handler, interfaceClass, null, securityGroups, isGrouped);
    }

    public MessageServiceRegistration(IMessageService handler, Class interfaceClass, String relativeServiceName, String[] securityGroups) {
        this(handler, interfaceClass, relativeServiceName, securityGroups, false);
    }

    public IMessageService getHandler() {
        return this.fHandler;
    }

    public void setRelativeServiceName(String relativeServiceName) {
        this.fRelativeServiceName = relativeServiceName;
    }

    public String getRelativeServiceName() {
        return this.fRelativeServiceName;
    }

    public Class getInterfaceClass() {
        return this.fInterfaceClass;
    }

    public boolean isGrouped() {
        return this.fIsGrouped;
    }

    public String[] getSecurityGroups() {
        return this.fSecurityGroups;
    }

    public boolean isPrependHubNameToRelativeServiceName() {
        return this.fPrependHubNameToRelativeServiceName;
    }

    public void setPrependHubNameToRelativeServiceName(boolean prependHubNameToRelativeServiceName) {
        this.fPrependHubNameToRelativeServiceName = prependHubNameToRelativeServiceName;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fHandler == null ? 0 : this.fHandler.hashCode());
        result = 31 * result + (this.fInterfaceClass == null ? 0 : this.fInterfaceClass.hashCode());
        result = 31 * result + (this.fIsGrouped ? 1231 : 1237);
        result = 31 * result + (this.fPrependHubNameToRelativeServiceName ? 1231 : 1237);
        result = 31 * result + (this.fRelativeServiceName == null ? 0 : this.fRelativeServiceName.hashCode());
        result = 31 * result + MessageServiceRegistration.hashCode(this.fSecurityGroups);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageServiceRegistration other = (MessageServiceRegistration)obj;
        if (this.fHandler == null ? other.fHandler != null : !this.fHandler.equals(other.fHandler)) {
            return false;
        }
        if (this.fInterfaceClass == null ? other.fInterfaceClass != null : !this.fInterfaceClass.equals(other.fInterfaceClass)) {
            return false;
        }
        if (this.fIsGrouped != other.fIsGrouped) {
            return false;
        }
        if (this.fPrependHubNameToRelativeServiceName != other.fPrependHubNameToRelativeServiceName) {
            return false;
        }
        if (this.fRelativeServiceName == null ? other.fRelativeServiceName != null : !this.fRelativeServiceName.equals(other.fRelativeServiceName)) {
            return false;
        }
        return Arrays.equals(this.fSecurityGroups, other.fSecurityGroups);
    }

    private static int hashCode(Object[] array) {
        if (array == null) {
            return 0;
        }
        int result = 1;
        int index = 0;
        while (index < array.length) {
            result = 31 * result + (array[index] == null ? 0 : array[index].hashCode());
            ++index;
        }
        return result;
    }
}

