/*
 * Decompiled with CFR 0.152.
 */
package com.twmacinta.util.test;

import com.twmacinta.io.NullOutputStream;
import com.twmacinta.util.MD5;
import com.twmacinta.util.MD5OutputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Random;
import java.util.StringTokenizer;

public class MD5OutputStreamTest {
    public static void main(String[] stringArray) {
        try {
            long l = System.currentTimeMillis();
            if (stringArray.length > 0 && !stringArray[0].equals("time")) {
                l = Long.parseLong(stringArray[0]);
            }
            long l2 = 0x500000000L;
            if (stringArray.length > 1) {
                l2 = Long.parseLong(stringArray[1]);
            }
            Random random = new Random(l);
            while (true) {
                System.out.print("seed:  " + l + "  \t");
                long l3 = random.nextLong();
                if (l3 < 0L) {
                    l3 = -l3;
                }
                System.out.println("size:  " + (l3 %= l2 + 1L));
                MD5OutputStreamTest.runTest(l3, random);
                l = random.nextLong();
                random.setSeed(l);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private static void runTest(long l, Random random) throws IOException {
        Process process = Runtime.getRuntime().exec("md5sum");
        MD5OutputStream mD5OutputStream = new MD5OutputStream(new NullOutputStream());
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(process.getOutputStream());
        while (l > 0L) {
            int n = random.nextInt() % 100;
            if ((n -= 5) < 0) {
                MD5OutputStreamTest.outputSingleByte(random, mD5OutputStream, bufferedOutputStream);
                --l;
                continue;
            }
            if ((n -= 25) < 0) {
                l -= MD5OutputStreamTest.outputFullBuffer(random, mD5OutputStream, bufferedOutputStream, l);
                continue;
            }
            l -= MD5OutputStreamTest.outputPartialBuffer(random, mD5OutputStream, bufferedOutputStream, l);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        ((OutputStream)bufferedOutputStream).flush();
        ((OutputStream)bufferedOutputStream).close();
        String string = new StringTokenizer(bufferedReader.readLine()).nextToken();
        bufferedReader.close();
        String string2 = MD5.asHex(mD5OutputStream.hash());
        if (!string.equals(string2)) {
            mD5OutputStream.close();
            System.out.println("ERROR");
            System.out.println("java:   " + string2);
            System.out.println("native: " + string);
            System.exit(1);
        }
        mD5OutputStream.close();
    }

    private static void outputSingleByte(Random random, OutputStream outputStream, OutputStream outputStream2) throws IOException {
        int n = random.nextInt() & 0xFF;
        outputStream.write(n);
        outputStream2.write(n);
    }

    private static long outputFullBuffer(Random random, OutputStream outputStream, OutputStream outputStream2, long l) throws IOException {
        int n = random.nextInt();
        if (n < 0) {
            n = -n;
        }
        if ((long)(n %= 131072) > l) {
            n = (int)l;
        }
        byte[] byArray = new byte[n];
        random.nextBytes(byArray);
        outputStream.write(byArray);
        outputStream2.write(byArray);
        return n;
    }

    private static long outputPartialBuffer(Random random, OutputStream outputStream, OutputStream outputStream2, long l) throws IOException {
        int n = random.nextInt();
        if (n < 0) {
            n = -n;
        }
        if ((long)(n %= 524288) > l) {
            n = (int)l;
        }
        if (n == 0) {
            return 0L;
        }
        byte[] byArray = new byte[n];
        random.nextBytes(byArray);
        int n2 = random.nextInt();
        if (n2 < 0) {
            n2 = -n2;
        }
        if ((n2 %= n) == n) {
            return 0L;
        }
        int n3 = random.nextInt();
        if (n3 < 0) {
            n3 = -n3;
        }
        outputStream.write(byArray, n2, n3 %= n - n2);
        outputStream2.write(byArray, n2, n3);
        return n3;
    }
}

