/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds.file.fileSpec;

import com.wily.rave.agent.ds.file.fileSpec.JavaDefaultFile;
import com.wily.rave.agent.ds.file.fileSpec.NativeFile;

public class FileFactory {
    private static final String NATIVE_LIB_NAME_DEFAULT = "cdnativefile_32";
    private static final String NATIVE_LIB_NAME_DEFAULT_32 = "cdnativefile_32";
    private static final String NATIVE_LIB_NAME_DEFAULT_64 = "cdnativefile_64";
    private static final String NATIVE_LIB_NAME_POWER_64 = "cdnativefilepower_64";
    private static final String NATIVE_LIB_NAME_PROP = "com.libjava.libnativefile";
    private static FileFactory singleton;
    private static String nativeLibName;
    private static String osArch;
    private boolean useJavaFile = false;

    private FileFactory() {
    }

    public static void setNativeLibName(String nativeLibName) {
        if (nativeLibName != null) {
            throw new IllegalStateException("Can't set the library name after it has been set once!");
        }
        FileFactory.nativeLibName = nativeLibName;
    }

    public static FileFactory getFileFactory() {
        if (singleton == null) {
            try {
                System.loadLibrary(FileFactory.getNativeLibName());
                singleton = new FileFactory();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                singleton = new FileFactory();
                FileFactory.singleton.useJavaFile = true;
            }
        }
        return singleton;
    }

    private static String getNativeLibName() {
        if (nativeLibName == null) {
            nativeLibName = System.getProperty(NATIVE_LIB_NAME_PROP);
            osArch = System.getProperty("os.arch");
            if (nativeLibName == null) {
                String javaVersion = FileFactory.getJavaVersion();
                if (javaVersion == null || javaVersion.equals("32")) {
                    nativeLibName = "cdnativefile_32";
                } else if (javaVersion.equals("64") && osArch.startsWith("ppc64le")) {
                    nativeLibName = NATIVE_LIB_NAME_POWER_64;
                } else if (javaVersion.equals("64")) {
                    nativeLibName = NATIVE_LIB_NAME_DEFAULT_64;
                }
            }
        }
        return nativeLibName;
    }

    public static String getJavaVersion() {
        if (System.getProperty("sun.arch.data.model") != null) {
            return System.getProperty("sun.arch.data.model");
        }
        if (System.getProperty("com.ibm.vm.bitmode") != null) {
            return System.getProperty("com.ibm.vm.bitmode");
        }
        return null;
    }

    public JavaDefaultFile getFile(String path) {
        if (this.useJavaFile) {
            return new JavaDefaultFile(path);
        }
        System.loadLibrary(FileFactory.getNativeLibName());
        return new NativeFile(path);
    }
}

