/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.task;

import com.wily.rave.agent.RaveAgent;
import com.wily.rave.agent.task.IRaveTask;
import com.wily.rave.agent.task.ITaskId;
import com.wily.rave.agent.task.Schedule;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;

public class RaveTaskExecutor
implements ITimestampedRunnable,
ITaskId {
    private final RaveAgent raveAgent;
    private IRaveTask task;
    private boolean initialized;
    private Schedule schedule;
    private IRegisteredBehavior behavior;
    private IntervalHeartbeat heartbeat;
    private IModuleFeedbackChannel feedback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RaveTaskExecutor(RaveAgent agent, IModuleFeedbackChannel feedback, IRaveTask task, Schedule schedule, IntervalHeartbeat heartbeat) {
        RaveTaskExecutor raveTaskExecutor = this;
        synchronized (raveTaskExecutor) {
            this.raveAgent = agent;
            this.feedback = feedback;
            this.task = task;
            this.schedule = schedule;
            this.initialized = false;
            this.heartbeat = heartbeat;
            this.behavior = heartbeat.addBehavior((ITimestampedRunnable)this, "Rave task: " + task.getTaskName(), true, (long)(schedule.isRepetitive() ? schedule.getIntervalInMillisec() : 1), true);
        }
    }

    void initTask() {
        this.task.init();
    }

    public void ITimestampedRunnable_execute(long nowInMillis) {
        try {
            if (this.raveAgent.raveShuttingDown() || !this.raveAgent.shouldSendData()) {
                return;
            }
            if (!this.initialized) {
                this.initTask();
                this.initialized = true;
            }
            this.task.collect();
            if (!this.schedule.isRepetitive()) {
                this.stopTask();
            }
        }
        catch (Throwable t) {
            this.feedback.error("Caught unexpected exception while processing Rave task " + this.task.getTaskName() + ". Rave agent will be shutdown!", t);
            this.raveAgent.shutDown();
        }
    }

    public void stopTask() {
        this.heartbeat.removeBehavior(this.behavior);
    }
}

