/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.frontend.jms;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.backend.jms.helper.JMSHelper;
import com.wily.introscope.agent.trace.backendprotocols.BackendProtocolsConstants;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.util.properties.AttributeListing;
import java.util.Map;

public class JMSReceiveFrontendTTTracer
extends BlamePointTracer
implements IInvocationDataParameterCallback,
BackendProtocolsConstants {
    public JMSReceiveFrontendTTTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void doOnStartTrace(int tracerIndex, IStackElement data, ITransactionElement element) {
        ((InvocationData)data).setStartCursorAt(element, tracerIndex);
        data.setLastFrontendCursor(element);
        ((InvocationData)data).setFrontBoundary(tracerIndex);
        data.setParameterCallback((IInvocationDataParameterCallback)this);
    }

    public void doOnEndTrace(int tracerIndex, IStackElement data, ITransactionElement element) {
        ((InvocationData)data).unsetFrontBoundary(tracerIndex);
    }

    public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map parameters) {
        String hostName;
        parameters.put("Class", data.get("Class"));
        parameters.put("Method", data.get("Method"));
        String queueName = null;
        String topicName = null;
        String queueManagerName = JMSHelper.getCachedQueueManagerName(data);
        if (queueManagerName != null && !queueManagerName.equals("Unknown")) {
            parameters.put("ATTR_QueueManager Name", queueManagerName);
        }
        if ((hostName = JMSHelper.getCachedHostName(data)) != null && !hostName.equals("Unknown")) {
            parameters.put("ATTR_QueueManager Hostname", hostName);
        }
        if ((queueName = (String)data.get("Queue Name")) != null) {
            if (queueManagerName != null) {
                queueName = queueName.contains("mdWriteEnabled") ? queueName.substring(9, queueName.indexOf("?")) : queueName.replace("queue_", "").replaceAll("/", "");
            }
            parameters.put("Queue Name", queueName);
        } else {
            topicName = (String)data.get("Topic Name");
            if (topicName != null) {
                if (queueManagerName != null) {
                    topicName = topicName.contains("mdWriteEnabled") ? topicName.substring(9, topicName.indexOf("?")) : topicName.replace("topic_", "").replaceAll("/", "");
                }
                parameters.put("Topic Name", topicName);
            }
        }
    }
}

