/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.transactiontrace.weblogic;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.transactiontrace.IPlatformCrossProcessDataHelper;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.spec.server.transactiontrace.GUIDGenerator;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class WeblogicPlatformCrossProcessDataHelper
implements IPlatformCrossProcessDataHelper {
    public int hashcode = this.getClass().getName().hashCode();
    private static Class weblogicTraceClass = null;
    private static WeblogicTraceReflectionHelper helper = null;
    public static final String kWeblogicTraceClassName = "weblogic.trace.Trace";

    public WeblogicPlatformCrossProcessDataHelper(Class traceClass) {
        WeblogicPlatformCrossProcessDataHelper.setWeblogicTracerClass(traceClass);
    }

    public int isValidForPlatform() {
        return 0;
    }

    public static boolean isWeblogicAppServerContext(IModuleFeedbackChannel feedback) {
        boolean result = weblogicTraceClass != null;
        return result;
    }

    public static void setWeblogicTracerClass(Class traceClass) {
        weblogicTraceClass = traceClass;
        try {
            helper = new WeblogicTraceReflectionHelper(traceClass);
        }
        catch (Exception exception) {
            weblogicTraceClass = null;
            helper = null;
        }
    }

    public SharedCrossProcessData getCurrentCrossProcessData(boolean create, IModuleFeedbackChannel feedback) {
        SharedCrossProcessData result = null;
        if (this.isValidForPlatform() == 0) {
            result = WeblogicPlatformCrossProcessDataHelper.getCurrentCrossProcessData(feedback);
        }
        return result;
    }

    private static void writeStream(ByteArrayOutputStream stream, SharedCrossProcessData data) throws IOException {
        ObjectOutputStream ostream = new ObjectOutputStream(stream);
        ostream.writeObject(data.getOutgoingSerializableInstance());
    }

    private static SharedCrossProcessData.SerializableSharedCrossProcessData readStream(ByteArrayInputStream stream, IModuleFeedbackChannel feedback) throws AgentNotAvailableException, IOException {
        ObjectInputStream ostream = new ObjectInputStream(stream);
        SharedCrossProcessData.SerializableSharedCrossProcessData serObj = null;
        Object obj = null;
        try {
            obj = ostream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (obj != null) {
            if (obj instanceof SharedCrossProcessData.SerializableSharedCrossProcessData) {
                serObj = (SharedCrossProcessData.SerializableSharedCrossProcessData)obj;
                return serObj;
            }
            if (feedback.isDebugEnabled()) {
                AgentShim.getAgent().IAgent_getModuleFeedback().debug("WebLogiclatformCrossProcessDataHelper: received an older/incompatible cross process data on wire.Ignoring this data, creating new correlation data");
            }
        } else if (feedback.isDebugEnabled()) {
            AgentShim.getAgent().IAgent_getModuleFeedback().debug("WebLogiclatformCrossProcessDataHelper: received null object on get from trace");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SharedCrossProcessData getCurrentCrossProcessData(IModuleFeedbackChannel feedback) {
        SharedCrossProcessData result = null;
        if (weblogicTraceClass == null) return result;
        if (helper == null) return result;
        try {
            SharedCrossProcessData cache = AgentShim.getAgent().IAgent_getComponentTracer().getCrossProcessDataCache();
            if (cache == null) {
                AgentShim.getAgent().IAgent_getModuleFeedback().warn("SharedCrossProcessData instance in the cache was found to be null. Cross process correlation may not work correctly");
                return result;
            }
            if (cache.getCorrelationID() != null) {
                if (feedback.isDebugEnabled()) {
                    feedback.debug("WeblogicPlatformCrossProcessDataHelper: getCurrentCrossProcessData returning existing cache");
                }
                cache.setFirstInProcessFlag(false);
                return cache;
            }
            byte[] b = helper.currentTrace();
            if (b != null && b.length > 0) {
                SharedCrossProcessData.SerializableSharedCrossProcessData serObj = WeblogicPlatformCrossProcessDataHelper.readStream(new ByteArrayInputStream(b), feedback);
                if (serObj == null) {
                    if (!feedback.isDebugEnabled()) return result;
                    AgentShim.getAgent().IAgent_getModuleFeedback().debug("WeblogicPlatformCrossProcessData: SharedCrossProcessData instance was null. Cross process correlation may not work");
                    return result;
                }
                if (serObj.getCorId() == null) return cache;
                cache.syncCache(serObj);
                if (feedback.isDebugEnabled()) {
                    feedback.debug("WeblogicCrossProcessHelper:  Value of received propagationFlag " + cache.getPropagationFlag());
                    feedback.debug("WeblogicCrossProcessHelper:  Value of received Corid " + cache.getCorrelationID());
                    feedback.debug("WeblogicCrossProcessHelper:  Value of received SeqId " + cache.getSeqID().getSequenceId());
                }
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                WeblogicPlatformCrossProcessDataHelper.writeStream(stream, cache);
                helper.beginTrace(stream.toByteArray());
                return cache;
            }
            cache.setCorrelationID(GUIDGenerator.getInstance().generateKey(), true);
            cache.createSeqID();
            cache.setPropagationFlag(0);
            cache.setComponentCount(0);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            WeblogicPlatformCrossProcessDataHelper.writeStream(stream, cache);
            helper.beginTrace(stream.toByteArray());
            return cache;
        }
        catch (NoSuchMethodException nsme) {
            feedback.error(nsme);
            if (!feedback.isDebugEnabled()) return result;
            feedback.debug(nsme);
            return result;
        }
        catch (InvocationTargetException ite) {
            feedback.error(ite);
            if (!feedback.isDebugEnabled()) return result;
            feedback.debug(ite);
            return result;
        }
        catch (IllegalAccessException iae) {
            feedback.error(iae);
            if (!feedback.isDebugEnabled()) return result;
            feedback.debug(iae);
            return result;
        }
        catch (IOException ioe) {
            feedback.error("A minor error occurred attempting to access cross-JVM data.  The error has been handled and will not cause and adverse effects.");
            if (!feedback.isDebugEnabled()) return result;
            feedback.debug(ioe);
            return result;
        }
        catch (ClassCastException cce) {
            feedback.error(cce);
            if (!feedback.isDebugEnabled()) return result;
            feedback.debug(cce);
            return result;
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
        return result;
    }

    public void incrementAndPropagateSequenceId(IModuleFeedbackChannel feedback) {
        WeblogicPlatformCrossProcessDataHelper.incrementSeqId(feedback);
    }

    public static void incrementSeqId(IModuleFeedbackChannel feedback) {
        if (weblogicTraceClass != null) {
            try {
                SharedCrossProcessData cache = AgentShim.getAgent().IAgent_getComponentTracer().getCrossProcessDataCache();
                if (cache != null) {
                    if (feedback.isDebugEnabled()) {
                        feedback.debug("WeblogicPlatformCrossProcessData: before incrementSeqId " + cache.getSeqID().getSequenceIdOutgoingFormat());
                    }
                    cache.incrementSequenceId();
                    if (feedback.isDebugEnabled()) {
                        feedback.debug("WeblogicPlatformCrossProcessData: after incrementSeqId " + cache.getSeqID().getSequenceIdOutgoingFormat());
                    }
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    WeblogicPlatformCrossProcessDataHelper.writeStream(stream, cache);
                    helper.propagateTrace(stream.toByteArray());
                } else if (feedback.isDebugEnabled()) {
                    AgentShim.getAgent().IAgent_getModuleFeedback().debug("WeblogicPlatformCrossProcessData: SharedCrossProcessData instance was null. Cross process correlation may not work");
                }
            }
            catch (IOException ioe) {
                feedback.error("A minor error occurred attempting to access cross-JVM data.  The error has been handled and will not cause and adverse effects.");
                if (feedback.isDebugEnabled()) {
                    feedback.debug(ioe);
                }
            }
            catch (InvocationTargetException ite) {
                feedback.error("A minor error occurred attempting to access cross-JVM data.  The error has been handled and will not cause and adverse effects.");
                if (feedback.isDebugEnabled()) {
                    feedback.debug(ite);
                }
            }
            catch (IllegalAccessException iae) {
                feedback.error("A minor error occurred attempting to access cross-JVM data.  The error has been handled and will not cause and adverse effects.");
                if (feedback.isDebugEnabled()) {
                    feedback.debug(iae);
                }
            }
            catch (AgentNotAvailableException agentNotAvailableException) {}
        }
    }

    public int compareTo(Object other) {
        return other.hashCode() - this.hashcode;
    }

    public boolean initialize(IModuleFeedbackChannel feedback) {
        return true;
    }

    public void teardown(IModuleFeedbackChannel feedback) {
        block5: {
            try {
                helper.endTrace();
                if (feedback.isDebugEnabled()) {
                    feedback.debug("WweblogicPlatformHelper: teardown finished");
                }
            }
            catch (InvocationTargetException ite) {
                feedback.error("A minor error occurred attempting to access cross-JVM data.  The error has been handled and will not cause and adverse effects.");
                if (feedback.isDebugEnabled()) {
                    feedback.debug(ite);
                }
            }
            catch (IllegalAccessException iae) {
                feedback.error("A minor error occurred attempting to access cross-JVM data.  The error has been handled and will not cause and adverse effects.");
                if (!feedback.isDebugEnabled()) break block5;
                feedback.debug(iae);
            }
        }
    }

    public int getPlatformType() {
        return 0;
    }

    private static class WeblogicTraceReflectionHelper {
        private Method fBeginTrace;
        private Method fEndTrace;
        private Method fPropagateTrace;
        private Method fCurrentTrace;
        private static final String kBeginTrace = "beginTrace";
        private static final String kEndTrace = "endTrace";
        private static final String kPropagateTrace = "propagateTrace";
        private static final String kCurrentTrace = "currentTrace";
        private static final Class[] kEmptySignature = new Class[0];
        private static final Class[] kByteArraySignature = new Class[]{byte[].class};
        private static final Object[] kEmptyArgs = new Object[0];

        WeblogicTraceReflectionHelper(Class traceClass) throws NoSuchMethodException {
            this.fBeginTrace = traceClass.getDeclaredMethod(kBeginTrace, kByteArraySignature);
            this.fEndTrace = traceClass.getDeclaredMethod(kEndTrace, kEmptySignature);
            this.fPropagateTrace = traceClass.getDeclaredMethod(kPropagateTrace, kByteArraySignature);
            this.fCurrentTrace = traceClass.getDeclaredMethod(kCurrentTrace, kEmptySignature);
        }

        byte[] beginTrace(byte[] traceArgs) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            Object[] args = new Object[]{traceArgs};
            byte[] bytes = (byte[])this.fBeginTrace.invoke(null, args);
            return bytes;
        }

        byte[] endTrace() throws IllegalAccessException, InvocationTargetException {
            byte[] bytes = (byte[])this.fEndTrace.invoke(null, kEmptyArgs);
            return bytes;
        }

        void propagateTrace(byte[] traceArgs) throws IllegalAccessException, InvocationTargetException {
            Object[] args = new Object[]{traceArgs};
            this.fPropagateTrace.invoke(null, args);
        }

        byte[] currentTrace() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
            return (byte[])this.fCurrentTrace.invoke(null, kEmptyArgs);
        }
    }
}

