/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.AbstractPlainSocketImpl;
import java.net.AgentSocketInputStream;
import java.net.SocketInputStream;

public class ManagedSocketInputStreamAPSIHighPerformanceNew
extends SocketInputStream {
    private final AgentSocketInputStream managedSocketInputStream = new AgentSocketInputStream();

    ManagedSocketInputStreamAPSIHighPerformanceNew(AbstractPlainSocketImpl impl) throws IOException {
        super(impl);
        this.managedSocketInputStream.setCache(impl.socket);
    }

    public int read() throws IOException {
        int byteRead;
        if (this.managedSocketInputStream.getCache() == null) {
            return super.read();
        }
        boolean addedToConcurrentReaders = this.managedSocketInputStream.addToConcurrentReaders("read()");
        if (this.managedSocketInputStream.getCache().isClientConnection()) {
            this.managedSocketInputStream.annotateBlameStack(this);
            this.managedSocketInputStream.suggestStackTraceRecording();
        }
        try {
            byteRead = super.read();
            this.managedSocketInputStream.addToInputBandwidth(1);
        }
        finally {
            this.managedSocketInputStream.removeFromConcurrentReaders(addedToConcurrentReaders, "read()");
        }
        return byteRead;
    }

    public int read(byte[] b, int off, int length) throws IOException {
        int numberOfBytesRead;
        if (this.managedSocketInputStream.getCache() == null) {
            return super.read(b, off, length);
        }
        boolean addedToConcurrentReaders = this.managedSocketInputStream.addToConcurrentReaders("read(byte[],int,int)");
        if (this.managedSocketInputStream.getCache().isClientConnection()) {
            this.managedSocketInputStream.annotateBlameStack(this);
            this.managedSocketInputStream.suggestStackTraceRecording();
        }
        try {
            numberOfBytesRead = super.read(b, off, length);
            this.managedSocketInputStream.addToInputBandwidth(numberOfBytesRead);
        }
        finally {
            this.managedSocketInputStream.removeFromConcurrentReaders(addedToConcurrentReaders, "read(byte[],int,int)");
        }
        return numberOfBytesRead;
    }
}

