/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.trace.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.RepositoryFactory;
import com.wily.introscope.agent.trace.cas.SharedDataStructure4;
import com.wily.introscope.agent.trace.cas.TransactionTransitionException;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.CountMetricGathererWrapper;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;

public class HTTPErrorCodeReporter
extends ASingleMetricTracerFactory {
    public static final int FirstRealHttpError = 400;
    protected final WilyTransactionStructure fStructure = WilyTransactionStructure.getInstance();
    protected final IModuleFeedbackChannel logger;

    public HTTPErrorCodeReporter(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.logger = agent.IAgent_getModuleFeedback();
    }

    @Override
    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    private String buildErrorMessage(InvocationData data) {
        if (!data.hasInvocationParametersAvailable() || data.getInvocationParameterCount() == 0) {
            return null;
        }
        Object firstParam = data.getInvocationParameterAsObject(0);
        if (!(firstParam instanceof Integer)) {
            return null;
        }
        Integer httpErrorCode = (Integer)firstParam;
        if (httpErrorCode < 400) {
            return null;
        }
        StringBuffer answer = new StringBuffer("HTTP Error Code: ");
        answer.append(httpErrorCode.toString());
        if (data.getInvocationParameterCount() >= 2 && data.getInvocationParameterAsObject(1) != null) {
            answer.append(": ");
            answer.append(data.getInvocationParameterAsObject(1).toString());
        }
        return InvocationData.limitSize(answer.toString());
    }

    @Override
    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        String errorMessage = this.buildErrorMessage(data);
        if (errorMessage != null) {
            this.logger.debug("HTTPErrorCodeReporter::Got error message as:" + errorMessage);
            if (ErrorFeature.evalErrorQualificationForCurrTxn(this.getAgent(), null, errorMessage)) {
                try {
                    AgentMetric errorMetric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), this.getErrorsMetricName(this.getFormattedName()), 8194, "Invalid Names:Invalid name given for a long interval counter metric");
                    SharedDataStructure4 newError = new SharedDataStructure4(CountMetricGathererWrapper.getFactory(true));
                    IRepository prevError = WilyTransactionStructure.putIntoGlobalGathererIfAbsent(errorMetric, (IRepository)newError);
                    data.getWallClockStartTime();
                    long endTime = data.getWallClockFinishTime();
                    int hashCode = data.hashCode();
                    if (prevError != null) {
                        prevError.update(BlamePointTracer.getIncreaser(), 0L, endTime, hashCode);
                    } else {
                        newError.update(BlamePointTracer.getIncreaser(), 0L, endTime, hashCode);
                    }
                }
                catch (TransactionTransitionException e) {
                    this.logger.debug(e);
                }
                IStackElement topElement = VirtualStack.peek();
                if (topElement != null) {
                    ErrorFeature.incrementErrorMetric(topElement);
                    ErrorFeature.constructAndSendErrorSnapshotToServerWithOtherStackElementOnTop(data, errorMessage, this.getAgent(), topElement);
                    ErrorFeature.decorateTransactionsWithErrorOnOtherStackElement(data, errorMessage, topElement);
                }
            }
        }
    }

    @Override
    protected IDataAccumulator createDataAccumulator(String formattedMetricName) {
        return null;
    }

    protected String getErrorsMetricName(String component) {
        return String.valueOf(component) + ":" + "Errors Per Interval";
    }
}

