/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.servlet;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.servlet.IDirectParameterAccessor;
import com.wily.introscope.agent.trace.servlet.IServletRequestHelper;
import com.wily.introscope.agent.trace.servlet.LoaderContext;
import com.wily.introscope.agent.trace.servlet.RequestWrapper;
import com.wily.introscope.agent.trace.servlet.ServletHelperFactory;
import com.wily.introscope.agent.trace.servlet.ServletInvocationDataHelper;
import com.wily.introscope.agent.trace.servlet.ServletWrapper;
import com.wily.introscope.agent.trace.servlet.SessionWrapper;
import com.wily.introscope.agent.transactiontrace.TransactionTraceController;
import com.wily.introscope.agent.urlgroup.TomcatUtil;
import com.wily.introscope.spec.agent.bizdef.KBizDefConstants;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class ServletParameterLoader
extends ServletInvocationDataHelper.ServletParameterErrorCounterDelegate {
    public static final String kHeaderParametersPrefix = "header.";
    public static final String kRequestParametersPrefix = "request.params.";
    public static final String kRequestAttributesPrefix = "request.attrs.";
    public static final String kSessionAttributesPrefix = "session.attrs.";
    private static final String kServlerPArameterLoaderCacheParams = "ServletParameterLoader.cache.params";
    private static final String kServletParameterLoaderCacheConfig = "ServletParameterLoader.cache.config";
    private static final Object kServlerPArameterLoaderCacheWatchedParams = "ServletParameterLoader.cache.watched";
    private static final Object kServlerPArameterLoaderCacheExtraParams = "ServletParameterLoader.cache.extra";
    private static final Object kServlerPArameterLoaderCachePostParams = "ServletParameterLoader.cache.post";
    private static final Object kLastWatchedParameterList = "LastWatchedParameterList";
    private TransactionTraceController ttc;
    private String fContextKey;
    private LoaderContext fCurrentContext;
    private boolean fLoadExtraParams = false;
    private boolean fLoadPostParams = false;
    protected IModuleFeedbackChannel fFeedback = null;
    protected boolean fDebugOut = false;
    protected static final Module kModule = new Module("ServletParameterLoader");
    private Map fParams;

    public ServletParameterLoader(IAgent agent, IModuleFeedbackChannel feedback, String context, Map params) {
        this.fFeedback = feedback;
        this.fParams = params;
        this.fDebugOut = feedback.isDebugEnabled();
        this.fContextKey = context;
        this.fCurrentContext = LoaderContext.getContext(this.fContextKey);
        this.ttc = agent.IAgent_getTransactionTraceController();
    }

    public void setLoadExtraParams(boolean b) {
        this.fLoadExtraParams = b;
    }

    public void setLoadPostParams(boolean b) {
        this.fLoadPostParams = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doWithWrappers(InvocationData data, RequestWrapper rw, ServletWrapper sw) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, UnsupportedEncodingException {
        String method;
        HashMap syncMap = null;
        HashMap myCachedParams = null;
        HashMap cacheConfig = null;
        boolean isCachedParamsSet = false;
        HashMap myCachedWatchedParams = null;
        boolean isCachedWatchedParametersSet = false;
        HashMap myCachedExtraParams = null;
        boolean isCachedExtraParamsSet = false;
        HashMap myCachedPostParams = null;
        boolean isCachedPostParamsSet = false;
        InvocationData invocationData = data;
        synchronized (invocationData) {
            syncMap = (HashMap)data.getSyncStorage();
            if (syncMap == null) {
                syncMap = new HashMap(8);
                data.setSyncStorage(syncMap);
            }
            if ((cacheConfig = (HashMap)syncMap.get(kServletParameterLoaderCacheConfig)) == null) {
                cacheConfig = new HashMap(3);
                syncMap.put(kServletParameterLoaderCacheConfig, cacheConfig);
            }
            isCachedParamsSet = (myCachedParams = (HashMap)syncMap.get(kServlerPArameterLoaderCacheParams)) != null;
            myCachedWatchedParams = (HashMap)syncMap.get(kServlerPArameterLoaderCacheWatchedParams);
            if (this.hasWatchParamsListChanged(cacheConfig)) {
                syncMap.put(kServlerPArameterLoaderCacheWatchedParams, null);
                myCachedWatchedParams = null;
            }
            boolean bl = isCachedWatchedParametersSet = myCachedWatchedParams != null;
            if (this.fLoadExtraParams) {
                myCachedExtraParams = (HashMap)syncMap.get(kServlerPArameterLoaderCacheExtraParams);
                boolean bl2 = isCachedExtraParamsSet = myCachedExtraParams != null;
            }
            if (this.fLoadPostParams) {
                myCachedPostParams = (HashMap)syncMap.get(kServlerPArameterLoaderCachePostParams);
                isCachedPostParamsSet = myCachedPostParams != null;
            }
        }
        if (!isCachedParamsSet) {
            myCachedParams = new HashMap();
            this.addParameters(myCachedParams, rw, sw);
            invocationData = data;
            synchronized (invocationData) {
                Map cachedParams = (Map)syncMap.get(kServlerPArameterLoaderCacheParams);
                if (cachedParams == null) {
                    syncMap.put(kServlerPArameterLoaderCacheParams, myCachedParams);
                }
            }
        }
        this.fParams.putAll(myCachedParams);
        if (!isCachedWatchedParametersSet) {
            myCachedWatchedParams = new HashMap();
            this.addWatchedParameters(myCachedWatchedParams, rw);
            invocationData = data;
            synchronized (invocationData) {
                Map cachedWatchedParams = (Map)syncMap.get(kServlerPArameterLoaderCacheWatchedParams);
                if (cachedWatchedParams == null) {
                    syncMap.put(kServlerPArameterLoaderCacheWatchedParams, myCachedWatchedParams);
                }
            }
        }
        this.fParams.putAll(myCachedWatchedParams);
        if (this.fLoadExtraParams) {
            if (!isCachedExtraParamsSet) {
                myCachedExtraParams = new HashMap();
                this.addExtraParameters(myCachedExtraParams, rw);
                invocationData = data;
                synchronized (invocationData) {
                    Map cachedExtraParams = (Map)syncMap.get(kServlerPArameterLoaderCacheExtraParams);
                    if (cachedExtraParams == null) {
                        syncMap.put(kServlerPArameterLoaderCacheExtraParams, myCachedExtraParams);
                    }
                }
            }
            this.fParams.putAll(myCachedExtraParams);
        }
        if (this.fLoadPostParams && (method = (String)myCachedParams.get("HTTP Method")).equals("POST")) {
            if (!isCachedPostParamsSet) {
                myCachedPostParams = new HashMap();
                this.addPostParameters(myCachedPostParams, rw);
                InvocationData invocationData2 = data;
                synchronized (invocationData2) {
                    Map cachedPostParams = (Map)syncMap.get(kServlerPArameterLoaderCachePostParams);
                    if (cachedPostParams == null) {
                        syncMap.put(kServlerPArameterLoaderCachePostParams, myCachedPostParams);
                    }
                }
            }
            this.fParams.putAll(myCachedPostParams);
        }
        this.resetErrorCount();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasWatchParamsListChanged(Map cacheConfig) {
        Object[] lastWatcheParamList = (String[])cacheConfig.get(kLastWatchedParameterList);
        boolean result = true;
        LoaderContext loaderContext = this.fCurrentContext;
        synchronized (loaderContext) {
            Object[] currentWatchedParamList = this.fCurrentContext.fWatchedParamList;
            if (lastWatcheParamList != null && Arrays.equals(lastWatcheParamList, currentWatchedParamList)) {
                result = false;
            } else {
                cacheConfig.put(kLastWatchedParameterList, currentWatchedParamList.clone());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWatchedParameters(Map params, RequestWrapper rw) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        this.addUserID(rw, params);
        String paramName = null;
        String value = null;
        IServletRequestHelper helper = null;
        LoaderContext loaderContext = this.fCurrentContext;
        synchronized (loaderContext) {
            for (Map.Entry e : this.fCurrentContext.fAccessors.entrySet()) {
                Object accessor = e.getValue();
                if (accessor instanceof LoaderContext.IParameterAccessor) {
                    value = ((LoaderContext.IParameterAccessor)accessor).IParameterAccessor_accessParameter(rw, this.fCurrentContext.fCharEncoding);
                    if (value == null) continue;
                    paramName = ((LoaderContext.IParameterAccessor)accessor).IParameterAccessor_getParameterName();
                    params.put(paramName, value);
                    continue;
                }
                if (!(accessor instanceof IDirectParameterAccessor)) continue;
                Object request = rw.getObject();
                if (helper == null) {
                    helper = ServletHelperFactory.getServletHelper(request, request.getClass().getClassLoader(), this.fFeedback);
                }
                if ((value = ((IDirectParameterAccessor)accessor).IParameterAccessor_accessParameter(helper, request, null, params)) == null) continue;
                paramName = ((IDirectParameterAccessor)accessor).IParameterAccessor_getParameterName();
                params.put(paramName, value);
            }
        }
    }

    private void addExtraParameters(Map cachedExtraParams, RequestWrapper rw) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, UnsupportedEncodingException {
        this.addHeaderParamMap(rw, cachedExtraParams);
        this.addCookieParamMap(rw, cachedExtraParams);
    }

    private void addHeaderParamMap(RequestWrapper request, Map parameters) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, UnsupportedEncodingException {
        HashMap<String, String> headersMap = (HashMap<String, String>)parameters.get("introscope.agent.HttpServletTracer.headerParameters");
        String xWTGParam = null;
        if (headersMap == null) {
            headersMap = new HashMap<String, String>();
            Enumeration headerNames = request.getHeaderNames();
            if (headerNames != null) {
                while (headerNames.hasMoreElements()) {
                    String headerKey = (String)headerNames.nextElement();
                    if (headerKey == null || headerKey.toString().trim().toLowerCase().equals("cookie") || headerKey.toString().trim().toLowerCase().equals("host")) continue;
                    String headerValue = request.getHeader(headerKey);
                    if (headerKey.toString().trim().toLowerCase().equals("x-wtg-info")) {
                        xWTGParam = headerValue;
                        continue;
                    }
                    headersMap.put(headerKey, headerValue);
                }
            }
            if (xWTGParam != null) {
                HashMap xWTGInfoParamMap = new HashMap();
                int startIndex = 0;
                if (xWTGParam.toLowerCase().startsWith(KBizDefConstants.kBizXWTGINFOHeaderStartValue)) {
                    if ((startIndex += KBizDefConstants.kBizXWTGINFOHeaderStartValue.length()) < xWTGParam.length()) {
                        xWTGParam = xWTGParam.substring(startIndex);
                    } else {
                        startIndex = 0;
                    }
                }
                if (startIndex > 0) {
                    TomcatUtil.parseParameters(xWTGInfoParamMap, xWTGParam, "UTF-8");
                    if (xWTGInfoParamMap != null && xWTGInfoParamMap.size() > 0) {
                        parameters.put("XWTG", xWTGInfoParamMap);
                    }
                }
            }
            if (headersMap.size() > 0) {
                parameters.put("introscope.agent.HttpServletTracer.headerParameters", headersMap);
            }
        }
    }

    private void addCookieParamMap(RequestWrapper request, Map parameters) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        HashMap<String, String> cookiesMap = (HashMap<String, String>)parameters.get("introscope.agent.HttpServletTracer.cookieParameters");
        if (cookiesMap == null) {
            cookiesMap = new HashMap<String, String>();
            Object[] cookies = request.getCookies();
            if (cookies != null) {
                int i = 0;
                while (i < cookies.length) {
                    if (cookies[i] != null) {
                        Class<?> cookieClass = cookies[i].getClass();
                        Method method = cookieClass.getMethod("getName", null);
                        String cookieKey = (String)method.invoke(cookies[i], null);
                        method = cookieClass.getMethod("getValue", null);
                        String cookieValue = (String)method.invoke(cookies[i], null);
                        if (cookieKey != null && cookieValue != null) {
                            cookiesMap.put(cookieKey, cookieValue);
                        }
                    }
                    ++i;
                }
            }
            if (cookiesMap.size() > 0) {
                parameters.put("introscope.agent.HttpServletTracer.cookieParameters", cookiesMap);
            }
        }
    }

    private void addPostParameters(Map parameters, RequestWrapper request) throws ClassNotFoundException, IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        Map postParamMap = request.getPostParameterMap();
        if (postParamMap != null && postParamMap.size() > 0) {
            parameters.put("introscope.agent.HttpServletTracer.postParameters", postParamMap);
        }
    }

    protected void onError(Throwable t) {
        this.fFeedback.error("An error occurred while loading paramters from servlet: " + t);
        this.fFeedback.verbose(t);
    }

    protected void onMaxErrorLimitReached() {
    }

    private void addParameters(Map cachedParams, RequestWrapper rw, ServletWrapper sw) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.addContextPath(rw, cachedParams);
        this.addScheme(rw, cachedParams);
        this.addServerName(rw, cachedParams);
        this.addServerPort(rw, cachedParams);
        this.addURL(rw, cachedParams);
        this.addURLQuery(rw, cachedParams);
        this.addReferingURLHeader(rw, cachedParams);
        this.addCorGuid(rw, cachedParams);
        if (this.ttc.isSessionIdPropagationEnabled()) {
            this.addSessionID(rw, cachedParams);
        }
        this.addServletContextName(sw, rw, cachedParams);
        this.addHttpMethod(rw, cachedParams);
    }

    private void addServletContextName(ServletWrapper sw, RequestWrapper rw, Map cachedParams) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String appName = rw.getApplicationNameFromServlet(sw);
        if (appName != null) {
            cachedParams.put("Application Name", appName);
        }
    }

    private void addCorGuid(RequestWrapper rw, Map cachedParams) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        RequestGetAttributeAccessor accessor = new RequestGetAttributeAccessor("x-wily-guid");
        String guid = accessor.IParameterAccessor_accessParameter(rw, null);
        if (guid != null && !guid.equals("0")) {
            cachedParams.put("CorGUID", guid);
        }
    }

    private void addReferingURLHeader(RequestWrapper rw, Map cachedParams) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        GetHeaderAccessor accessor = new GetHeaderAccessor("Referer");
        String referringURL = accessor.IParameterAccessor_accessParameter(rw, null);
        if (referringURL != null) {
            cachedParams.put("Refering URL", referringURL);
        }
    }

    private void addURLQuery(RequestWrapper rw, Map cachedParams) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String queryString = rw.getQueryString();
        if (queryString != null) {
            cachedParams.put("URL Query", queryString);
        }
    }

    private void addURL(RequestWrapper rw, Map cachedParams) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String url = rw.getRequestURI();
        if (url != null) {
            cachedParams.put("URL", url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUserID(RequestWrapper rw, Map cachedParams) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        LoaderContext loaderContext = this.fCurrentContext;
        synchronized (loaderContext) {
            String userID;
            if (this.fCurrentContext.fUserIdAccessor != null && (userID = this.fCurrentContext.fUserIdAccessor.IUserIDAccessor_accessUserID(rw)) != null) {
                cachedParams.put("User ID", userID);
            }
        }
    }

    private void addSessionID(RequestWrapper rw, Map cachedParams) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        SessionWrapper session = rw.getSession(false);
        if (session == null) {
            String requestedSessionId = rw.getRequestedSessionId();
            if (requestedSessionId != null) {
                cachedParams.put("Session ID", requestedSessionId.toString());
            }
            return;
        }
        String sessionId = session.getId();
        cachedParams.put("Session ID", sessionId.toString());
    }

    private void addServerPort(RequestWrapper rw, Map cachedParams) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String serverPort = Integer.toString(rw.getServerPort());
        cachedParams.put("Server Port", serverPort);
    }

    private void addServerName(RequestWrapper rw, Map cachedParams) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String serverName = rw.getServerName();
        if (serverName != null) {
            cachedParams.put("Server Name", serverName);
        }
    }

    private void addScheme(RequestWrapper rw, Map cachedParams) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String scheme = rw.getScheme();
        if (scheme != null) {
            cachedParams.put("Scheme", scheme);
        }
    }

    private void addHttpMethod(RequestWrapper rw, Map cachedParams) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String method = rw.getHttpMethod();
        if (method != null) {
            cachedParams.put("HTTP Method", method);
        }
    }

    private void addContextPath(RequestWrapper rw, Map cachedParams) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String contextPath = rw.getContextPath();
        if (contextPath != null) {
            cachedParams.put("Context Path", contextPath);
        }
    }

    static class GetHeaderAccessor
    extends LoaderContext.AParameterAccessor {
        private final String fHeaderName;

        public GetHeaderAccessor(String key) {
            super("httprequest.header." + key);
            this.fHeaderName = key;
        }

        public String IParameterAccessor_accessParameter(RequestWrapper request, String encoding) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
            if (encoding != null) {
                request.setCharacterEncoding(encoding);
            }
            return request.getHeader(this.fHeaderName);
        }
    }

    static final class GetHeaderUserIDAccessor
    extends GetHeaderAccessor
    implements LoaderContext.IUserIDAccessor {
        private String fEncoding;

        public GetHeaderUserIDAccessor(String key, String encoding) {
            super(key);
            this.fEncoding = encoding;
        }

        public String IUserIDAccessor_accessUserID(RequestWrapper request) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
            return this.IParameterAccessor_accessParameter(request, this.fEncoding);
        }
    }

    static final class GetRemoteUserUserIDAccessor
    implements LoaderContext.IUserIDAccessor {
        GetRemoteUserUserIDAccessor() {
        }

        public String IUserIDAccessor_accessUserID(RequestWrapper request) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
            return request.getRemoteUser();
        }
    }

    static class RequestGetAttributeAccessor
    extends LoaderContext.AParameterAccessor {
        private String fAttributeName;

        public RequestGetAttributeAccessor(String key) {
            super("httprequest.attribute." + key);
            this.fAttributeName = key;
        }

        public String IParameterAccessor_accessParameter(RequestWrapper request, String encoding) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
            if (encoding != null) {
                request.setCharacterEncoding(encoding);
            }
            return request.getAttribute(this.fAttributeName);
        }
    }

    static class RequestGetParameterAccessor
    extends LoaderContext.AParameterAccessor {
        private final String fParameterName;

        public RequestGetParameterAccessor(String key) {
            super("httprequest.parameter." + key);
            this.fParameterName = key;
        }

        public String IParameterAccessor_accessParameter(RequestWrapper request, String encoding) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
            if (encoding != null) {
                request.setCharacterEncoding(encoding);
            }
            return request.getParameter(this.fParameterName);
        }
    }

    static class SessionGetAttributeAccessor
    extends LoaderContext.AParameterAccessor {
        private final String fName;

        public SessionGetAttributeAccessor(String key) {
            super("httpsession.attribute." + key);
            this.fName = key;
        }

        public String IParameterAccessor_accessParameter(RequestWrapper request, String encoding) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
            Object value;
            SessionWrapper session = request.getSession(false);
            if (session == null) {
                return null;
            }
            try {
                value = session.getAttribute(this.fName);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                value = session.getValue(this.fName);
            }
            return value == null ? null : value.toString();
        }
    }

    static final class SessionGetAttributeUserIdAccessor
    extends SessionGetAttributeAccessor
    implements LoaderContext.IUserIDAccessor {
        public SessionGetAttributeUserIdAccessor(String key) {
            super(key);
        }

        public String IUserIDAccessor_accessUserID(RequestWrapper request) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
            return this.IParameterAccessor_accessParameter(request, null);
        }
    }
}

