/*
 * Decompiled with CFR 0.152.
 */
package com.wily.org.apache.commons.httpclient.cookie;

import com.wily.org.apache.commons.httpclient.cookie.CookieSpec;
import com.wily.org.apache.commons.httpclient.cookie.CookieSpecBase;
import com.wily.org.apache.commons.httpclient.cookie.NetscapeDraftSpec;
import com.wily.org.apache.commons.httpclient.cookie.RFC2109Spec;
import com.wily.org.apache.commons.logging.Log;
import com.wily.org.apache.commons.logging.LogFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class CookiePolicy {
    private static Map SPECS = Collections.synchronizedMap(new HashMap());
    public static final String BROWSER_COMPATIBILITY = "compatibility";
    public static final String NETSCAPE = "netscape";
    public static final String RFC_2109 = "rfc2109";
    public static final String IGNORE_COOKIES = "ignoreCookies";
    public static final String DEFAULT = "default";
    public static final int COMPATIBILITY = 0;
    public static final int NETSCAPE_DRAFT = 1;
    public static final int RFC2109 = 2;
    private static int defaultPolicy;
    protected static final Log LOG;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.wily.org.apache.commons.httpclient.cookie.RFC2109Spec");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CookiePolicy.registerCookieSpec(DEFAULT, clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.wily.org.apache.commons.httpclient.cookie.RFC2109Spec");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CookiePolicy.registerCookieSpec(RFC_2109, clazz2);
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("com.wily.org.apache.commons.httpclient.cookie.CookieSpecBase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CookiePolicy.registerCookieSpec(BROWSER_COMPATIBILITY, clazz3);
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("com.wily.org.apache.commons.httpclient.cookie.NetscapeDraftSpec");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CookiePolicy.registerCookieSpec(NETSCAPE, clazz4);
        Class<?> clazz5 = class$3;
        if (clazz5 == null) {
            try {
                clazz5 = class$3 = Class.forName("com.wily.org.apache.commons.httpclient.cookie.IgnoreCookiesSpec");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CookiePolicy.registerCookieSpec(IGNORE_COOKIES, clazz5);
        defaultPolicy = 2;
        Class<?> clazz6 = class$4;
        if (clazz6 == null) {
            try {
                clazz6 = class$4 = Class.forName("com.wily.org.apache.commons.httpclient.cookie.CookiePolicy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog(clazz6);
    }

    public static void registerCookieSpec(String id, Class clazz) {
        if (id == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Cookie spec class may not be null");
        }
        SPECS.put(id.toLowerCase(), clazz);
    }

    public static void unregisterCookieSpec(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        SPECS.remove(id.toLowerCase());
    }

    public static CookieSpec getCookieSpec(String id) throws IllegalStateException {
        if (id == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        Class clazz = (Class)SPECS.get(id.toLowerCase());
        if (clazz != null) {
            try {
                return (CookieSpec)clazz.newInstance();
            }
            catch (Exception e) {
                LOG.error("Error initializing cookie spec: " + id, e);
                throw new IllegalStateException(String.valueOf(id) + " cookie spec implemented by " + clazz.getName() + " could not be initialized");
            }
        }
        throw new IllegalStateException("Unsupported cookie spec " + id);
    }

    public static int getDefaultPolicy() {
        return defaultPolicy;
    }

    public static void setDefaultPolicy(int policy) {
        defaultPolicy = policy;
    }

    public static CookieSpec getSpecByPolicy(int policy) {
        switch (policy) {
            case 0: {
                return new CookieSpecBase();
            }
            case 1: {
                return new NetscapeDraftSpec();
            }
            case 2: {
                return new RFC2109Spec();
            }
        }
        return CookiePolicy.getDefaultSpec();
    }

    public static CookieSpec getDefaultSpec() {
        try {
            return CookiePolicy.getCookieSpec(DEFAULT);
        }
        catch (IllegalStateException e) {
            LOG.warn("Default cookie policy is not registered");
            return new RFC2109Spec();
        }
    }

    public static CookieSpec getSpecByVersion(int ver) {
        switch (ver) {
            case 0: {
                return new NetscapeDraftSpec();
            }
            case 1: {
                return new RFC2109Spec();
            }
        }
        return CookiePolicy.getDefaultSpec();
    }

    public static CookieSpec getCompatibilitySpec() {
        return CookiePolicy.getSpecByPolicy(0);
    }
}

