/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.spec;

import com.wily.rave.utils.HashCodeUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;

public final class Digest
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final char[] kHexStringChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private byte[] bytes;

    public Digest() {
    }

    public Digest(byte[] digestBytes) {
        if (digestBytes == null || digestBytes.length == 0) {
            throw new IllegalArgumentException("Invalid digest: " + digestBytes);
        }
        this.bytes = digestBytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Digest)) {
            return false;
        }
        Digest otherDigest = (Digest)obj;
        return Arrays.equals(this.bytes, otherDigest.bytes);
    }

    public int hashCode() {
        int hashCode = 0;
        int i = 0;
        while (i < this.bytes.length) {
            hashCode = HashCodeUtils.accumulateHashCode(hashCode, this.bytes[i]);
            ++i;
        }
        return hashCode;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.bytes.length);
        int i = 0;
        while (i < this.bytes.length) {
            int highNybble = this.bytes[i] >> 4 & 0xF;
            buf.append(kHexStringChars[highNybble]);
            int lowNybble = this.bytes[i] & 0xF;
            buf.append(kHexStringChars[lowNybble]);
            ++i;
        }
        return buf.toString();
    }

    @Override
    public void writeExternal(ObjectOutput oo) throws IOException {
        oo.writeObject("Digest_8.0 ");
        oo.writeInt(this.bytes.length);
        oo.write(this.bytes);
    }

    @Override
    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        Object checkObj = oi.readObject();
        if (checkObj instanceof String) {
            int length = oi.readInt();
            this.bytes = new byte[length];
            oi.readFully(this.bytes);
        } else {
            this.bytes = (byte[])checkObj;
        }
    }
}

