/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.spec.ds.filemonitor;

import com.wily.rave.spec.IContentMetadataItem;
import com.wily.rave.spec.IContentSummary;
import com.wily.rave.spec.IDataSourceInstance;
import com.wily.rave.spec.SimpleContentMetadataItem;
import com.wily.rave.utils.FastMD5Encoder;
import com.wily.rave.utils.HashCodeUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.util.Arrays;

public class FileContentSummary
implements IContentSummary,
Externalizable {
    private static final long serialVersionUID = 2L;
    static final String LAST_MODIFIED_TIME = "Last Time Modified";
    static final String CURRENT_SIZE = "File Size";
    static final String DIGEST_STRING = "Digest";
    private static final IContentMetadataItem[] EMPTY_CONTENT_METADATA_ARRAY = new IContentMetadataItem[0];
    private String fFileName;
    private IDataSourceInstance fDataSourceInstance;
    private String fFileOwner;
    private long lastModifiedTimestamp = -1L;
    private long size = -1L;
    private byte[] digestByteArray = null;
    private transient IContentMetadataItem[] metadataContent = null;

    public FileContentSummary() {
        if (this.lastModifiedTimestamp == this.size) {
            this.lastModifiedTimestamp = this.size;
        }
    }

    FileContentSummary(IDataSourceInstance dsInstance, String fileName, String fileOwner, long lastModifiedTimestamp, long size) {
        this.fDataSourceInstance = dsInstance;
        this.fFileName = fileName.intern();
        this.lastModifiedTimestamp = lastModifiedTimestamp;
        this.fFileOwner = fileOwner;
        this.size = size;
    }

    FileContentSummary(IDataSourceInstance dsInstance, String fileName, String fileOwner, long lastModifiedTimestamp, long size, byte[] digest) {
        this.fDataSourceInstance = dsInstance;
        this.fFileName = fileName.intern();
        this.fFileOwner = fileOwner;
        this.lastModifiedTimestamp = lastModifiedTimestamp;
        this.size = size;
        this.digestByteArray = digest;
    }

    @Override
    public void writeExternal(ObjectOutput oo) throws IOException {
        oo.writeUTF(this.fFileName);
        oo.writeObject("FileContentSummary_8.0");
        oo.writeObject(this.fFileOwner);
        oo.writeLong(2L);
        oo.writeInt(this.digestByteArray != null ? this.digestByteArray.length : 0);
        if (this.digestByteArray != null) {
            oo.write(this.digestByteArray);
        }
        oo.writeObject(this.fDataSourceInstance);
        oo.writeLong(this.lastModifiedTimestamp);
        oo.writeLong(this.size);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        this.fFileName = oi.readUTF().intern();
        Object object = null;
        Object ownerOrSID = oi.readObject();
        if (ownerOrSID instanceof String) {
            this.fFileOwner = (String)oi.readObject();
            long oiLong = oi.readLong();
            object = new Long(oiLong);
        } else {
            this.fFileOwner = "";
            object = ownerOrSID;
        }
        if (object instanceof Long) {
            long serialUID = (Long)object;
            if (serialUID != 2L) throw new ClassNotFoundException("Unknown serialVersionUID for FileContentSummary: " + serialUID);
            int oiInt = oi.readInt();
            object = new Integer(oiInt);
            int digestBytes = (Integer)object;
            if (digestBytes == 0) {
                this.digestByteArray = null;
            } else {
                this.digestByteArray = new byte[digestBytes];
                oi.readFully(this.digestByteArray);
            }
            this.fDataSourceInstance = (IDataSourceInstance)oi.readObject();
        } else if (object instanceof IDataSourceInstance) {
            this.fDataSourceInstance = (IDataSourceInstance)object;
        }
        this.lastModifiedTimestamp = oi.readLong();
        this.size = oi.readLong();
    }

    @Override
    public String getResourceOwner() {
        return this.fFileOwner;
    }

    @Override
    public long getChangeTimestamp() {
        return this.lastModifiedTimestamp;
    }

    @Override
    public String getResourceName() {
        return this.fFileName;
    }

    public boolean hasDigest() {
        return this.digestByteArray != null;
    }

    public byte[] getDigest() {
        return this.digestByteArray;
    }

    @Override
    public IDataSourceInstance getDataSourceInstance() {
        return this.fDataSourceInstance;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof FileContentSummary) {
            FileContentSummary otherFileContentSummary = (FileContentSummary)other;
            if (this.fFileName.equals(otherFileContentSummary.fFileName) && this.fDataSourceInstance.equals(otherFileContentSummary.fDataSourceInstance) && this.lastModifiedTimestamp == otherFileContentSummary.lastModifiedTimestamp && this.size == otherFileContentSummary.size) {
                byte[] thisDigest = this.digestByteArray;
                byte[] otherDigest = otherFileContentSummary.digestByteArray;
                if (thisDigest == null) {
                    return otherDigest == null;
                }
                if (otherDigest == null) {
                    return false;
                }
                return Arrays.equals(thisDigest, otherDigest);
            }
        }
        return false;
    }

    public int hashCode() {
        int code = HashCodeUtils.accumulateHashCode(this.fDataSourceInstance.hashCode(), this.fFileName);
        code = HashCodeUtils.accumulateHashCode(code, this.lastModifiedTimestamp);
        code = HashCodeUtils.accumulateHashCode(code, this.size);
        code = HashCodeUtils.accumulateHashCode(code, this.digestByteArray != null);
        return code;
    }

    @Override
    public IContentMetadataItem[] getMetadata() {
        if (this.metadataContent == null) {
            if (this.size < 0L) {
                this.metadataContent = EMPTY_CONTENT_METADATA_ARRAY;
            } else {
                int numItems = this.digestByteArray != null ? 2 : 1;
                this.metadataContent = new IContentMetadataItem[numItems];
                this.metadataContent[0] = new SimpleContentMetadataItem(CURRENT_SIZE, Long.toString(this.size));
                if (this.digestByteArray != null) {
                    this.metadataContent[1] = new SimpleContentMetadataItem(DIGEST_STRING, FastMD5Encoder.bytesToHex(this.digestByteArray));
                }
            }
        }
        return this.metadataContent;
    }

    @Override
    public boolean hasMetadata() {
        return true;
    }

    public long getSize() {
        return this.size;
    }

    public long getLastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.fFileName = this.fFileName.intern();
    }
}

