/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.spec.ds.classmonitor;

import com.wily.rave.spec.IContent;
import com.wily.rave.spec.IContentChange;
import com.wily.rave.spec.IContentMetadataItem;
import com.wily.rave.spec.IContentMetadataItemChange;
import com.wily.rave.spec.SimpleContentMetadataItemChange;
import com.wily.rave.spec.ds.classmonitor.ClassContent;
import com.wily.wilyassert.Assertion;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ClassContentChange
implements IContentChange,
Externalizable {
    private static final long serialVersionUID = 1L;
    private ClassContent laterContent;
    private ClassContent previousContent;
    private long detectionTime;
    private transient IContentMetadataItemChange[] metadataChange;

    public ClassContentChange() {
    }

    ClassContentChange(ClassContent content, ClassContent priorContent, long detectionTime) {
        this.laterContent = content;
        this.previousContent = priorContent;
        this.detectionTime = detectionTime;
    }

    @Override
    public boolean hasMetadata() {
        return true;
    }

    @Override
    public IContentMetadataItemChange[] getContentMetadataChange() {
        if (this.metadataChange == null) {
            IContentMetadataItem[] laterMetadata;
            IContentMetadataItem[] prevMetadata = this.previousContent.getMetadata();
            Assertion.wilyAssert(prevMetadata.length == (laterMetadata = this.laterContent.getMetadata()).length);
            this.metadataChange = new SimpleContentMetadataItemChange[prevMetadata.length];
            int i = 0;
            while (i < prevMetadata.length) {
                Assertion.wilyAssert(prevMetadata[i].getItemName().equals(laterMetadata[i].getItemName()));
                this.metadataChange[i] = new SimpleContentMetadataItemChange(prevMetadata[i].getItemName(), prevMetadata[i].getItemValue().toString(), laterMetadata[i].getItemValue().toString());
                ++i;
            }
        }
        return this.metadataChange;
    }

    @Override
    public IContent getPreviousContent() {
        return this.previousContent;
    }

    @Override
    public IContent getLaterContent() {
        return this.laterContent;
    }

    @Override
    public long getChangeDetectionTime() {
        return this.detectionTime;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.detectionTime);
        out.writeObject(this.laterContent);
        out.writeObject(this.previousContent);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.detectionTime = in.readLong();
        this.laterContent = (ClassContent)in.readObject();
        this.previousContent = (ClassContent)in.readObject();
    }
}

