/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.spec.ds.filemonitor;

import com.wily.rave.spec.IContent;
import com.wily.rave.spec.IContentChange;
import com.wily.rave.spec.IContentMetadataItem;
import com.wily.rave.spec.IContentSummary;
import com.wily.rave.spec.IContentValue;
import com.wily.rave.spec.IDataSourceInstance;
import com.wily.rave.spec.InvalidContent;
import com.wily.rave.spec.ds.filemonitor.FileContentChange;
import com.wily.rave.spec.ds.filemonitor.FileContentSummary;
import com.wily.rave.spec.ds.filemonitor.FileContentValue;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class FileContent
implements IContent,
Externalizable {
    private static final long serialVersionUID = 1L;
    private IContentValue fileContentValue;
    private FileContentSummary contentSummary;

    public FileContent() {
    }

    public FileContent(IDataSourceInstance dsInstance, String fileName, String fileOwner, FileContentValue fileContentValue, long lastModifiedTimestamp, long size) {
        this.contentSummary = new FileContentSummary(dsInstance, fileName, fileOwner, lastModifiedTimestamp, size);
        this.fileContentValue = fileContentValue;
    }

    public FileContent(IDataSourceInstance dsInstance, String fileName, String fileOwner, long lastModifiedTimestamp, long size) {
        this.contentSummary = new FileContentSummary(dsInstance, fileName, fileOwner, lastModifiedTimestamp, size);
    }

    public FileContent(IDataSourceInstance dsInstance, String fileName, String fileOwner, FileContentValue fileContentValue, long lastModifiedTimestamp, long size, byte[] digest) {
        this.contentSummary = new FileContentSummary(dsInstance, fileName, fileOwner, lastModifiedTimestamp, size, digest);
        this.fileContentValue = fileContentValue;
    }

    public FileContent(IDataSourceInstance dsInstance, String fileName, String fileOwner, long lastModifiedTimestamp, long size, byte[] digest) {
        this.contentSummary = new FileContentSummary(dsInstance, fileName, fileOwner, lastModifiedTimestamp, size, digest);
    }

    @Override
    public void writeExternal(ObjectOutput oo) throws IOException {
        oo.writeObject(this.fileContentValue);
        oo.writeObject(this.contentSummary);
    }

    @Override
    public void readExternal(ObjectInput oi) throws ClassNotFoundException, IOException {
        this.fileContentValue = (IContentValue)oi.readObject();
        this.contentSummary = (FileContentSummary)oi.readObject();
    }

    @Override
    public String getResourceName() {
        return this.contentSummary.getResourceName();
    }

    public boolean hasDigest() {
        return this.contentSummary.hasDigest();
    }

    public byte[] getDigest() {
        return this.contentSummary.getDigest();
    }

    @Override
    public IContentValue getResourceValue() {
        return this.fileContentValue;
    }

    public boolean contentsAvailable() {
        return this.fileContentValue == null;
    }

    @Override
    public IDataSourceInstance getDataSourceInstance() {
        return this.contentSummary.getDataSourceInstance();
    }

    @Override
    public IContentSummary getContentSummary() {
        return this.contentSummary;
    }

    @Override
    public IContentChange getChange(long changeDetectionTime, IContent priorContent) throws InvalidContent {
        if (!(priorContent instanceof FileContent)) {
            throw new InvalidContent("Not same type content! This: " + FileContent.class.getName() + "; prior content: " + priorContent.getClass().getName());
        }
        FileContent priorFile = (FileContent)priorContent;
        return new FileContentChange(changeDetectionTime, priorFile, this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof FileContent) {
            FileContent otherFileContent = (FileContent)other;
            if (this.contentSummary.equals(otherFileContent.contentSummary)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.contentSummary.hashCode();
    }

    @Override
    public IContentMetadataItem[] getMetadata() {
        return this.contentSummary.getMetadata();
    }

    @Override
    public boolean hasMetadata() {
        return this.contentSummary.hasMetadata();
    }

    @Override
    public String getResourceOwner() {
        return this.contentSummary.getResourceOwner();
    }

    public long getLastModifiedTimestamp() {
        return this.contentSummary.getLastModifiedTimestamp();
    }

    public long getSize() {
        return this.contentSummary.getSize();
    }
}

