/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class TmpFile {
    private static final Set refSet = Collections.synchronizedSet(new HashSet());

    public static final void regTmpFile(File tmpFile) {
        refSet.add(new TmpFileRef(tmpFile));
    }

    public static void deleteAllFiles(File dir) throws IOException {
        if (dir.exists()) {
            Filter.deleteAllFiles(dir);
        }
    }

    private static class Filter
    implements FileFilter {
        private static final Filter filter = new Filter();

        private Filter() {
        }

        private static void deleteAllFiles(File dir) throws IOException {
            File[] files = dir.listFiles(filter);
            if (files.length > 0) {
                throw new IOException("Failed to delete " + files.length + " files. The first one was " + files[0]);
            }
        }

        @Override
        public boolean accept(File file) {
            return !file.delete();
        }
    }

    private static final class TmpFileRef
    extends WeakReference {
        private static final ReferenceQueue queue = new ReferenceQueue();
        private final String dirPath;
        private final String fileName;

        private TmpFileRef(File tmpFile) {
            super(tmpFile, queue);
            tmpFile.deleteOnExit();
            String tmp = tmpFile.getParent();
            this.dirPath = tmp == null ? null : tmp.intern();
            this.fileName = tmpFile.getName();
        }

        @Override
        public boolean enqueue() {
            new File(this.dirPath, this.fileName).delete();
            refSet.remove(this);
            return false;
        }
    }
}

