/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.fault.cxf.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.feature.FaultFeature;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.powerpack.webservices.KConstants;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.hc2.WebServiceBlamePointTracer;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import java.util.HashMap;
import java.util.Map;

public class CXFAsyncResponseClientFaultTracer
extends WebServiceBlamePointTracer
implements KConstants {
    protected IModuleFeedbackChannel logger = null;

    public CXFAsyncResponseClientFaultTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.logger = agent.IAgent_getModuleFeedback();
        WSMUtils.refreshLogLevels();
    }

    public void ITracer_finishTrace(int index, InvocationData data) {
        try {
            if (data.get("isAsync") == null) {
                return;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Finished SOAP Fault Trace:" + this.getTitle());
            }
            String faultErrorMessage = this.getFaultMessage(data);
            data.put("faultErrorMessage", (Object)faultErrorMessage);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Fault Error message:" + faultErrorMessage);
            }
            String componentforFault = this.getFormattedName();
            this.logger.debug("CXFASyncResponseClientFaultTracer::componentforFault" + componentforFault);
            int nOperationIndex = componentforFault.indexOf("{operationname}");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.valueOf(this.getTitle()) + "_finishTrace nOperationIndex= " + nOperationIndex + " componentForFault=" + componentforFault);
            }
            if (faultErrorMessage != null && !faultErrorMessage.equals("") && nOperationIndex != -1) {
                this.reportFault("SOAP Fault:" + faultErrorMessage, data);
            }
            String component = data.getComponentNameAt(index);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ITracer_finishTrace component=" + component);
            }
            super.ITracer_finishTrace(index, data);
        }
        catch (Exception e) {
            WSMUtils.handleException(this.getAgent(), "CXFAsyncResponseClientFaultTracer:ITracer_finishTrace exception", e);
        }
    }

    @Override
    public void ITracer_startTrace(int index, InvocationData data) {
        try {
            Object objClientImpl;
            Map mapRequestContext;
            Boolean isAsync;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Started CXFAsyncResponseClientFaultTracer");
            }
            if (!(isAsync = (Boolean)(mapRequestContext = (Map)(objClientImpl = data.getInvocationObject()).getClass().getMethod("getRequestContext", new Class[0]).invoke(objClientImpl, new Object[0])).get("com.wily.cxf.jaxws.client.isAsync")).booleanValue()) {
                return;
            }
            data.put("com.wily.powerpack.webservices.trace.NamespaceKey", mapRequestContext.get("com.wily.powerpack.webservices.trace.NamespaceKey"));
            data.put("com.wily.powerpack.webservices.trace.OperationNameKey", mapRequestContext.get("com.wily.powerpack.webservices.trace.OperationNameKey"));
            data.put("com.wily.powerpack.webservices.trace.ServiceNameKey", mapRequestContext.get("com.wily.powerpack.webservices.trace.ServiceNameKey"));
            data.put("isPopulated", (Object)true);
            data.put("isAsync", (Object)true);
            String component = this.getComponentName(data);
            this.logger.debug("CXFAsyncResponseClientFaultTracer:ITracer_startTrace component=" + component);
            super.doStartBlamePointTrace(index, data);
        }
        catch (Exception e) {
            WSMUtils.handleException(this.getAgent(), "CXFAsyncResponseClientFaultTracer:ITracer_startTrace exception", e);
        }
    }

    protected String getFaultMessage(InvocationData data) {
        try {
            Throwable error = data.getInvocationThrownException();
            if (error != null) {
                return error.getMessage();
            }
            Object objMessage = data.getInvocationParameterAsObject(0);
            Object objExchange = WSMUtils.invokeMethodOnObject(objMessage, "getExchange");
            Object objInFaultMessage = WSMUtils.invokeMethodOnObject(objExchange, "getInFaultMessage");
            return WSMUtils.invokeMethodOnObject(objInFaultMessage, "getContent", new Class[]{Class.class}, new Object[]{Exception.class}).toString();
        }
        catch (Exception e) {
            WSMUtils.handleException(this.getAgent(), "CXFAsyncResponseClientFaultTracer:ITracer_finishTrace", e);
            return null;
        }
    }

    protected String getTitle() {
        return "CXF Async Client Fault Tracer";
    }

    protected void reportFault(String message, InvocationData data) {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.valueOf(this.getTitle()) + " reportFault message " + message);
            }
            FaultFeature.constructAndSendFaultSnapshotToServer((InvocationData)data, (String)message, (IAgent)this.getAgent());
            FaultFeature.decorateTransactionsWithFault((InvocationData)data, (String)message);
        }
        catch (Throwable t) {
            WSMUtils.handleException(this.getAgent(), "CXFAsyncResponseClientFaultTracer:reportFault", t);
        }
    }

    @Override
    protected WilyTransactionElement constructTransactionElement(Object key, String metricName, int blameStatus, boolean isStartTrace, ITransactionElement parent, IBlameTransactionElement previous, IBlameTransactionElement start, ProbeInformation info) {
        HashMap metrics = new HashMap(5);
        IRepository concurrentSds = null;
        IRepository timerSds = null;
        IRepository stallSds = null;
        IRepository errorsSds = null;
        IRepository perIntervalSds = null;
        AgentMetric[] faultMetric = this.createFaultsMetric(this.getFormattedMetricName(metricName));
        return FaultFeature.createFaultedBlameTransactionElement((Object)key, (String)metricName, (int)blameStatus, (boolean)true, (ITransactionElement)parent, (IBlameTransactionElement)previous, null, metrics, timerSds, perIntervalSds, concurrentSds, errorsSds, stallSds, (ProbeInformation)info, (AgentMetric[])faultMetric, (boolean)this.subscribeToDownstreamErrors(), (boolean)this.subscribeToDownstreamStalls(), (boolean)this.subscribeToDownstreamFaults());
    }

    protected void updateCustomMetricsIfAny(WilyTransactionElement start, InvocationData data) {
        String faultErrorMessage = (String)data.get("faultErrorMessage");
        if (faultErrorMessage != null && !faultErrorMessage.equals("")) {
            FaultFeature.incrementFaultMetric((InvocationData)data);
        }
    }
}

