/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent;

import com.wily.apm.spec.server.beans.clamp.AgentMonitorEventContext;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.connection.AgentMetricClampCommand;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;

public class AgentEventPublisher {
    private static final String kAgentMetricClampEventType = "introscope.agent.metricClamp";
    private static String fAgentMetricClampEventSource = "<AgentName>";
    private static final String EVENT_METRIC_CLAMP_MSG = "CLAMP EVENT: Agent was not clamped before; New metric has been created and agent has hit the metric clamp.";
    private static final String EVENT_METRIC_UNCLAMP_MSG = "UNCLAMP EVENT: Agent was clamped before; Metric ageing occured or metric clamp size is increased, now agent is not clamped anymore.";
    public static final byte EVENT_METRIC_CLAMPED = 1;
    public static final byte EVENT_METRIC_UNCLAMPED = 2;
    private static AgentEventPublisher instance = new AgentEventPublisher();
    private volatile IAgent fAgent;
    final Object lock = new Object();

    private AgentEventPublisher() {
    }

    public static AgentEventPublisher getInstance(IAgent agent) {
        AgentEventPublisher.instance.fAgent = agent;
        fAgentMetricClampEventSource = agent.IAgent_getName();
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishClampEvent(int threshold, int currValue, boolean isClamped) {
        block8: {
            AgentMonitorEventContext eventContext = null;
            try {
                AgentMonitorEventContext.Builder eventContextBuilder = new AgentMonitorEventContext.Builder(fAgentMetricClampEventSource, kAgentMetricClampEventType, new Integer(threshold), new Integer(currValue));
                if (isClamped) {
                    eventContext = eventContextBuilder.context(EVENT_METRIC_CLAMP_MSG).build();
                    this.fAgent.IAgent_getModuleFeedback().info(EVENT_METRIC_CLAMP_MSG);
                } else {
                    eventContext = eventContextBuilder.context(EVENT_METRIC_UNCLAMP_MSG).build();
                    this.fAgent.IAgent_getModuleFeedback().info(EVENT_METRIC_UNCLAMP_MSG);
                }
                if (eventContext != null) {
                    IsengardServerConnectionManager manager = this.fAgent.IAgent_getIsengardServerConnection();
                    if (manager == null || manager.getConnectedServer() == null || !manager.getConnectedServer().isConnected()) break block8;
                    AgentMetricClampCommand command = new AgentMetricClampCommand(eventContext);
                    Object object = this.lock;
                    synchronized (object) {
                        manager.addToCommandQueue(command);
                        break block8;
                    }
                }
                this.fAgent.IAgent_getModuleFeedback().warn("Could not build event context to generate the metric clamp/unclamp events.");
            }
            catch (Exception exception) {}
        }
    }
}

