/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.connection.failover;

import com.wily.introscope.agent.connection.IServerFailoverPolicy;
import com.wily.introscope.spec.server.beans.loadbalancing.AdvancedReconnectInfo;
import com.wily.introscope.spec.server.beans.loadbalancing.ReconnectInfo;
import com.wily.isengard.api.ServerInstanceLocator;

public class RoundRobinServerFailoverPolicy
implements IServerFailoverPolicy {
    public static final int kFinishedCycle = 1;
    private final long fPauseBetweenCyclesInMillis;
    private final ServerInstanceLocator[] fServerInstanceLocators;
    private ServerInstanceLocator fLastAuthortativeServer;
    private AdvancedReconnectInfo fDownloadedInstanceLocators;
    private ServerInstanceLocator fLastDisallowedServer;
    private volatile int fNextDownloadedLocatorToReturnIndex;
    private volatile boolean fBounceBackToLastAuthoritativeServer = true;
    private volatile int fNextLocatorToReturnIndex;
    private volatile int fCycleCount;
    private int fAttemptCount = 1;
    private volatile boolean fPauseOnNextConnection;
    private final int fReconnectDelayInSeconds;
    private final int fFailbackRetryIntervalInSeconds;
    private volatile int fCurrentConnectionIndex = -1;
    private boolean fPreviouslyConnected;

    public RoundRobinServerFailoverPolicy(ServerInstanceLocator[] serverInstanceLocators, long pauseBetweenCyclesInMillis, int reconnectDelayInSeconds, int failbackRetryIntervalInSeconds) {
        this.fServerInstanceLocators = serverInstanceLocators;
        this.fPauseBetweenCyclesInMillis = pauseBetweenCyclesInMillis;
        this.fReconnectDelayInSeconds = reconnectDelayInSeconds;
        this.fFailbackRetryIntervalInSeconds = failbackRetryIntervalInSeconds;
        this.fPreviouslyConnected = false;
        this.reset();
    }

    public void resetFailoverCounters() {
        this.fCycleCount = 0;
        this.fNextDownloadedLocatorToReturnIndex = 0;
        this.fNextLocatorToReturnIndex = 0;
    }

    public ServerInstanceLocator getNextFailoverServer() {
        if (this.fDownloadedInstanceLocators != null && this.fLastAuthortativeServer != null && this.fNextDownloadedLocatorToReturnIndex < this.fDownloadedInstanceLocators.getNumConnections()) {
            ReconnectInfo info = this.fDownloadedInstanceLocators.getConnection(this.fNextDownloadedLocatorToReturnIndex++);
            ServerInstanceLocator nextServerLocator = ServerInstanceLocator.copyOf(info.getReconnectHost(), info.getReconnectPort(), this.fLastAuthortativeServer);
            return nextServerLocator;
        }
        if (this.fNextLocatorToReturnIndex < this.fServerInstanceLocators.length) {
            ServerInstanceLocator nextServerLocator = this.fServerInstanceLocators[this.fNextLocatorToReturnIndex];
            this.fCurrentConnectionIndex = this.fNextLocatorToReturnIndex++;
            return nextServerLocator;
        }
        ++this.fCycleCount;
        ++this.fAttemptCount;
        this.fPauseOnNextConnection = true;
        return null;
    }

    public int getAttemptCount() {
        return this.fAttemptCount;
    }

    public ServerInstanceLocator getFailbackServer() {
        return this.fServerInstanceLocators[0];
    }

    public void setLastAvailableServer(ServerInstanceLocator lastDisallowedServer) {
        this.fLastDisallowedServer = lastDisallowedServer;
    }

    public ServerInstanceLocator getLastAvailableServer() {
        return this.fLastDisallowedServer;
    }

    public void notifyOfSuccessfulFailbackConnection() {
        this.fCurrentConnectionIndex = 0;
        this.reset();
    }

    public long getPauseForConnectionInMillis() {
        long nextPause = 0L;
        if (this.fPauseOnNextConnection) {
            this.fPauseOnNextConnection = false;
            nextPause = this.fPauseBetweenCyclesInMillis;
        } else if (this.fPreviouslyConnected && this.fServerInstanceLocators.length == 1) {
            nextPause = this.fReconnectDelayInSeconds * 1000;
            this.fPreviouslyConnected = false;
        }
        return nextPause;
    }

    public boolean failbackEnabled() {
        return this.fFailbackRetryIntervalInSeconds > 0;
    }

    public int getFailbackRetryIntervalInSeconds() {
        return this.fFailbackRetryIntervalInSeconds;
    }

    public int getCycleCount() {
        return this.fCycleCount;
    }

    public void setCycleCount(int count) {
        this.fCycleCount = count;
    }

    public void notifyOfSuccessfulConnection() {
        this.fPreviouslyConnected = true;
        this.reset();
    }

    public void notifyOfConnectionFailure() {
        this.fCurrentConnectionIndex = -1;
    }

    public boolean setAdditionalFailoverServers(ServerInstanceLocator primaryServer, AdvancedReconnectInfo extraServers) {
        if (this.fDownloadedInstanceLocators != null && this.fDownloadedInstanceLocators.getTimestamp() > extraServers.getTimestamp()) {
            return false;
        }
        this.fLastAuthortativeServer = primaryServer;
        this.fDownloadedInstanceLocators = extraServers;
        this.fNextDownloadedLocatorToReturnIndex = 0;
        return true;
    }

    public AdvancedReconnectInfo getAdditionalFailoverServers() {
        return this.fDownloadedInstanceLocators;
    }

    public ServerInstanceLocator getAuthoritativeServer() {
        return this.fLastAuthortativeServer;
    }

    private void reset() {
        this.fNextLocatorToReturnIndex = 0;
        this.fNextDownloadedLocatorToReturnIndex = 0;
        this.fCycleCount = 0;
        this.fPauseOnNextConnection = false;
        this.fBounceBackToLastAuthoritativeServer = true;
    }

    public boolean hasHardcodedFallbackServers() {
        if (this.fServerInstanceLocators == null) {
            return false;
        }
        return this.fServerInstanceLocators.length > 1;
    }

    public void setAttemptCount(int attemptCount) {
        this.fAttemptCount = attemptCount;
    }

    public int getServerCount() {
        if (this.fDownloadedInstanceLocators != null && this.fServerInstanceLocators != null) {
            return this.fDownloadedInstanceLocators.getNumConnections() + this.fServerInstanceLocators.length;
        }
        if (this.fServerInstanceLocators != null) {
            return this.fServerInstanceLocators.length;
        }
        return 0;
    }
}

