/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.stalls;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.blamestackfeature.BlameStackFeatureBlameStack;
import com.wily.introscope.agent.blamestackfeature.BlameStackFeatureStackEntry;
import com.wily.introscope.agent.blamestackfeature.IBlameStackFeature;
import com.wily.introscope.agent.blamestackfeature.IBoundaryBlameStackFeature;
import com.wily.introscope.agent.stalls.StallFeatureStackEntry;
import com.wily.introscope.agent.stalls.StallSweeper;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.stat.blame.BlameStackSnapshot;

public class StallFeature
implements IBoundaryBlameStackFeature,
IBlameStackFeature {
    private int nextIndex;
    private final BlameStackFeatureBlameStack fStack;
    private final long stallThresholdInMillis;
    private StallFeatureStackEntry[] stackEntries;
    private int frontEndIndex = -1;
    private boolean haveForcedStallInFrontEnd;
    private int backEndIndex = -1;
    private int sweeperSlotValue;
    private boolean haveForcedStallInBackEnd = false;

    public StallFeature(long stallThreshold, BlameStackFeatureBlameStack stallStack) {
        this.stallThresholdInMillis = stallThreshold;
        this.fStack = stallStack;
        this.stackEntries = new StallFeatureStackEntry[10];
        int i = 0;
        while (i < this.stackEntries.length) {
            this.stackEntries[i] = new StallFeatureStackEntry(this.fStack, stallThreshold);
            ++i;
        }
        this.nextIndex = 0;
        this.sweeperSlotValue = StallSweeper.getNewSlotValue();
    }

    private StallFeatureStackEntry newStackEntryResizingIfNecessary(BlameStackFeatureStackEntry entry) {
        if (this.nextIndex == this.stackEntries.length) {
            StallFeatureStackEntry[] newStackEntries = new StallFeatureStackEntry[this.stackEntries.length * 2];
            System.arraycopy(this.stackEntries, 0, newStackEntries, 0, this.stackEntries.length);
            int i = this.nextIndex;
            while (i < newStackEntries.length) {
                newStackEntries[i] = new StallFeatureStackEntry(this.fStack, this.stallThresholdInMillis);
                ++i;
            }
            this.stackEntries = newStackEntries;
        }
        StallFeatureStackEntry newStackEntry = this.stackEntries[this.nextIndex];
        newStackEntry.init(entry);
        return newStackEntry;
    }

    public static IIntegerFluctuatingCounterDataAccumulator getAccumulator(String name) {
        try {
            IIntegerFluctuatingCounterDataAccumulator accumulator = AgentShim.getAgent().IAgent_getDataAccumulatorFactory().safeGetIntegerAggregatingFluctuatingCounterDataAccumulator(name);
            return accumulator;
        }
        catch (AgentNotAvailableException e) {
            AgentShim.handleError("please, someone, tell me what this means", e);
            return null;
        }
    }

    public static IIntegerFluctuatingCounterDataAccumulator getDefaultBackendAccumulator(String name) {
        try {
            IIntegerFluctuatingCounterDataAccumulator accumulator = AgentShim.getAgent().IAgent_getDataAccumulatorFactory().safeGetBackendIntegerAggregatingFluctuatingCounterDataAccumulator(name);
            return accumulator;
        }
        catch (AgentNotAvailableException e) {
            AgentShim.handleError("please, someone, tell me what this means", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBeforePush(BlameStackFeatureStackEntry entry) {
        Object object = this.getLock();
        synchronized (object) {
            this.newStackEntryResizingIfNecessary(entry).push(entry.getComponent());
            ++this.nextIndex;
        }
    }

    private Object getLock() {
        return this.fStack.getLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAfterPop(BlameStackFeatureStackEntry poppedEntry, BlameStackFeatureStackEntry newTopEntry) {
        Object object = this.getLock();
        synchronized (object) {
            this.stackEntries[this.nextIndex - 1].pop();
            if (this.stackLocationIsBackEnd()) {
                this.haveForcedStallInBackEnd = false;
            }
            if (this.stackLocationIsFrontEnd()) {
                this.haveForcedStallInFrontEnd = false;
            }
            --this.nextIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkIfStalled(long now) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.fStack.IBlameStack_isEmpty()) {
                return;
            }
            StallFeatureStackEntry entry = this.stackEntries[this.nextIndex - 1];
            boolean componentStalled = entry.checkIfStalled(now);
            if (componentStalled) {
                if (this.stackLocationIsFrontEnd()) {
                    this.haveForcedStallInFrontEnd = true;
                } else if (this.stackLocationIsDeeperThanFrontEnd() && !this.haveForcedStallInFrontEnd) {
                    int i = 0;
                    while (i < this.nextIndex) {
                        if (this.stackEntries[i] != null && this.stackEntries[i].shouldPropagateStallMetric()) {
                            this.stackEntries[i].forceStallWithoutEvent(BlameStackSnapshot.kEmptyBlameStackSnapshot);
                        }
                        ++i;
                    }
                    this.haveForcedStallInFrontEnd = true;
                }
                if (this.stackLocationIsBackEnd()) {
                    this.haveForcedStallInBackEnd = true;
                } else if (this.stackLocationIsDeeperThanBackEnd() && !this.haveForcedStallInBackEnd) {
                    StallFeatureStackEntry backendEntry = this.stackEntries[this.backEndIndex];
                    backendEntry.forceStallWithoutEvent(this.fStack.IBlameStack_getSnapshot(backendEntry.getComponent()));
                    this.haveForcedStallInBackEnd = true;
                }
            } else {
                if (this.stackLocationIsDeeperThanBackEnd() && this.stackEntries[this.backEndIndex].checkIfStalled(now)) {
                    this.haveForcedStallInBackEnd = true;
                }
                if (this.stackLocationIsDeeperThanFrontEnd() && this.stackEntries[this.frontEndIndex].checkIfStalled(now)) {
                    this.haveForcedStallInFrontEnd = true;
                }
            }
        }
    }

    private boolean stackLocationIsFrontEnd() {
        return this.hasFrontEndBeenSet() && this.nextIndex - 1 == this.frontEndIndex;
    }

    private boolean stackLocationIsDeeperThanBackEnd() {
        return this.hasBackendBeentSet() && this.nextIndex - 1 > this.backEndIndex;
    }

    private boolean stackLocationIsBackEnd() {
        return this.hasBackendBeentSet() && this.nextIndex - 1 == this.backEndIndex;
    }

    private boolean hasBackendBeentSet() {
        return this.backEndIndex != -1;
    }

    private boolean stackLocationIsDeeperThanFrontEnd() {
        return this.hasFrontEndBeenSet() && this.nextIndex - 1 > this.frontEndIndex;
    }

    private boolean hasFrontEndBeenSet() {
        return this.frontEndIndex != -1;
    }

    public void tearDown() {
        this.haveForcedStallInFrontEnd = false;
        this.haveForcedStallInBackEnd = false;
        this.nextIndex = 0;
        this.frontEndIndex = -1;
        this.backEndIndex = -1;
        StallSweeper.getInstance().deregister(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFrontBoundary(String component) {
        Object object = this.getLock();
        synchronized (object) {
            this.frontEndIndex = this.nextIndex - 1;
            if (this.stackEntries[this.frontEndIndex] != null) {
                this.stackEntries[this.frontEndIndex].setPropagateStallMetric(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEndBoundary(String component) {
        Object object = this.getLock();
        synchronized (object) {
            this.backEndIndex = this.nextIndex - 1;
            this.stackEntries[this.nextIndex - 1].setBackend(component);
        }
    }

    public void reset() {
        StallSweeper.getInstance().register(this);
    }

    int getSweeperSlotValue() {
        return this.sweeperSlotValue;
    }

    public void setComponentMetricPropagateFlag(String component, int flag) {
        if ((flag & 1) != 0) {
            this.stackEntries[this.nextIndex - 1].setPropagateStallMetric(true);
        } else {
            this.stackEntries[this.nextIndex - 1].setPropagateStallMetric(false);
        }
    }
}

