/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.dns;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.dns.IDnsService;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.EnumConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class DnsServiceLoader {
    public static final int kDnsServiceExecutor_threadPoolSize_Default = 3;
    public static final String kDnsServiceConfigName = "introscope.agent.dns.lookup.type";
    public static final String kDnsServiceConfigName_direct = "direct";
    public static final String kDnsServiceConfigName_separateThread = "separateThread";
    public static final String kDnsServiceConfigName_disabled = "disabled";
    public static final int kDnsServiceIndex_direct = 0;
    public static final int kDnsServiceIndex_separateThread = 1;
    public static final int kDnsServiceIndex_disabled = 2;
    public static final String kDnsServiceWaitInMillisecondsConfigName = "introscope.agent.dns.lookup.max.wait.in.milliseconds";
    private static final Module kModule = new Module("DnsServiceLoader");
    private static final String kDnsServiceClassName_direct = "com.wily.introscope.agent.dns.DnsServiceDirect";
    private static final String kDnsServiceClassName_separateThread = "com.wily.introscope.agent.dns.DnsServiceExecutor";
    private static final String kDnsServiceClassName_disabled = "";
    private static final String kDnsServiceLoader_ErrorMsgPrefix = "Error while loading ";
    private static final String kDnsServiceLoader_DebugMsgPrefix = "createDnsService ";
    private static final String[] fValidDnsServiceTypes = new String[]{"direct", "separateThread", "disabled"};
    private static final String[] fDnsServiceClassNames = new String[]{"com.wily.introscope.agent.dns.DnsServiceDirect", "com.wily.introscope.agent.dns.DnsServiceExecutor", ""};
    private static final DnsServiceLoader kInstance = new DnsServiceLoader();
    private IAgent fAgent = null;
    private ConfigurationManager fConfigurationManager = null;
    private IModuleFeedbackChannel fFeedback = null;
    private IStringLocalizer fLocalizer = null;
    private IDnsService fDnsService = null;
    private boolean fFallback = false;

    private DnsServiceLoader() {
    }

    public boolean isFallback() {
        return this.fFallback;
    }

    public static DnsServiceLoader getInstance() {
        return kInstance;
    }

    public IDnsService getDnsService() {
        return DnsServiceLoader.kInstance.fDnsService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDnsService setAgent(IAgent agent) {
        DnsServiceLoader dnsServiceLoader = kInstance;
        synchronized (dnsServiceLoader) {
            if (this.fAgent == null && agent != null) {
                this.fAgent = agent;
                this.fConfigurationManager = this.fAgent.IAgent_getConfigurationManager();
                this.fFeedback = this.fAgent.IAgent_getModuleFeedback();
                this.fLocalizer = this.fAgent.IAgent_getStringLocalizer();
                if (this.fDnsService == null) {
                    this.fDnsService = this.createDnsService();
                }
                return this.fDnsService;
            }
            return this.fDnsService;
        }
    }

    private IDnsService createDnsService() {
        EnumConfigurationProperty dnsServiceType = new EnumConfigurationProperty(kDnsServiceConfigName, new Integer(1), DnsServiceLoader.getValidDnsServiceTypes(), null, null, false, false, this.fFeedback, kModule, this.fLocalizer){};
        this.fConfigurationManager.add(dnsServiceType, true);
        int serviceIndex = (Integer)dnsServiceType.getValue();
        return this.createDnsService(serviceIndex, this.fFeedback, this.fAgent);
    }

    private static String[] getValidDnsServiceTypes() {
        return fValidDnsServiceTypes;
    }

    private IDnsService createDnsService(int serviceIndex, IModuleFeedbackChannel feedback, IAgent agent) {
        IDnsService dnsService = null;
        if (serviceIndex == 0) {
            return this.createDnsServiceDirect(feedback, kDnsServiceLoader_ErrorMsgPrefix, kDnsServiceLoader_DebugMsgPrefix);
        }
        if (serviceIndex == 1) {
            dnsService = this.createDnsServiceSeperateThread(agent, feedback, kDnsServiceLoader_ErrorMsgPrefix, kDnsServiceLoader_DebugMsgPrefix);
            if (dnsService == null) {
                dnsService = this.createDnsServiceDirect(feedback, kDnsServiceLoader_ErrorMsgPrefix, kDnsServiceLoader_DebugMsgPrefix);
                this.fFallback = true;
            }
            return dnsService;
        }
        return null;
    }

    final IDnsService createDnsServiceDirect(IModuleFeedbackChannel feedback, String errorString, String debugString) {
        String className = fDnsServiceClassNames[0];
        return this.createDnsServiceGeneral(className, new Class[]{IModuleFeedbackChannel.class}, new Object[]{feedback}, feedback, String.valueOf(errorString) + "direct ", String.valueOf(debugString) + "direct ");
    }

    final IDnsService createDnsServiceSeperateThread(IAgent agent, IModuleFeedbackChannel feedback, String errorString, String debugString) {
        String className = fDnsServiceClassNames[1];
        return this.createDnsServiceGeneral(className, new Class[]{IAgent.class, Integer.class}, new Object[]{agent, new Integer(3)}, feedback, String.valueOf(errorString) + "seperateThread ", String.valueOf(debugString) + "seperateThread ");
    }

    private final IDnsService createDnsServiceGeneral(String className, Class[] constructorClassInputs, Object[] constructorObjInputs, IModuleFeedbackChannel feedback, String errorString, String debugString) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            feedback.error(kModule, this.fLocalizer.IStringLocalizer_getLocalizedString(String.valueOf(errorString) + e.getMessage()));
            feedback.debug(kModule, debugString, e);
            return null;
        }
        Constructor<?> ctor = null;
        try {
            ctor = clazz.getConstructor(constructorClassInputs);
        }
        catch (SecurityException e) {
            feedback.error(kModule, this.fLocalizer.IStringLocalizer_getLocalizedString(String.valueOf(errorString) + e.getMessage()));
            feedback.debug(kModule, debugString, e);
            return null;
        }
        catch (NoSuchMethodException e) {
            feedback.error(kModule, this.fLocalizer.IStringLocalizer_getLocalizedString(String.valueOf(errorString) + e.getMessage()));
            feedback.debug(kModule, debugString, e);
            return null;
        }
        if (ctor == null) {
            return null;
        }
        try {
            Object iDnsService = null;
            iDnsService = ctor.newInstance(constructorObjInputs);
            return iDnsService;
        }
        catch (IllegalArgumentException e) {
            feedback.error(kModule, this.fLocalizer.IStringLocalizer_getLocalizedString(String.valueOf(errorString) + e.getMessage()));
            feedback.debug(kModule, debugString, e);
        }
        catch (InstantiationException e) {
            feedback.error(kModule, this.fLocalizer.IStringLocalizer_getLocalizedString(String.valueOf(errorString) + e.getMessage()));
            feedback.debug(kModule, debugString, e);
        }
        catch (IllegalAccessException e) {
            feedback.error(kModule, this.fLocalizer.IStringLocalizer_getLocalizedString(String.valueOf(errorString) + e.getMessage()));
            feedback.debug(kModule, debugString, e);
        }
        catch (InvocationTargetException e) {
            feedback.error(kModule, this.fLocalizer.IStringLocalizer_getLocalizedString(String.valueOf(errorString) + e.getMessage()));
            feedback.debug(kModule, debugString, e);
        }
        return null;
    }
}

