/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.probebuilder;

import com.wily.diagnos.cmp.DGCompilationFailedException;
import com.wily.diagnos.cmp.batch.CompilerEnvironment;
import com.wily.diagnos.cmp.ui.ICompilerUI;
import com.wily.util.commandline.CommandLinePrompt;
import com.wily.util.text.ILocalizableException;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.IStringLocalizer;
import java.io.PrintWriter;

public class ProbeBuilderCommandLineUI
implements ICompilerUI {
    private PrintWriter fOut;
    private CompilerEnvironment fEnvironment;
    private IStringLocalizer fLocalizer;
    private CommandLinePrompt fPrompt;
    private boolean fSilent;
    private int fDefaultOption;
    private String fPromptString;
    private char[] fPromptOptions;
    private char fCopyChar;
    private char fSkipChar;
    private char fStopChar;
    private String fContinueStopPromptString;
    private char[] fContinueStopPromptOptions;
    private char fContinueChar;
    private String fPackageName;

    public ProbeBuilderCommandLineUI(CompilerEnvironment env, PrintWriter out, IStringLocalizer localizer) {
        this.fEnvironment = env;
        this.fOut = out;
        this.fLocalizer = localizer;
        this.fPrompt = new CommandLinePrompt(System.in, out, this.fLocalizer);
        this.fSilent = false;
        this.fDefaultOption = 10;
        this.fPromptString = this.fLocalizer.IStringLocalizer_getLocalizedString("Probe_Builder_Command_Line_UI_Copy_Skip_Stop_Prompt");
        this.fCopyChar = this.getLocalizedChar("Probe_Builder_Command_Line_UI_Copy_Option");
        this.fSkipChar = this.getLocalizedChar("Probe_Builder_Command_Line_UI_Skip_Option");
        this.fStopChar = this.getLocalizedChar("Probe_Builder_Command_Line_UI_Stop_Option");
        this.fPromptOptions = new char[3];
        this.fPromptOptions[0] = this.fCopyChar;
        this.fPromptOptions[1] = this.fSkipChar;
        this.fPromptOptions[2] = this.fStopChar;
        this.fContinueStopPromptString = this.fLocalizer.IStringLocalizer_getLocalizedString("Probe_Builder_Command_Line_UI_Continue_Stop_Prompt");
        this.fContinueChar = this.getLocalizedChar("Probe_Builder_Command_Line_UI_Continue_Option");
        this.fContinueStopPromptOptions = new char[2];
        this.fContinueStopPromptOptions[0] = this.fContinueChar;
        this.fContinueStopPromptOptions[1] = this.fStopChar;
    }

    private char getLocalizedChar(String key) {
        String str = this.fLocalizer.IStringLocalizer_getLocalizedString(key);
        if (str == null || str.length() == 0) {
            return '\u0000';
        }
        return Character.toLowerCase(str.charAt(0));
    }

    public void ICompilerUI_setup(String packageName, int itemCount) {
        this.fPackageName = packageName;
        if (!this.fSilent && this.fEnvironment.isVerbose() && this.fPackageName != null) {
            this.fOut.println(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Converting", this.fPackageName));
        }
    }

    public void ICompilerUI_updateStatusBar(String fileName, int entryNum) {
        if (!this.fSilent && this.fEnvironment.isVerbose() && fileName != null) {
            this.fOut.println(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Processing", fileName));
        }
    }

    public void ICompilerUI_setStatusText(String statusText) {
        if (!this.fSilent && this.fEnvironment.isVerbose() && statusText != null) {
            this.fOut.println(statusText);
        }
    }

    public void ICompilerUI_setStatusMessage(ILocalizableMessage message) {
        this.ICompilerUI_setStatusText(message.ILocalizableMessage_getLocalizedMessage(this.fLocalizer));
    }

    public void ICompilerUI_close() {
        if (!this.fSilent && this.fEnvironment.isVerbose() && this.fPackageName != null) {
            this.fOut.println(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Closing", this.fPackageName));
        }
    }

    public boolean ICompilerUI_handleException(Exception e) {
        String[] prompt;
        char response;
        if (this.fSilent) {
            return true;
        }
        String errorMessage = null;
        if (e instanceof ILocalizableException) {
            ILocalizableMessage locMessage = ((ILocalizableException)((Object)e)).ILocalizableException_getLocalizableMessage();
            errorMessage = locMessage.ILocalizableMessage_getLocalizedMessage(this.fLocalizer);
        }
        if (errorMessage == null && e != null) {
            errorMessage = e.toString();
        }
        return (response = this.fPrompt.showPrompt(prompt = new String[]{this.fLocalizer.IStringLocalizer_getLocalizedString("Probe_Builder_Command_Line_UI_Generic_Error_Message"), this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Command_Line_UI_Exception_Message", errorMessage), this.fContinueStopPromptString}, this.fContinueStopPromptOptions)) == this.fContinueChar;
    }

    public void ICompilerUI_handleExceptionProcessingFile(String file, Exception e) throws DGCompilationFailedException {
        String[] prompt;
        char response;
        if (this.fSilent) {
            throw new DGCompilationFailedException(this.fDefaultOption);
        }
        String errorMessage = null;
        if (e instanceof ILocalizableException) {
            ILocalizableMessage locMessage = ((ILocalizableException)((Object)e)).ILocalizableException_getLocalizableMessage();
            errorMessage = locMessage.ILocalizableMessage_getLocalizedMessage(this.fLocalizer);
        }
        if (errorMessage == null && e != null) {
            errorMessage = e.toString();
        }
        if ((response = this.fPrompt.showPrompt(prompt = new String[]{this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Command_Line_UI_File_Error_Message", file), this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Command_Line_UI_Exception_Message", errorMessage), this.fPromptString}, this.fPromptOptions)) == this.fCopyChar) {
            throw new DGCompilationFailedException(10);
        }
        if (response == this.fSkipChar) {
            throw new DGCompilationFailedException(11);
        }
        if (response == this.fStopChar) {
            throw new DGCompilationFailedException(12);
        }
    }

    public void ICompilerUI_handleExceptionCopyingFile(String file, Exception e) throws DGCompilationFailedException {
        String[] prompt;
        char response;
        if (this.fSilent) {
            throw new DGCompilationFailedException(11);
        }
        String errorMessage = null;
        if (e instanceof ILocalizableException) {
            ILocalizableMessage locMessage = ((ILocalizableException)((Object)e)).ILocalizableException_getLocalizableMessage();
            errorMessage = locMessage.ILocalizableMessage_getLocalizedMessage(this.fLocalizer);
        }
        if (errorMessage == null && e != null) {
            errorMessage = e.toString();
        }
        if ((response = this.fPrompt.showPrompt(prompt = new String[]{this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Command_Line_UI_File_Copy_Error_Message", file), this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Probe_Builder_Command_Line_UI_Exception_Message", errorMessage), this.fContinueStopPromptString}, this.fContinueStopPromptOptions)) == this.fContinueChar) {
            throw new DGCompilationFailedException(11);
        }
        if (response == this.fStopChar) {
            throw new DGCompilationFailedException(12);
        }
    }
}

