/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.async;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.async.AsyncTransactionContext;
import com.wily.introscope.agent.async.AsyncVirtualStack;
import com.wily.introscope.agent.correlation.CrossProcessCorrelationAdmin;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.ThreadCorrelationId;
import com.wily.util.adt.ConcurrentMapFactory;
import com.wily.util.adt.ConcurrentWeakIdentityHighPerformanceLRUHashMap;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class InjectedFieldCorrelationHelper {
    public static final String injectedFieldName = "__Wily_txnContext";
    static final String ASYN_THREAD_CORRELATION = "asyn.thread.correlation";
    static final String ASYN_THREAD_CORRELATION_INSERTED = "asyn.thread.correlation.inserted";
    protected IModuleFeedbackChannel feedback;
    protected static Module module = new Module("InjectedFieldCorrelationHelper");
    protected static final Object nullObject = new Object();
    private static final String kContextReferenceMapName = "AsyncThreadContextReferenceMap";
    private final AsyncVirtualStack asyncStack;
    private AtomicBoolean useReferenceMap = new AtomicBoolean(false);
    private Field contextField = null;
    private ConcurrentMapFactory factory = null;
    private static ConcurrentWeakIdentityHighPerformanceLRUHashMap<Object, AsyncTransactionContext> map = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InjectedFieldCorrelationHelper(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        this.feedback = agent.IAgent_getModuleFeedback();
        Class<InjectedFieldCorrelationHelper> clazz = InjectedFieldCorrelationHelper.class;
        synchronized (InjectedFieldCorrelationHelper.class) {
            if (map == null) {
                this.factory = (ConcurrentMapFactory)agent.IAgent_getConcurrentMapFactory();
                ConcurrentMapFactory.ConcurrentMapPolicy p = new ConcurrentMapFactory.ConcurrentMapPolicy(kContextReferenceMapName, ConcurrentMapFactory.ConcurrentMapType.CappedWeakIdentity, true, ConcurrentMapFactory.ThreadLocalOption.NoThreadLocal, 16, 1000, 0, 0.75f, 1000, 0);
                IntervalHeartbeat beat = agent.IAgent_getCommonHeartbeat();
                this.factory.addMapPolicy(kContextReferenceMapName, p, this.feedback, beat);
                map = this.factory.getConcurrentCappedWeakIdentityHashMap(kContextReferenceMapName);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (sampleTracedObject != null) {
                this.initializeContextField(sampleTracedObject);
            }
            this.asyncStack = AsyncVirtualStack.getInstance(agent);
            return;
        }
    }

    private Field getContextField(Class<?> clazz) {
        block3: {
            try {
                return clazz.getDeclaredField(injectedFieldName);
            }
            catch (SecurityException e) {
                this.feedback.debug(module, "Couldn't access injected field __Wily_txnContext", e);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                Class<?> superClass = clazz.getSuperclass();
                if (superClass == null) break block3;
                return this.getContextField(superClass);
            }
        }
        return null;
    }

    private void initializeContextField(Object object) {
        if (object == null) {
            return;
        }
        this.contextField = this.getContextField(object.getClass());
        if (this.contextField != null) {
            this.contextField.setAccessible(true);
        } else {
            this.feedback.debug(module, "Could not find injected field __Wily_txnContext");
            this.feedback.debug(module, "Injected field __Wily_txnContext is null for " + object.getClass().getCanonicalName());
            this.useReferenceMap.set(true);
        }
    }

    protected AsyncTransactionContext createContext(InvocationData data, Object invocationObject) {
        AsyncTransactionContext.AsyncComponentInvocation frontendInfo = this.asyncStack.getAsyncFrontendInfoFromTransactionCache(data);
        AsyncTransactionContext.AsyncComponentInvocation backendInfo = this.asyncStack.getAsyncBackendInfoFromTransactionCache(data);
        AsyncTransactionContext context = new AsyncTransactionContext(data.getWallClockStartTime(), new ThreadCorrelationId().getOutgoingNonSerializedCrossProcessData(), frontendInfo, backendInfo);
        String frontendtxId = AsyncVirtualStack.getFrontendTransactionIdFromTransactionCache(data);
        if (frontendtxId == null) {
            if (frontendInfo != null) {
                frontendtxId = frontendInfo.frontendTxId;
            }
            if (frontendtxId == null) {
                frontendtxId = this.asyncStack.getFrontendTxIdInCurrentThread(data);
            }
        }
        context.setFrontendTransactionId(frontendtxId);
        if (this.feedback.isDebugEnabled(module)) {
            this.feedback.debug(module, "In thread " + Thread.currentThread().getName() + " created context in method " + invocationObject.getClass().getName() + "." + data.getProbeInformation().getProbeIdentification().getProbeMethodName() + "() " + context.getCorrelationData().getCorrelationID());
        }
        return context;
    }

    protected void processContext(InvocationData data, Object invocationObject, AsyncTransactionContext context) {
        String frontendTrxId;
        if (this.feedback.isDebugEnabled(module)) {
            this.feedback.debug(module, "In thread " + Thread.currentThread().getName() + " found context in method " + invocationObject.getClass().getName() + "." + data.getProbeInformation().getProbeIdentification().getProbeMethodName() + "() " + context.getCorrelationData().getCorrelationID());
        }
        new ThreadCorrelationId(context.getCorrelationData());
        AsyncTransactionContext.AsyncComponentInvocation frontendInfo = context.getFrontendInfo();
        if (frontendInfo != null) {
            this.asyncStack.putAsyncFrontendInfoToTransactionCache(data, frontendInfo);
        }
        if ((frontendTrxId = context.getFrontendTransactionId()) == null) {
            frontendTrxId = frontendInfo != null ? frontendInfo.transactionId : CrossProcessCorrelationAdmin.getTransactionIdFromCacheForSnapshot(data);
        }
        AsyncVirtualStack.putFrontendTransactionIdToTransactionCache(data, frontendTrxId);
        AsyncTransactionContext.AsyncComponentInvocation backendInfo = context.getBackendInfo();
        if (backendInfo != null) {
            this.asyncStack.putAsyncBackendInfoToTransactionCache(data, backendInfo);
        }
    }

    private boolean processReferenceMapContext(InvocationData data, Object invocationObject) {
        AsyncTransactionContext context = map.removeWeak(invocationObject);
        if (context != null) {
            this.processContext(data, invocationObject, context);
            return true;
        }
        return false;
    }

    private boolean insertReferenceMapContext(InvocationData data, Object invocationObject) {
        AsyncTransactionContext context = this.createContext(data, invocationObject);
        map.putWeak(invocationObject, context);
        return true;
    }

    private boolean processInjectedFieldContext(InvocationData data, Object invocationObject) {
        AtomicReference holder = null;
        try {
            Object holderObject = this.contextField.get(invocationObject);
            if (holderObject instanceof AtomicReference) {
                holder = (AtomicReference)holderObject;
            }
        }
        catch (IllegalArgumentException e) {
            this.feedback.debug(module, "Couldn't read injected field __Wily_txnContext", e);
            this.contextField = null;
            return this.processContext(data, invocationObject);
        }
        catch (IllegalAccessException e) {
            this.feedback.debug(module, "Couldn't access injected field __Wily_txnContext", e);
            this.useReferenceMap.set(true);
            return false;
        }
        if (holder == null) {
            return false;
        }
        AsyncTransactionContext context = (AsyncTransactionContext)holder.get();
        if (context == null) {
            return false;
        }
        this.processContext(data, invocationObject, context);
        holder.set(null);
        return true;
    }

    private boolean insertInjectedFieldContext(InvocationData data, Object invocationObject) {
        Object context;
        AtomicReference<Object> holder = null;
        try {
            context = this.contextField.get(invocationObject);
            if (context instanceof AtomicReference) {
                holder = (AtomicReference<Object>)context;
            }
        }
        catch (IllegalArgumentException e) {
            this.feedback.debug(module, "Couldn't read injected field __Wily_txnContext", e);
            this.useReferenceMap.set(true);
            return false;
        }
        catch (IllegalAccessException e) {
            this.feedback.debug(module, "Couldn't access injected field __Wily_txnContext", e);
            this.useReferenceMap.set(true);
            return false;
        }
        if (holder == null) {
            holder = new AtomicReference<Object>();
            try {
                this.contextField.set(invocationObject, holder);
            }
            catch (IllegalArgumentException e) {
                this.feedback.debug(module, "Couldn't set injected field __Wily_txnContext", e);
                this.useReferenceMap.set(true);
                return false;
            }
            catch (IllegalAccessException e) {
                this.feedback.debug(module, "Couldn't access injected field __Wily_txnContext", e);
                this.useReferenceMap.set(true);
                return false;
            }
            if (this.feedback.isDebugEnabled(module)) {
                this.feedback.debug(module, "In thread " + Thread.currentThread().getName() + " set the context holder in the field for class " + invocationObject.getClass().getName());
            }
        }
        if ((context = (AsyncTransactionContext)holder.get()) == null && !holder.compareAndSet(null, context = this.createContext(data, invocationObject))) {
            context = (AsyncTransactionContext)holder.get();
        }
        return true;
    }

    protected boolean insertContext(InvocationData data, Object invocationObject) {
        if (this.contextField == null && !this.useReferenceMap.get()) {
            this.initializeContextField(invocationObject);
        }
        if (this.useReferenceMap.get()) {
            return this.insertReferenceMapContext(data, invocationObject);
        }
        return this.insertInjectedFieldContext(data, invocationObject);
    }

    protected boolean processContext(InvocationData data, Object invocationObject) {
        if (this.contextField == null && !this.useReferenceMap.get()) {
            this.initializeContextField(invocationObject);
        }
        if (this.useReferenceMap.get()) {
            return this.processReferenceMapContext(data, invocationObject);
        }
        return this.processInjectedFieldContext(data, invocationObject);
    }

    private AsyncTransactionContext getContext(Object contextObject) {
        if (this.contextField == null && !this.useReferenceMap.get()) {
            this.initializeContextField(contextObject);
        }
        if (this.useReferenceMap.get()) {
            return this.getReferenceMapContext(contextObject);
        }
        return this.getInjectedFieldContext(contextObject);
    }

    private AsyncTransactionContext getInjectedFieldContext(Object contextObject) {
        AtomicReference holder = null;
        try {
            Object holderObject = this.contextField.get(contextObject);
            if (holderObject instanceof AtomicReference) {
                holder = (AtomicReference)holderObject;
            }
        }
        catch (IllegalArgumentException e) {
            this.feedback.debug(module, "Couldn't read injected field __Wily_txnContext", e);
            this.useReferenceMap.set(true);
            return null;
        }
        catch (IllegalAccessException e) {
            this.feedback.debug(module, "Couldn't access injected field __Wily_txnContext", e);
            this.useReferenceMap.set(true);
            return null;
        }
        if (holder == null) {
            return null;
        }
        return (AsyncTransactionContext)holder.get();
    }

    private AsyncTransactionContext getReferenceMapContext(Object contextObject) {
        AsyncTransactionContext context = map.getWeak(contextObject);
        return context;
    }

    protected boolean updateContextForBackend(InvocationData data, Object contextObject) {
        AsyncTransactionContext context = this.getContext(contextObject);
        if (context != null) {
            AsyncTransactionContext.AsyncComponentInvocation backendInfo = this.asyncStack.getAsyncBackendInfoFromTransactionCache(data);
            context.setBackendInfo(backendInfo);
            return true;
        }
        return false;
    }

    protected boolean updateContextForFrontend(InvocationData data, Object contextObject) {
        AsyncTransactionContext context = this.getContext(contextObject);
        if (context != null) {
            AsyncTransactionContext.AsyncComponentInvocation frontendInfo = this.asyncStack.getAsyncFrontendInfoFromTransactionCache(data);
            context.setFrontendInfo(frontendInfo);
            return true;
        }
        return false;
    }
}

