/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.blame;

import com.wily.introscope.agent.IAgent;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import java.util.concurrent.atomic.AtomicReference;

public class ApplicationNameInfo {
    private static final Module kModule = new Module("ApplicationNameInfo");
    public static final ThreadLocal<String> ApplicationName = new ThreadLocal();
    public static volatile AtomicReference<String> globalApplicationName = new AtomicReference();
    private static String fUserConfiguredAppName;

    public static void initializeParameterLoader(IAgent agent) {
        IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
        IStringLocalizer localizer = agent.IAgent_getStringLocalizer();
        ConfigurationManager cm = agent.IAgent_getConfigurationManager();
        cm.add(new ConfigurationProperty("introscope.agent.application.name", "", "Hot_Property_Configuration_Property", null, true, false, feedback, kModule, localizer){

            public final void set(Object value) {
                String appName = (String)value;
                if (appName != null && (appName = appName.trim()).length() > 0) {
                    fUserConfiguredAppName = appName;
                }
            }
        });
    }

    public static String resolveApplicationName(String tracerAppName) {
        if (fUserConfiguredAppName != null && fUserConfiguredAppName.length() > 0) {
            return fUserConfiguredAppName;
        }
        String derivedAppName = ApplicationName.get();
        if (derivedAppName != null && derivedAppName.length() > 0) {
            return derivedAppName;
        }
        if (tracerAppName != null && tracerAppName.length() > 0 && !tracerAppName.equals("rootContext")) {
            return tracerAppName;
        }
        String globalAppName = globalApplicationName.get();
        if (globalAppName != null && tracerAppName.length() > 0) {
            return globalAppName;
        }
        return "rootContext";
    }
}

