/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.server.transactiontrace;

import com.wily.introscope.spec.server.beans.event.IEventDataNode;
import com.wily.introscope.spec.server.transactiontrace.BoundaryOnlyTransactionData;
import com.wily.util.HashCodeUtils;
import com.wily.util.StringUtils;
import com.wily.util.adt.CanonicalObjectPool;
import com.wily.wilyassert.Assertion;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TransactionComponentData
implements Externalizable,
IEventDataNode {
    private static final long serialVersionUID = 6882718901468459490L;
    public static final TransactionComponentData[] kNoCalledComponents = new TransactionComponentData[0];
    public static final HashMap kNoParameters = new HashMap(1);
    private String fResource;
    private long fStartTime;
    private String fTimeZone;
    private long fDuration;
    private Map fParameters;
    private TransactionComponentData[] fCalledComponents;
    private transient int fHashCode;
    private transient int fMagnitude;
    public static final int kMillisecData = 0;
    public static final int kMicrosecData = 1;
    public static final int kNanosecData = 2;
    public static final String kDataCreationKey = "DataCreationType";
    public static final String kTimingAnomalyKey = "TimingAnomaly";
    public static final String kTimingAnomalyDnf = "Did not finish";
    private int fDataCreationGranularity = 0;
    public transient List tempChildren;
    protected static int kUTFStringMaxSize = 16000;

    public TransactionComponentData() {
        this.fMagnitude = 1;
    }

    public static TransactionComponentData createMicroSecTransactionComponentData(String resource, long startTime, long duration) {
        TransactionComponentData res = new TransactionComponentData(resource, startTime, duration);
        res.setDataCreationType(1);
        return res;
    }

    public static TransactionComponentData createMilliSecTransactionComponentData(String resource, long startTime, long duration) {
        TransactionComponentData res = new TransactionComponentData(resource, startTime, duration);
        res.setDataCreationType(0);
        return res;
    }

    public static TransactionComponentData createNanoSecTransactionComponentData(String resource, long startTime, long duration) {
        TransactionComponentData res = new TransactionComponentData(resource, startTime, duration);
        res.setDataCreationType(2);
        return res;
    }

    public static TransactionComponentData createMicroSecTransactionComponentData(String resource, long startTime, long duration, Map parameters) {
        TransactionComponentData res = new TransactionComponentData(resource, startTime, duration, parameters);
        res.setDataCreationType(1);
        return res;
    }

    public static TransactionComponentData createMilliSecTransactionComponentData(String resource, long startTime, long duration, Map parameters) {
        TransactionComponentData res = new TransactionComponentData(resource, startTime, duration, parameters);
        res.setDataCreationType(0);
        return res;
    }

    public static TransactionComponentData createNanoSecTransactionComponentData(String resource, long startTime, long duration, Map parameters) {
        TransactionComponentData res = new TransactionComponentData(resource, startTime, duration, parameters);
        res.setDataCreationType(2);
        return res;
    }

    public static TransactionComponentData createMicroSecTransactionComponentData(String resource, long startTime, long duration, HashMap parameters) {
        TransactionComponentData res = new TransactionComponentData(resource, startTime, duration, parameters);
        res.setDataCreationType(1);
        return res;
    }

    public static TransactionComponentData createMilliSecTransactionComponentData(String resource, long startTime, long duration, HashMap parameters) {
        TransactionComponentData res = new TransactionComponentData(resource, startTime, duration, parameters);
        res.setDataCreationType(0);
        return res;
    }

    public static TransactionComponentData createNanoSecTransactionComponentData(String resource, long startTime, long duration, HashMap parameters) {
        TransactionComponentData res = new TransactionComponentData(resource, startTime, duration, parameters);
        res.setDataCreationType(2);
        return res;
    }

    public static TransactionComponentData createMicroSecTransactionComponentData(String resource, long startTime, long duration, TransactionComponentData[] calledComponents) {
        TransactionComponentData res = new TransactionComponentData(resource, startTime, duration, calledComponents);
        res.setDataCreationType(1);
        return res;
    }

    public static TransactionComponentData createMilliSecTransactionComponentData(String resource, long startTime, long duration, TransactionComponentData[] calledComponents) {
        TransactionComponentData res = new TransactionComponentData(resource, startTime, duration, calledComponents);
        res.setDataCreationType(0);
        return res;
    }

    public static TransactionComponentData createNanoSecTransactionComponentData(String resource, long startTime, long duration, TransactionComponentData[] calledComponents) {
        TransactionComponentData res = new TransactionComponentData(resource, startTime, duration, calledComponents);
        res.setDataCreationType(2);
        return res;
    }

    public static TransactionComponentData createMicroSecTransactionComponentData(String resource, long startTime, long duration, Map parameters, TransactionComponentData[] calledComponents) {
        TransactionComponentData res = new TransactionComponentData(resource, startTime, duration, parameters, calledComponents);
        res.setDataCreationType(1);
        return res;
    }

    public static TransactionComponentData createMilliSecTransactionComponentData(String resource, long startTime, long duration, Map parameters, TransactionComponentData[] calledComponents) {
        TransactionComponentData res = new TransactionComponentData(resource, startTime, duration, parameters, calledComponents);
        res.setDataCreationType(0);
        return res;
    }

    public static TransactionComponentData createMicroSecTransactionComponentData(String resource, long startTime, String timeZone, long duration, Map parameters, TransactionComponentData[] calledComponents) {
        TransactionComponentData res = new TransactionComponentData(resource, startTime, timeZone, duration, parameters, calledComponents);
        res.setDataCreationType(1);
        return res;
    }

    public static TransactionComponentData createMilliSecTransactionComponentData(String resource, long startTime, String timeZone, long duration, Map parameters, TransactionComponentData[] calledComponents) {
        TransactionComponentData res = new TransactionComponentData(resource, startTime, timeZone, duration, parameters, calledComponents);
        res.setDataCreationType(0);
        return res;
    }

    public static TransactionComponentData createNanoSecTransactionComponentData(String resource, long startTime, long duration, Map parameters, TransactionComponentData[] calledComponents) {
        TransactionComponentData res = new TransactionComponentData(resource, startTime, duration, parameters, calledComponents);
        res.setDataCreationType(2);
        return res;
    }

    public static TransactionComponentData createMicroSecTransactionComponentData(String resource, int magnitude, long startTime, long duration, Map parameters, TransactionComponentData[] calledComponents) {
        TransactionComponentData res = new TransactionComponentData(resource, magnitude, startTime, duration, parameters, calledComponents);
        res.setDataCreationType(1);
        return res;
    }

    public static TransactionComponentData createMilliSecTransactionComponentData(String resource, int magnitude, long startTime, long duration, Map parameters, TransactionComponentData[] calledComponents) {
        TransactionComponentData res = new TransactionComponentData(resource, magnitude, startTime, duration, parameters, calledComponents);
        res.setDataCreationType(0);
        return res;
    }

    public static TransactionComponentData createNanoSecTransactionComponentData(String resource, int magnitude, long startTime, long duration, Map parameters, TransactionComponentData[] calledComponents) {
        TransactionComponentData res = new TransactionComponentData(resource, magnitude, startTime, duration, parameters, calledComponents);
        res.setDataCreationType(2);
        return res;
    }

    public TransactionComponentData(String resource, HashMap params, BoundaryOnlyTransactionData[] bundledTransactions) {
        Assertion.wilyAssert(false);
        this.fResource = resource == null ? "" : resource;
        this.fParameters = new HashMap(params);
        String dataCreationType = new Integer(this.getDataCreationType()).toString();
        this.fParameters.put(kDataCreationKey, dataCreationType);
        this.fCalledComponents = bundledTransactions;
        this.fParameters = this.fParameters == null ? kNoParameters : this.fParameters;
    }

    public TransactionComponentData(String resource, long startTime, long duration) {
        this(resource, startTime, duration, kNoParameters, kNoCalledComponents);
    }

    public TransactionComponentData(String resource, long startTime, long duration, Map parameters) {
        this(resource, startTime, duration, parameters, kNoCalledComponents);
    }

    public TransactionComponentData(String resource, long startTime, long duration, HashMap parameters) {
        this(resource, startTime, duration, parameters, kNoCalledComponents);
    }

    public TransactionComponentData(String resource, long startTime, long duration, TransactionComponentData[] calledComponents) {
        this(resource, startTime, duration, kNoParameters, calledComponents);
    }

    public TransactionComponentData(String resource, long startTime, long duration, Map parameters, TransactionComponentData[] calledComponents) {
        this(resource, 5000, startTime, duration, parameters, calledComponents);
    }

    public TransactionComponentData(String resource, long startTime, String timeZone, long duration, Map parameters, TransactionComponentData[] calledComponents) {
        this(resource, 5000, startTime, timeZone, duration, parameters, calledComponents);
    }

    public TransactionComponentData(String resource, int magnitude, long startTime, String timeZone, long duration, Map parameters, TransactionComponentData[] calledComponents) {
        Assertion.wilyAssert(false);
        this.fResource = resource == null ? "" : resource;
        this.fStartTime = startTime;
        this.fTimeZone = timeZone;
        this.fParameters = new HashMap(parameters);
        String dataCreationType = new Integer(this.getDataCreationType()).toString();
        this.fParameters.put(kDataCreationKey, dataCreationType);
        if (duration < 0L) {
            if (duration > -1000L) {
                this.fDuration = 0L;
            } else {
                this.fDuration = Integer.MAX_VALUE;
                this.fParameters.put(kTimingAnomalyKey, kTimingAnomalyDnf);
            }
        } else {
            this.fDuration = duration;
        }
        this.fCalledComponents = calledComponents;
        this.ensureNonNullValues();
        this.fMagnitude = magnitude <= 0 ? (this.fCalledComponents.length > 0 && this.fCalledComponents[0] != null ? this.fCalledComponents[0].getMagnitude() + 1 : 1) : magnitude;
    }

    public TransactionComponentData(String resource, int magnitude, long startTime, long duration, Map parameters, TransactionComponentData[] calledComponents) {
        Assertion.wilyAssert(false);
        this.fResource = resource == null ? "" : resource;
        this.fStartTime = startTime;
        this.fParameters = new HashMap(parameters);
        String dataCreationType = new Integer(this.getDataCreationType()).toString();
        this.fParameters.put(kDataCreationKey, dataCreationType);
        if (duration < 0L) {
            if (duration > -1000L) {
                this.fDuration = 0L;
            } else {
                this.fDuration = Integer.MAX_VALUE;
                this.fParameters.put(kTimingAnomalyKey, kTimingAnomalyDnf);
            }
        } else {
            this.fDuration = duration;
        }
        this.fCalledComponents = calledComponents;
        this.ensureNonNullValues();
        this.fMagnitude = magnitude <= 0 ? (this.fCalledComponents.length > 0 && this.fCalledComponents[0] != null ? this.fCalledComponents[0].getMagnitude() + 1 : 1) : magnitude;
    }

    private void setDataCreationType(int type) {
        this.fDataCreationGranularity = type;
        String dataCreationType = new Integer(type).toString();
        this.fParameters.put(kDataCreationKey, dataCreationType);
    }

    public int getDataCreationType() {
        return this.fDataCreationGranularity;
    }

    public int getMagnitude() {
        return this.fMagnitude;
    }

    private void ensureNonNullValues() {
        this.fParameters = this.fParameters == null ? kNoParameters : this.fParameters;
        this.fCalledComponents = this.fCalledComponents == null ? kNoCalledComponents : this.fCalledComponents;
    }

    @Override
    public Map getParameters() {
        return this.fParameters;
    }

    @Override
    public String getResource() {
        return this.fResource;
    }

    public void setResource(String resource) {
        this.fResource = resource;
    }

    @Override
    public long getStartTime() {
        return this.getStartTimeInMillisecs();
    }

    public String getTimeZone() {
        return this.fTimeZone;
    }

    @Override
    public long getDuration() {
        return this.getDurationInMillisecs();
    }

    public long getStartTimeInMillisecs() {
        if (this.fDataCreationGranularity == 0) {
            return this.fStartTime;
        }
        if (this.fDataCreationGranularity == 1) {
            return this.fStartTime / 1000L;
        }
        if (this.fDataCreationGranularity == 2) {
            return this.fStartTime / (long)Math.pow(10.0, 6.0);
        }
        return this.fStartTime;
    }

    public long getStartTimeInMicrosecs() {
        if (this.fDataCreationGranularity == 0) {
            return this.fStartTime * 1000L;
        }
        if (this.fDataCreationGranularity == 1) {
            return this.fStartTime;
        }
        if (this.fDataCreationGranularity == 2) {
            return this.fStartTime / 1000L;
        }
        return this.fStartTime;
    }

    public long getStartTimeInNanosecs() {
        if (this.fDataCreationGranularity == 0) {
            return this.fStartTime * (long)Math.pow(10.0, 6.0);
        }
        if (this.fDataCreationGranularity == 1) {
            return this.fStartTime * 1000L;
        }
        if (this.fDataCreationGranularity == 2) {
            return this.fStartTime;
        }
        return this.fStartTime;
    }

    public long getDurationInMillisecs() {
        if (this.fDataCreationGranularity == 0) {
            return this.fDuration;
        }
        if (this.fDataCreationGranularity == 1) {
            return this.fDuration / 1000L;
        }
        if (this.fDataCreationGranularity == 2) {
            return this.fDuration / (long)Math.pow(10.0, 6.0);
        }
        return this.fDuration;
    }

    public long getDurationInMicrosecs() {
        if (this.fDataCreationGranularity == 0) {
            return this.fDuration * 1000L;
        }
        if (this.fDataCreationGranularity == 1) {
            return this.fDuration;
        }
        if (this.fDataCreationGranularity == 2) {
            return this.fDuration / 1000L;
        }
        return this.fDuration;
    }

    public long getDurationInNanosecs() {
        if (this.fDataCreationGranularity == 0) {
            return this.fDuration * (long)Math.pow(10.0, 6.0);
        }
        if (this.fDataCreationGranularity == 1) {
            return this.fDuration * 1000L;
        }
        if (this.fDataCreationGranularity == 2) {
            return this.fDuration;
        }
        return this.fDuration;
    }

    public long getNetDurationInMillisecs() {
        long netDuration = this.getNetDurationInternal();
        if (this.fDataCreationGranularity == 0) {
            return netDuration;
        }
        if (this.fDataCreationGranularity == 1) {
            return netDuration / 1000L;
        }
        if (this.fDataCreationGranularity == 2) {
            return netDuration / (long)Math.pow(10.0, 6.0);
        }
        return netDuration;
    }

    public long getNetDurationInMicrosecs() {
        long netDuration = this.getNetDurationInternal();
        if (this.fDataCreationGranularity == 0) {
            return netDuration * 1000L;
        }
        if (this.fDataCreationGranularity == 1) {
            return netDuration;
        }
        if (this.fDataCreationGranularity == 2) {
            return netDuration / 1000L;
        }
        return netDuration;
    }

    public long getNetDurationInNanosecs() {
        long netDuration = this.getNetDurationInternal();
        if (this.fDataCreationGranularity == 0) {
            return netDuration * (long)Math.pow(10.0, 6.0);
        }
        if (this.fDataCreationGranularity == 1) {
            return netDuration * 1000L;
        }
        if (this.fDataCreationGranularity == 2) {
            return netDuration;
        }
        return netDuration;
    }

    public void fixTimingData(TransactionComponentData parent) {
        if (this.fDataCreationGranularity == 0) {
            this.fixTimingDataInMillisecs(parent);
        } else if (this.fDataCreationGranularity == 1) {
            this.fixTimingDataInMicrosecs(parent);
        } else if (this.fDataCreationGranularity == 2) {
            this.fixTimingDataInNanosecs(parent);
        }
    }

    private void fixTimingDataInMillisecs(TransactionComponentData parent) {
        if (this.getStartTimeInMillisecs() < parent.getStartTimeInMillisecs()) {
            this.fStartTime = parent.getStartTimeInMillisecs();
        } else if (this.getStartTimeInMillisecs() > parent.getStartTimeInMillisecs() + parent.getDurationInMillisecs()) {
            this.fStartTime = parent.getStartTimeInMillisecs() + parent.getDurationInMillisecs();
        }
        if (this.getStartTimeInMillisecs() + this.getDurationInMillisecs() > parent.getStartTimeInMillisecs() + parent.getDurationInMillisecs()) {
            this.fDuration = parent.getStartTimeInMillisecs() + parent.getDurationInMillisecs() - this.getStartTimeInMillisecs();
        }
        if (this.fDuration < 0L) {
            this.fDuration = 0L;
        }
    }

    private void fixTimingDataInMicrosecs(TransactionComponentData parent) {
        if (this.getStartTimeInMicrosecs() < parent.getStartTimeInMicrosecs()) {
            this.fStartTime = parent.getStartTimeInMicrosecs();
        } else if (this.getStartTimeInMicrosecs() > parent.getStartTimeInMicrosecs() + parent.getDurationInMicrosecs()) {
            this.fStartTime = parent.getStartTimeInMicrosecs() + parent.getDurationInMicrosecs();
        }
        if (this.getStartTimeInMicrosecs() + this.getDurationInMicrosecs() > parent.getStartTimeInMicrosecs() + parent.getDurationInMicrosecs()) {
            this.fDuration = parent.getStartTimeInMicrosecs() + parent.getDurationInMicrosecs() - this.getStartTimeInMicrosecs();
        }
        if (this.fDuration < 0L) {
            this.fDuration = 0L;
        }
    }

    private void fixTimingDataInNanosecs(TransactionComponentData parent) {
        if (this.getStartTimeInNanosecs() < parent.getStartTimeInNanosecs()) {
            this.fStartTime = parent.getStartTimeInNanosecs();
        } else if (this.getStartTimeInNanosecs() > parent.getStartTimeInNanosecs() + parent.getDurationInNanosecs()) {
            this.fStartTime = parent.getStartTimeInNanosecs() + parent.getDurationInNanosecs();
        }
        if (this.getStartTimeInNanosecs() + this.getDurationInNanosecs() > parent.getStartTimeInNanosecs() + parent.getDurationInNanosecs()) {
            this.fDuration = parent.getStartTimeInNanosecs() + parent.getDurationInNanosecs() - this.getStartTimeInNanosecs();
        }
        if (this.fDuration < 0L) {
            this.fDuration = 0L;
        }
    }

    @Override
    public Set getParameterNames() {
        return Collections.unmodifiableSet(this.fParameters.keySet());
    }

    @Override
    public String getParameterValue(String name) {
        return (String)this.fParameters.get(name);
    }

    public void setParameterValue(String name, String value) {
        this.fParameters.put(name, value);
    }

    public void setParameters(Map param) {
        this.fParameters = param;
        String dataCreationType = new Integer(this.getDataCreationType()).toString();
        this.fParameters.put(kDataCreationKey, dataCreationType);
    }

    public void setSubNodes(TransactionComponentData[] calledData) {
        this.fCalledComponents = calledData;
    }

    public TransactionComponentData[] getSubNodes() {
        return this.fCalledComponents;
    }

    public int getCalledComponentCount() {
        return this.fCalledComponents.length;
    }

    public TransactionComponentData getCalledComponent(int index) {
        return this.fCalledComponents[index];
    }

    @Override
    public int getSubNodeCount() {
        return this.fCalledComponents.length;
    }

    @Override
    public IEventDataNode getSubNode(int index) {
        return this.fCalledComponents[index];
    }

    public void replaceSubNode(int index, IEventDataNode node) {
        this.fCalledComponents[index] = (TransactionComponentData)node;
    }

    public long getNetDuration() {
        return this.getNetDurationInMillisecs();
    }

    private long getNetDurationInternal() {
        long netDuration;
        long calledComponentDuration = 0L;
        if (this.fCalledComponents != null && this.fCalledComponents.length > 0) {
            int i = 0;
            while (i < this.fCalledComponents.length) {
                if (this.getDataCreationType() == 0) {
                    calledComponentDuration += this.fCalledComponents[i].getDurationInMillisecs();
                } else if (this.getDataCreationType() == 1) {
                    calledComponentDuration += this.fCalledComponents[i].getDurationInMicrosecs();
                } else if (this.getDataCreationType() == 2) {
                    calledComponentDuration += this.fCalledComponents[i].getDurationInNanosecs();
                }
                ++i;
            }
        }
        if ((netDuration = this.fDuration - calledComponentDuration) > 0L) {
            return netDuration;
        }
        return 0L;
    }

    public String getDescription() {
        String label = this.getParameterValue("URL");
        if (label == null || label.trim().equals("")) {
            label = this.getResource();
        }
        if (label.startsWith("Apps")) {
            int urlSegmentStart = label.indexOf("URLs");
            try {
                label = label.substring(urlSegmentStart + "URLs".length() + 1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        }
        return label;
    }

    public void write(DataOutput out) throws IOException {
        this.writeInternal(out);
    }

    public static TransactionComponentData read(DataInput in) throws IOException {
        TransactionComponentData data = new TransactionComponentData();
        data.readInternal(in);
        return data;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeInternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readInternal(in);
    }

    void addCorrelationKeys(Set keys) {
        LinkedList<TransactionComponentData> stack = new LinkedList<TransactionComponentData>();
        stack.addLast(this);
        while (!stack.isEmpty()) {
            TransactionComponentData current = (TransactionComponentData)stack.removeLast();
            current.addCorrelationKeys2(keys);
            int calledTraceCount = current.getSubNodeCount();
            int i = 0;
            while (i < calledTraceCount) {
                TransactionComponentData calledComponentData = current.getCalledComponent(i);
                stack.addLast(calledComponentData);
                ++i;
            }
        }
    }

    private void addCorrelationKeys2(Set keys) {
        Iterator parameters = this.fParameters.keySet().iterator();
        while (parameters.hasNext()) {
            String parameter = parameters.next().toString();
            if (!parameter.startsWith("Cor")) continue;
            StringBuffer keyValuePair = new StringBuffer();
            keyValuePair.append(parameter);
            keyValuePair.append(':');
            String value = StringUtils.stripQuerySpecialChars(this.getParameterValue(parameter));
            keyValuePair.append(value);
            keys.add(keyValuePair.toString());
        }
    }

    public int getAllComponentCount() {
        int result = 0;
        LinkedList<IEventDataNode> stack = new LinkedList<IEventDataNode>();
        stack.addLast(this);
        while (!stack.isEmpty()) {
            IEventDataNode current = (IEventDataNode)stack.removeLast();
            ++result;
            int calledTraceCount = current.getSubNodeCount();
            int i = 0;
            while (i < calledTraceCount) {
                IEventDataNode calledComponentData = current.getSubNode(i);
                stack.addLast(calledComponentData);
                ++i;
            }
        }
        return result;
    }

    public void writeInternal(DataOutput out) throws IOException {
        LinkedList<TransactionComponentData> stack = new LinkedList<TransactionComponentData>();
        stack.addLast(this);
        do {
            TransactionComponentData current = (TransactionComponentData)stack.removeLast();
            TransactionComponentData[] children = this.writeSelf(current, out);
            int i = children.length - 1;
            while (i >= 0) {
                stack.addLast(children[i]);
                --i;
            }
        } while (!stack.isEmpty());
    }

    private void readInternal(DataInput in) throws IOException {
        LinkedList<Object> stack = new LinkedList<Object>();
        stack.addLast(this);
        do {
            Object top;
            if ((top = stack.removeLast()) instanceof TTCalledComponentData) {
                TransactionComponentData child;
                int index;
                TTCalledComponentData children = (TTCalledComponentData)top;
                ++children.fNextIndex;
                TransactionComponentData[] calledComponents = children.fCalledComponents;
                if (index >= calledComponents.length) continue;
                calledComponents[index] = child = new TransactionComponentData();
                stack.addLast(children);
                stack.addLast(child);
                continue;
            }
            if (!(top instanceof TransactionComponentData)) continue;
            TransactionComponentData current = (TransactionComponentData)top;
            TTCalledComponentData children = new TTCalledComponentData();
            children.fCalledComponents = this.realizeSelf(current, in);
            stack.addLast(children);
        } while (!stack.isEmpty());
    }

    private TransactionComponentData[] writeSelf(TransactionComponentData data, DataOutput out) throws IOException {
        out.writeUTF(data.fResource);
        out.writeLong(data.fStartTime);
        out.writeLong(data.fDuration);
        out.writeInt(data.fParameters.size());
        for (Map.Entry entry : data.fParameters.entrySet()) {
            out.writeUTF((String)entry.getKey());
            if (entry.getValue() != null) {
                out.writeUTF(TransactionComponentData.clampString4WriteUTF((String)entry.getValue()));
                continue;
            }
            out.writeUTF("");
        }
        out.writeInt(data.fCalledComponents.length);
        return data.fCalledComponents;
    }

    protected static String clampString4WriteUTF(String str) {
        if (str.length() > kUTFStringMaxSize) {
            return str.substring(0, kUTFStringMaxSize);
        }
        return str;
    }

    private TransactionComponentData[] realizeSelf(TransactionComponentData self, DataInput in) throws IOException {
        int creationType;
        self.fResource = CanonicalObjectPool.getCanonicalString(in.readUTF());
        self.fStartTime = in.readLong();
        self.fDuration = in.readLong();
        int parameterCount = in.readInt();
        self.fParameters = parameterCount == 0 ? kNoParameters : new HashMap(parameterCount);
        int i = 0;
        while (i < parameterCount) {
            String key = CanonicalObjectPool.getCanonicalString(in.readUTF());
            String value = CanonicalObjectPool.getCanonicalString(in.readUTF());
            self.fParameters.put(key, value);
            ++i;
        }
        String val = (String)this.fParameters.get(kDataCreationKey);
        self.fDataCreationGranularity = val != null ? ((creationType = Integer.parseInt(val)) == 0 || creationType == 1 || creationType == 2 ? creationType : 0) : 0;
        int calledComponentCount = in.readInt();
        self.fCalledComponents = calledComponentCount == 0 ? kNoCalledComponents : new TransactionComponentData[calledComponentCount];
        return self.fCalledComponents;
    }

    private int basicHashCode() {
        int hashCode = 0;
        hashCode = this.fResource.hashCode();
        hashCode = HashCodeUtils.accumulateHashCode(hashCode, this.fStartTime);
        hashCode = HashCodeUtils.accumulateHashCode(hashCode, this.fDuration);
        hashCode = HashCodeUtils.accumulateHashCode(hashCode, this.fParameters.size());
        hashCode = HashCodeUtils.accumulateHashCode(hashCode, this.fParameters.hashCode());
        hashCode = HashCodeUtils.accumulateHashCode(hashCode, this.fDataCreationGranularity);
        return hashCode;
    }

    public int hashCode() {
        int hashCode = 0;
        LinkedList<TransactionComponentData> stack = new LinkedList<TransactionComponentData>();
        stack.addLast(this);
        while (!stack.isEmpty()) {
            TransactionComponentData current = (TransactionComponentData)stack.removeLast();
            int currentHashCode = current.fHashCode;
            if (currentHashCode != 0) {
                hashCode = HashCodeUtils.accumulateHashCode(hashCode, currentHashCode);
                continue;
            }
            currentHashCode = this.basicHashCode();
            hashCode = HashCodeUtils.accumulateHashCode(hashCode, currentHashCode);
            int calledTraceCount = current.getCalledComponentCount();
            int i = 0;
            while (i < calledTraceCount) {
                TransactionComponentData calledComponentData = current.getCalledComponent(i);
                stack.addLast(calledComponentData);
                ++i;
            }
        }
        this.fHashCode = hashCode;
        return hashCode;
    }

    private boolean basicEquals(TransactionComponentData tcd) {
        return tcd.fDuration == this.fDuration && tcd.fStartTime == this.fStartTime && tcd.fResource.equals(this.fResource) && tcd.fCalledComponents.length == this.fCalledComponents.length && tcd.fParameters.equals(this.fParameters) && tcd.fDataCreationGranularity == this.fDataCreationGranularity;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionComponentData)) {
            return false;
        }
        TransactionComponentData tcd = (TransactionComponentData)o;
        LinkedList<TransactionComponentData> stack = new LinkedList<TransactionComponentData>();
        stack.addLast(tcd);
        stack.addLast(this);
        while (!stack.isEmpty()) {
            TransactionComponentData tcd2;
            TransactionComponentData tcd1 = (TransactionComponentData)stack.removeLast();
            if (!tcd1.basicEquals(tcd2 = (TransactionComponentData)stack.removeLast())) {
                return false;
            }
            int calledTraceCount = tcd1.getCalledComponentCount();
            int i = 0;
            while (i < calledTraceCount) {
                TransactionComponentData calledComponentData2 = tcd2.getCalledComponent(i);
                stack.addLast(calledComponentData2);
                TransactionComponentData calledComponentData1 = tcd1.getCalledComponent(i);
                stack.addLast(calledComponentData1);
                ++i;
            }
        }
        return true;
    }

    public boolean isServlet() {
        return this.fResource.toLowerCase().indexOf("servlet") > -1;
    }

    private static class TTCalledComponentData {
        public TransactionComponentData[] fCalledComponents;
        public int fNextIndex;

        private TTCalledComponentData() {
        }
    }
}

