/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.zos;

import com.wily.powerpack.zos.LibraryLoader;
import java.io.UnsupportedEncodingException;

public class SystemInfo {
    private static final String EBCDIC = "Cp500";
    private static final int STRINGS_ARRAY_SIZE = 65;
    private static final int JOB_NAME_OFFSET = 0;
    private static final int JOB_NAME_LENGTH = 8;
    private static final int SYSTEM_NAME_OFFSET = 8;
    private static final int SYSTEM_NAME_LENGTH = 8;
    private static final int SYSID_OFFSET = 16;
    private static final int SYSID_LENGTH = 4;
    private static final int SYSPLEX_NAME_OFFSET = 20;
    private static final int SYSPLEX_NAME_LENGTH = 8;
    private static final int LPAR_NAME_OFFSET = 28;
    private static final int LPAR_NAME_LENGTH = 8;
    private static final int OS_NAME_OFFSET = 36;
    private static final int OS_NAME_LENGTH = 16;
    private static final int OS_VERSION_OFFSET = 52;
    private static final int OS_VERSION_LENGTH = 6;
    private static final int SYSINFO_ARRAY_SIZE = 32;
    private static final int CPUS_ONLINE = 0;
    private static final int ZAAPS_ONLINE = 1;
    private static final int ZIIPS_ONLINE = 2;
    private static final int AVG_CPU_USAGE = 3;
    private static final int PAGING_RATE = 4;
    private static final int RAW_MIPS = 5;
    private static final int RAW_MSUS = 6;
    private static final int JOB_ASID = 7;
    private static final int JOB_TCB_TIME = 8;
    private static final int JOB_SRB_TIME = 9;
    private static final int JOB_ZAAP_TIME = 10;
    private static final int JOB_ZIIP_TIME = 11;
    private static final int USER_BELOW_16MB = 12;
    private static final int LSQA_BELOW_16MB = 13;
    private static final int USER_ABOVE_16MB = 14;
    private static final int LSQA_ABOVE_16MB = 15;
    private static final int TIMER_ARRAY_SIZE = 12;
    private static final int CPU_TIME = 0;
    private static final int ZAAP_TIME = 1;
    private static final int ZIIP_TIME = 2;
    private String jobName;
    private String systemName;
    private String sysid;
    private String sysplexName;
    private String lparName;
    private String osName;
    private String osVersion;
    private String hexAsid;
    private long cpusOnline;
    private long zaapsOnline;
    private long ziipsOnline;
    private long averageCpuUsage;
    private long pagingRate;
    private long mips;
    private long msus;
    private long tcbTime;
    private long srbTime;
    private long totalTime;
    private long zaapTime;
    private long ziipTime;
    private long userPrivateBelow16MB;
    private long userPrivateAbove16MB;
    private long lsqaPrivateBelow16MB;
    private long lsqaPrivateAbove16MB;

    public static native void getCurrentTaskInfoJni(byte[] var0, long[] var1);

    public static native void getCurrentProcessorTimesJni(long[] var0);

    public String getJobName() {
        return this.jobName;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public String getSysid() {
        return this.sysid;
    }

    public String getSysplexName() {
        return this.sysplexName;
    }

    public String getLparName() {
        return this.lparName;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getHexAsid() {
        return this.hexAsid;
    }

    public long getCpusOnline() {
        return this.cpusOnline;
    }

    public long getZaapsOnline() {
        return this.zaapsOnline;
    }

    public long getZiipsOnline() {
        return this.ziipsOnline;
    }

    public long getAverageCpuUsage() {
        return this.averageCpuUsage;
    }

    public long getPagingRate() {
        return this.pagingRate;
    }

    public long getMips() {
        return this.mips;
    }

    public long getMsus() {
        return this.msus;
    }

    public long getTcbTime() {
        return this.tcbTime;
    }

    public long getSrbTime() {
        return this.srbTime;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public long getZaapTime() {
        return this.zaapTime;
    }

    public long getZiipTime() {
        return this.ziipTime;
    }

    public long getUserPrivateBelow16MB() {
        return this.userPrivateBelow16MB;
    }

    public long getUserPrivateAbove16MB() {
        return this.userPrivateAbove16MB;
    }

    public long getLsqaPrivateBelow16MB() {
        return this.lsqaPrivateBelow16MB;
    }

    public long getLsqaPrivateAbove16MB() {
        return this.lsqaPrivateAbove16MB;
    }

    public void updateCurrentTaskInfo() {
        if (!LibraryLoader.libraryLoaded()) {
            return;
        }
        byte[] strings = new byte[65];
        long[] sysinfo = new long[32];
        try {
            SystemInfo.getCurrentTaskInfoJni(strings, sysinfo);
        }
        catch (Exception e) {
            System.out.println(e);
            return;
        }
        this.jobName = this.stringFromByteArray(strings, 0, 8);
        this.systemName = this.stringFromByteArray(strings, 8, 8);
        this.sysid = this.stringFromByteArray(strings, 16, 4);
        this.sysplexName = this.stringFromByteArray(strings, 20, 8);
        this.lparName = this.stringFromByteArray(strings, 28, 8);
        this.osName = this.stringFromByteArray(strings, 36, 16);
        this.osVersion = this.stringFromByteArray(strings, 52, 6);
        if (this.lparName.length() == 0) {
            this.lparName = "- none -";
        }
        long decimalAsid = sysinfo[7];
        this.hexAsid = Long.toHexString(decimalAsid).toUpperCase();
        this.cpusOnline = sysinfo[0];
        this.zaapsOnline = sysinfo[1];
        this.ziipsOnline = sysinfo[2];
        this.averageCpuUsage = sysinfo[3];
        this.pagingRate = sysinfo[4];
        this.mips = (sysinfo[5] + 500L) / 1000L;
        this.msus = sysinfo[6];
        this.tcbTime = sysinfo[8];
        this.srbTime = sysinfo[9];
        this.totalTime = this.tcbTime + this.srbTime;
        this.zaapTime = sysinfo[10];
        this.ziipTime = sysinfo[11];
        this.userPrivateBelow16MB = sysinfo[12];
        this.userPrivateAbove16MB = sysinfo[14];
        this.lsqaPrivateBelow16MB = sysinfo[13];
        this.lsqaPrivateAbove16MB = sysinfo[15];
    }

    private String stringFromByteArray(byte[] array, int offset, int length) {
        String result = null;
        try {
            result = new String(array, offset, length, EBCDIC).trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            result = "Unsupported encoding!";
        }
        return result;
    }

    public void updateCurrentProcessorTimes() {
        if (!LibraryLoader.libraryLoaded()) {
            return;
        }
        long[] times = new long[12];
        try {
            SystemInfo.getCurrentProcessorTimesJni(times);
        }
        catch (Exception e) {
            System.out.println(e);
            return;
        }
        this.totalTime = times[0];
        this.zaapTime = times[1];
        this.ziipTime = times[2];
    }
}

