/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.zos;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.ILongCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.IStringConstantDataAccumulator;
import com.wily.powerpack.zos.LibraryLoader;
import com.wily.powerpack.zos.SystemInfo;
import com.wily.powerpack.zos.TimerDeltaCalculator;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.ConfigurationProperty;

public final class SystemInfoPoller
implements ITimestampedRunnable {
    private static IAgent agent;
    private static final String PROCESS_NODE = "Process Overview";
    private static final String HEX_ASID_METRIC = "Process ASCB Id (Hex)";
    private IStringConstantDataAccumulator hexAsidMetric;
    private static final String JOB_NAME_METRIC = "Process Job Name";
    private IStringConstantDataAccumulator jobNameMetric;
    private static final String LSQA_PRIVATE_ABOVE_16MB_METRIC = "Process OS Memory Allocated above 16MB (kb) High water mark";
    private ILongFluctuatingCounterDataAccumulator lsqaPrivateAbove16MBMetric;
    private static final String LSQA_PRIVATE_BELOW_16MB_METRIC = "Process OS Memory Allocated below 16MB (kb) High water mark";
    private ILongFluctuatingCounterDataAccumulator lsqaPrivateBelow16MBMetric;
    private static final String SRB_PROCESSOR_TIME_METRIC = "Process SRB CPU Time Cumulative (usecs)";
    private ILongFluctuatingCounterDataAccumulator srbProcessorTimeMetric;
    private static final String SRB_PROCESSOR_TIME_DELTA_METRIC = "Process SRB CPU Time Interval Delta (usecs)";
    private ILongFluctuatingCounterDataAccumulator srbProcessorTimeDeltaMetric;
    private static final String TCB_PROCESSOR_TIME_METRIC = "Process TCB CPU Time Cumulative (usecs)";
    private ILongFluctuatingCounterDataAccumulator tcbProcessorTimeMetric;
    private static final String TCB_PROCESSOR_TIME_DELTA_METRIC = "Process TCB CPU Time Interval Delta (usecs)";
    private ILongFluctuatingCounterDataAccumulator tcbProcessorTimeDeltaMetric;
    private static final String TOTAL_PROCESSOR_TIME_METRIC = "Process Total CPU Time Cumulative (usecs)";
    private ILongFluctuatingCounterDataAccumulator totalProcessorTimeMetric;
    private static final String TOTAL_PROCESSOR_TIME_DELTA_METRIC = "Process Total CPU Time Interval Delta (usecs)";
    private ILongFluctuatingCounterDataAccumulator totalProcessorTimeDeltaMetric;
    private static final String USER_PRIVATE_ABOVE_16MB_METRIC = "Process User Memory Allocated above 16MB (kb) High water mark";
    private ILongFluctuatingCounterDataAccumulator userPrivateAbove16MBMetric;
    private static final String USER_PRIVATE_BELOW_16MB_METRIC = "Process User Memory Allocated below 16MB (kb) High water mark";
    private ILongFluctuatingCounterDataAccumulator userPrivateBelow16MBMetric;
    private static final String TOTAL_ZAAP_TIME_METRIC = "Process zAAP Time Cumulative (usecs)";
    private ILongFluctuatingCounterDataAccumulator totalZaapTimeMetric;
    private static final String TOTAL_ZAAP_TIME_DELTA_METRIC = "Process zAAP Time Interval Delta (usecs)";
    private ILongFluctuatingCounterDataAccumulator totalZaapTimeDeltaMetric;
    private static final String TOTAL_ZIIP_TIME_METRIC = "Process zIIP Time Cumulative (usecs)";
    private ILongFluctuatingCounterDataAccumulator totalZiipTimeMetric;
    private static final String TOTAL_ZIIP_TIME_DELTA_METRIC = "Process zIIP Time Interval Delta (usecs)";
    private ILongFluctuatingCounterDataAccumulator totalZiipTimeDeltaMetric;
    private static final String SYSTEM_NODE = "System Overview";
    private static final String LPAR_NAME_METRIC = "LPAR Name";
    private IStringConstantDataAccumulator lparNameMetric;
    private static final String OS_NAME_METRIC = "Operating System";
    private IStringConstantDataAccumulator osNameMetric;
    private static final String OS_VERSION_METRIC = "Operating System Version Level";
    private IStringConstantDataAccumulator osVersionMetric;
    private static final String SYSID_METRIC = "Sys Id";
    private IStringConstantDataAccumulator sysidMetric;
    private static final String SYSPLEX_NAME_METRIC = "Sysplex Name";
    private IStringConstantDataAccumulator sysplexNameMetric;
    private static final String MIPS_METRIC = "System Approximate MIPs Capacity";
    private ILongFluctuatingCounterDataAccumulator mipsMetric;
    private static final String AVERAGE_CPU_USAGE_METRIC = "System Average CPU Utilization (%)";
    private ILongFluctuatingCounterDataAccumulator averageCpuUsageMetric;
    private static final String MSUS_METRIC = "System MSU Capacity";
    private ILongFluctuatingCounterDataAccumulator msusMetric;
    private static final String SYSTEM_NAME_METRIC = "System Name";
    private IStringConstantDataAccumulator systemNameMetric;
    private static final String CPUS_ONLINE_METRIC = "System Number of Active CPUs";
    private ILongFluctuatingCounterDataAccumulator cpusOnlineMetric;
    private static final String ZAAPS_ONLINE_METRIC = "System Number of Online zAAPs";
    private ILongFluctuatingCounterDataAccumulator zaapsOnlineMetric;
    private static final String ZIIPS_ONLINE_METRIC = "System Number of Online zIIPs";
    private ILongFluctuatingCounterDataAccumulator ziipsOnlineMetric;
    private static final String PAGING_RATE_METRIC = "System Paging Rate (pages/sec)";
    private ILongFluctuatingCounterDataAccumulator pagingRateMetric;
    private TimerDeltaCalculator calculator;
    private static final String SYSTEM_METRIC_ENABLED_PROP = "introscope.agent.zos.system.metrics.enabled";
    private static boolean systemMetricEnabled;
    private static final String PROCESS_METRIC_ENABLED_PROP = "introscope.agent.zos.process.metrics.enabled";
    private static boolean processMetricEnabled;

    static {
        systemMetricEnabled = true;
        processMetricEnabled = true;
    }

    public SystemInfoPoller(IAgent agent) {
        try {
            SystemInfoPoller.agent = agent;
            this.initializeReportProperties(agent);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    private void initializeReportProperties(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        BooleanConfigurationProperty systemMetricEnabledProperty = new BooleanConfigurationProperty(SYSTEM_METRIC_ENABLED_PROP, Boolean.TRUE, "Enables/Disables system metrics", true, false, agent.IAgent_getModuleFeedback(), agent.IAgent_getModule(), agent.IAgent_getStringLocalizer()){

            public void set(Object newValue) {
                systemMetricEnabled = (Boolean)newValue;
                SystemInfoPoller.this.updateSysMetricsTest();
            }
        };
        configManager.add((ConfigurationProperty)systemMetricEnabledProperty, true);
        BooleanConfigurationProperty processMetricEnabledProperty = new BooleanConfigurationProperty(PROCESS_METRIC_ENABLED_PROP, Boolean.TRUE, "Enables/Disables process metrics", true, false, agent.IAgent_getModuleFeedback(), agent.IAgent_getModule(), agent.IAgent_getStringLocalizer()){

            public void set(Object newValue) {
                processMetricEnabled = (Boolean)newValue;
                SystemInfoPoller.this.updateProcessMetricsTest();
            }
        };
        configManager.add((ConfigurationProperty)processMetricEnabledProperty, true);
    }

    private SystemInfo initializeSystemInfo() {
        try {
            SystemInfo info = new SystemInfo();
            info.updateCurrentTaskInfo();
            if (this.calculator == null) {
                this.calculator = new TimerDeltaCalculator();
            }
            this.calculator.setFromInfo(info);
            return info;
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return null;
        }
    }

    public void ITimestampedRunnable_execute(long nowInMillis) {
        if (!LibraryLoader.libraryLoaded()) {
            return;
        }
        if (!processMetricEnabled && !systemMetricEnabled) {
            return;
        }
        try {
            SystemInfo info = new SystemInfo();
            info.updateCurrentTaskInfo();
            this.calculator.setFromInfo(info);
            if (processMetricEnabled) {
                this.recordLongValue((ILongCounterDataAccumulator)this.lsqaPrivateAbove16MBMetric, info.getLsqaPrivateAbove16MB());
                this.recordLongValue((ILongCounterDataAccumulator)this.lsqaPrivateBelow16MBMetric, info.getLsqaPrivateBelow16MB());
                this.recordLongValue((ILongCounterDataAccumulator)this.srbProcessorTimeDeltaMetric, this.calculator.getSrbProcessorTimeDelta());
                this.recordLongValue((ILongCounterDataAccumulator)this.srbProcessorTimeMetric, this.calculator.getSrbProcessorTime());
                this.recordLongValue((ILongCounterDataAccumulator)this.tcbProcessorTimeDeltaMetric, this.calculator.getTcbProcessorTimeDelta());
                this.recordLongValue((ILongCounterDataAccumulator)this.tcbProcessorTimeMetric, this.calculator.getTcbProcessorTime());
                this.recordLongValue((ILongCounterDataAccumulator)this.totalProcessorTimeDeltaMetric, this.calculator.getTotalProcessorTimeDelta());
                this.recordLongValue((ILongCounterDataAccumulator)this.totalProcessorTimeMetric, this.calculator.getTotalProcessorTime());
                this.recordLongValue((ILongCounterDataAccumulator)this.totalZaapTimeDeltaMetric, this.calculator.getTotalZaapTimeDelta());
                this.recordLongValue((ILongCounterDataAccumulator)this.totalZaapTimeMetric, this.calculator.getTotalZaapTime());
                this.recordLongValue((ILongCounterDataAccumulator)this.userPrivateAbove16MBMetric, info.getUserPrivateAbove16MB());
                this.recordLongValue((ILongCounterDataAccumulator)this.userPrivateBelow16MBMetric, info.getUserPrivateBelow16MB());
                this.recordLongValue((ILongCounterDataAccumulator)this.totalZiipTimeDeltaMetric, this.calculator.getTotalZiipTimeDelta());
                this.recordLongValue((ILongCounterDataAccumulator)this.totalZiipTimeMetric, this.calculator.getTotalZiipTime());
            }
            if (systemMetricEnabled) {
                this.recordLongValue((ILongCounterDataAccumulator)this.mipsMetric, info.getMips());
                this.recordLongValue((ILongCounterDataAccumulator)this.averageCpuUsageMetric, info.getAverageCpuUsage());
                this.recordLongValue((ILongCounterDataAccumulator)this.msusMetric, info.getMsus());
                this.recordLongValue((ILongCounterDataAccumulator)this.cpusOnlineMetric, info.getCpusOnline());
                this.recordLongValue((ILongCounterDataAccumulator)this.zaapsOnlineMetric, info.getZaapsOnline());
                this.recordLongValue((ILongCounterDataAccumulator)this.ziipsOnlineMetric, info.getZiipsOnline());
                this.recordLongValue((ILongCounterDataAccumulator)this.pagingRateMetric, info.getPagingRate());
            }
            this.calculator.rememberValuesForNextPass();
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    void recordLongValue(ILongCounterDataAccumulator metric, long value) {
        if (metric != null && !metric.IDataAccumulator_isShutOff()) {
            metric.ILongCounterDataAccumulator_setValue(value);
        }
    }

    private void updateSysMetricsTest() {
        DataAccumulatorFactory factory = agent.IAgent_getDataAccumulatorFactory();
        if (systemMetricEnabled) {
            String mName;
            SystemInfo sysInfo = this.initializeSystemInfo();
            if (this.lparNameMetric == null) {
                mName = "System Overview:LPAR Name";
                this.lparNameMetric = factory.safeGetStringConstantDataAccumulator(mName, sysInfo.getLparName());
            }
            if (this.osNameMetric == null) {
                mName = "System Overview:Operating System";
                this.osNameMetric = factory.safeGetStringConstantDataAccumulator(mName, sysInfo.getOsName());
            }
            if (this.osVersionMetric == null) {
                mName = "System Overview:Operating System Version Level";
                this.osVersionMetric = factory.safeGetStringConstantDataAccumulator(mName, sysInfo.getOsVersion());
            }
            if (this.sysidMetric == null) {
                mName = "System Overview:Sys Id";
                this.sysidMetric = factory.safeGetStringConstantDataAccumulator(mName, sysInfo.getSysid());
            }
            if (this.sysplexNameMetric == null) {
                mName = "System Overview:Sysplex Name";
                this.sysplexNameMetric = factory.safeGetStringConstantDataAccumulator(mName, sysInfo.getSysplexName());
            }
            if (this.mipsMetric == null) {
                mName = "System Overview:System Approximate MIPs Capacity";
                this.mipsMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
            }
            if (this.averageCpuUsageMetric == null) {
                mName = "System Overview:System Average CPU Utilization (%)";
                this.averageCpuUsageMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
            }
            if (this.msusMetric == null) {
                mName = "System Overview:System MSU Capacity";
                this.msusMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
            }
            if (this.systemNameMetric == null) {
                mName = "System Overview:System Name";
                this.systemNameMetric = factory.safeGetStringConstantDataAccumulator(mName, sysInfo.getSystemName());
            }
            if (this.cpusOnlineMetric == null) {
                mName = "System Overview:System Number of Active CPUs";
                this.cpusOnlineMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
            }
            if (this.zaapsOnlineMetric == null) {
                mName = "System Overview:System Number of Online zAAPs";
                this.zaapsOnlineMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
            }
            if (this.ziipsOnlineMetric == null) {
                mName = "System Overview:System Number of Online zIIPs";
                this.ziipsOnlineMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
            }
            if (this.pagingRateMetric == null) {
                mName = "System Overview:System Paging Rate (pages/sec)";
                this.pagingRateMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
            }
        } else {
            if (this.lparNameMetric != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.lparNameMetric);
                this.lparNameMetric = null;
            }
            if (this.osNameMetric != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.osNameMetric);
                this.osNameMetric = null;
            }
            if (this.osVersionMetric != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.osVersionMetric);
                this.osVersionMetric = null;
            }
            if (this.sysidMetric != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.sysidMetric);
                this.sysidMetric = null;
            }
            if (this.sysplexNameMetric != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.sysplexNameMetric);
                this.sysplexNameMetric = null;
            }
            if (this.mipsMetric != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.mipsMetric);
                this.mipsMetric = null;
            }
            if (this.averageCpuUsageMetric != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.averageCpuUsageMetric);
                this.averageCpuUsageMetric = null;
            }
            if (this.msusMetric != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.msusMetric);
                this.msusMetric = null;
            }
            if (this.systemNameMetric != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.systemNameMetric);
                this.systemNameMetric = null;
            }
            if (this.cpusOnlineMetric != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.cpusOnlineMetric);
                this.cpusOnlineMetric = null;
            }
            if (this.zaapsOnlineMetric != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.zaapsOnlineMetric);
                this.zaapsOnlineMetric = null;
            }
            if (this.ziipsOnlineMetric != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.ziipsOnlineMetric);
                this.ziipsOnlineMetric = null;
            }
            if (this.pagingRateMetric != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.pagingRateMetric);
                this.pagingRateMetric = null;
            }
        }
    }

    private void updateProcessMetricsTest() {
        DataAccumulatorFactory factory = agent.IAgent_getDataAccumulatorFactory();
        if (processMetricEnabled) {
            String mName;
            SystemInfo sysInfo = this.initializeSystemInfo();
            if (this.hexAsidMetric == null) {
                mName = "Process Overview:Process ASCB Id (Hex)";
                this.hexAsidMetric = factory.safeGetStringConstantDataAccumulator(mName, sysInfo.getHexAsid());
            }
            if (this.jobNameMetric == null) {
                mName = "Process Overview:Process Job Name";
                this.jobNameMetric = factory.safeGetStringConstantDataAccumulator(mName, sysInfo.getJobName());
            }
            if (this.lsqaPrivateAbove16MBMetric == null) {
                mName = "Process Overview:Process OS Memory Allocated above 16MB (kb) High water mark";
                this.lsqaPrivateAbove16MBMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
            }
            if (this.lsqaPrivateBelow16MBMetric == null) {
                mName = "Process Overview:Process OS Memory Allocated below 16MB (kb) High water mark";
                this.lsqaPrivateBelow16MBMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
            }
            if (this.srbProcessorTimeMetric == null) {
                mName = "Process Overview:Process SRB CPU Time Cumulative (usecs)";
                this.srbProcessorTimeMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
            }
            if (this.srbProcessorTimeDeltaMetric == null) {
                mName = "Process Overview:Process SRB CPU Time Interval Delta (usecs)";
                this.srbProcessorTimeDeltaMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
            }
            if (this.tcbProcessorTimeMetric == null) {
                mName = "Process Overview:Process TCB CPU Time Cumulative (usecs)";
                this.tcbProcessorTimeMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
            }
            if (this.tcbProcessorTimeDeltaMetric == null) {
                mName = "Process Overview:Process TCB CPU Time Interval Delta (usecs)";
                this.tcbProcessorTimeDeltaMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
            }
            if (this.totalProcessorTimeMetric == null) {
                mName = "Process Overview:Process Total CPU Time Cumulative (usecs)";
                this.totalProcessorTimeMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
            }
            if (this.totalProcessorTimeDeltaMetric == null) {
                mName = "Process Overview:Process Total CPU Time Interval Delta (usecs)";
                this.totalProcessorTimeDeltaMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
            }
            if (this.userPrivateAbove16MBMetric == null) {
                mName = "Process Overview:Process User Memory Allocated above 16MB (kb) High water mark";
                this.userPrivateAbove16MBMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
            }
            if (this.userPrivateBelow16MBMetric == null) {
                mName = "Process Overview:Process User Memory Allocated below 16MB (kb) High water mark";
                this.userPrivateBelow16MBMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
            }
            if (this.totalZaapTimeMetric == null) {
                mName = "Process Overview:Process zAAP Time Cumulative (usecs)";
                this.totalZaapTimeMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
            }
            if (this.totalZaapTimeDeltaMetric == null) {
                mName = "Process Overview:Process zAAP Time Interval Delta (usecs)";
                this.totalZaapTimeDeltaMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
            }
            if (this.totalZiipTimeMetric == null) {
                mName = "Process Overview:Process zIIP Time Cumulative (usecs)";
                this.totalZiipTimeMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
            }
            if (this.totalZiipTimeDeltaMetric == null) {
                mName = "Process Overview:Process zIIP Time Interval Delta (usecs)";
                this.totalZiipTimeDeltaMetric = factory.safeGetLongFluctuatingCounterDataAccumulator(mName);
            }
        } else {
            if (this.hexAsidMetric != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.hexAsidMetric);
                this.hexAsidMetric = null;
            }
            if (this.jobNameMetric != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.jobNameMetric);
                this.jobNameMetric = null;
            }
            if (this.lsqaPrivateAbove16MBMetric != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.lsqaPrivateAbove16MBMetric);
                this.lsqaPrivateAbove16MBMetric = null;
            }
            if (this.lsqaPrivateBelow16MBMetric != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.lsqaPrivateBelow16MBMetric);
                this.lsqaPrivateBelow16MBMetric = null;
            }
            if (this.srbProcessorTimeMetric != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.srbProcessorTimeMetric);
                this.srbProcessorTimeMetric = null;
            }
            if (this.srbProcessorTimeDeltaMetric != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.srbProcessorTimeDeltaMetric);
                this.srbProcessorTimeDeltaMetric = null;
            }
            if (this.tcbProcessorTimeMetric != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.tcbProcessorTimeMetric);
                this.tcbProcessorTimeMetric = null;
            }
            if (this.tcbProcessorTimeDeltaMetric != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.tcbProcessorTimeDeltaMetric);
                this.tcbProcessorTimeDeltaMetric = null;
            }
            if (this.totalProcessorTimeMetric != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.totalProcessorTimeMetric);
                this.totalProcessorTimeMetric = null;
            }
            if (this.totalProcessorTimeDeltaMetric != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.totalProcessorTimeDeltaMetric);
                this.totalProcessorTimeDeltaMetric = null;
            }
            if (this.userPrivateAbove16MBMetric != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.userPrivateAbove16MBMetric);
                this.userPrivateAbove16MBMetric = null;
            }
            if (this.userPrivateBelow16MBMetric != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.userPrivateBelow16MBMetric);
                this.userPrivateBelow16MBMetric = null;
            }
            if (this.totalZaapTimeMetric != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.totalZaapTimeMetric);
                this.totalZaapTimeMetric = null;
            }
            if (this.totalZaapTimeDeltaMetric != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.totalZaapTimeDeltaMetric);
                this.totalZaapTimeDeltaMetric = null;
            }
            if (this.totalZiipTimeMetric != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.totalZiipTimeMetric);
                this.totalZiipTimeMetric = null;
            }
            if (this.totalZiipTimeDeltaMetric != null) {
                factory.removeDataAccumulator((IDataAccumulator)this.totalZiipTimeDeltaMetric);
                this.totalZiipTimeDeltaMetric = null;
            }
        }
    }
}

