/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.zos;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.service.ASimpleService;
import com.wily.powerpack.zos.LibraryLoader;
import com.wily.powerpack.zos.SystemInfoPoller;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.heartbeat.ITimestampedRunnable;
import java.util.Map;

public final class SystemInfoService
extends ASimpleService {
    private static final String CLASS_NAME = "SystemInfoService";
    private static final String DISABLE_PARAMETER = "ppzos.componentagent.overview.disable";
    private static final int HEARTBEAT_IN_MILLIS = 1000;

    public SystemInfoService() {
        super(CLASS_NAME);
    }

    protected final void doStartService(IAgent agent, Map parameters) throws Exception {
        IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
        boolean systemOverviewDisabled = agent.IAgent_getIndexedProperties().safeGetBooleanProperty(DISABLE_PARAMETER, false, feedback, agent.IAgent_getStringLocalizer());
        if (systemOverviewDisabled) {
            feedback.warn("System Overview statistics are disabled.");
            return;
        }
        LibraryLoader.loadLibrary(agent);
        agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)new SystemInfoPoller(agent), CLASS_NAME, true, 1000L, false);
        feedback.info("SystemInfoService has been started.");
    }
}

