/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.zos.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.ILongAverageDataAccumulator;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.ASingleInstanceTracerFactoryHC;
import com.wily.powerpack.zos.LibraryLoader;
import com.wily.powerpack.zos.SystemInfo;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;

public final class ProcessorTimeTracer
extends ASingleInstanceTracerFactoryHC {
    private static final Module kModule = new Module("zOS.ProcessorTime");
    private static IModuleFeedbackChannel feedback;
    private ReentrancyLevel fReentrancyLevel;
    InvocationData startData;
    private static final String PROCESSOR_TIMES_KEY = "PROCESSOR_TIMES_KEY";
    private static final String ZAAP_TIME_METRIC = "ZAAP CPU Time (us)";
    private static final String ZIIP_TIME_METRIC = "ZIIP CPU Time (us)";

    public ProcessorTimeTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        feedback = this.getAgent().IAgent_getModuleFeedback();
        this.fReentrancyLevel = this.calculateReentrancyLevel(ReentrancyLevel.kNone);
        try {
            LibraryLoader.loadLibrary(agent);
        }
        catch (Exception e) {
            System.out.println("ProcessorTimeTracer can't load library: " + e.toString());
            feedback.warn(kModule, "ProcessorTimeTracer can't load library: " + e.toString());
        }
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        if (!LibraryLoader.libraryLoaded()) {
            return;
        }
        this.startData = data;
        this.saveStartProcessorTimesIn(data);
    }

    private void saveStartProcessorTimesIn(InvocationData data) {
        try {
            data.put(PROCESSOR_TIMES_KEY, (Object)new ProcessorTimes());
        }
        catch (Exception e) {
            feedback.error(kModule, "Save the processor times exception: ", (Throwable)e);
        }
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        try {
            this.recordMetrics(data);
        }
        catch (Exception e) {
            feedback.error(kModule, "Record metrics exception: ", (Throwable)e);
        }
    }

    private void recordMetrics(InvocationData data) throws Exception {
        if (!LibraryLoader.libraryLoaded()) {
            return;
        }
        if (data == null) {
            return;
        }
        String nodeName = this.nodeNameFromData(data);
        if (nodeName == null) {
            System.out.println("ProcessorTimeTracer is unable to extract a node name");
            feedback.info(kModule, "ProcessorTimeTracer is unable to extract a node name");
            return;
        }
        ProcessorTimes begin = (ProcessorTimes)data.get(PROCESSOR_TIMES_KEY);
        ProcessorTimes end = new ProcessorTimes();
        long cpTimeDelta = this.nonNegative(end.cpTime - begin.cpTime);
        long zaapTimeDelta = this.nonNegative(end.zaapTime - begin.zaapTime);
        long ziipTimeDelta = this.nonNegative(end.ziipTime - begin.ziipTime);
        ILongAverageDataAccumulator cpTimeMetric = this.getDataAccumulatorFactory().safeGetLongAverageDataAccumulator(this.getComponentName(data));
        ILongAverageDataAccumulator zaapTimeMetric = this.metricFor(nodeName, ZAAP_TIME_METRIC);
        ILongAverageDataAccumulator ziipTimeMetric = this.metricFor(nodeName, ZIIP_TIME_METRIC);
        this.recordMetric(cpTimeMetric, cpTimeDelta);
        this.recordMetric(zaapTimeMetric, zaapTimeDelta);
        this.recordMetric(ziipTimeMetric, ziipTimeDelta);
    }

    private String nodeNameFromData(InvocationData data) {
        String fullMetricName = data.getComponentName();
        if (fullMetricName == null) {
            fullMetricName = data.getOriginalComponentName();
        }
        if (fullMetricName == null) {
            fullMetricName = this.formatParameterizedName(data);
        }
        if (fullMetricName == null) {
            return null;
        }
        return this.nodeNameFromFullMetric(fullMetricName);
    }

    private String nodeNameFromFullMetric(String fullMetricName) {
        int colonOffset = fullMetricName.indexOf(":");
        return colonOffset > 0 ? fullMetricName.substring(0, colonOffset) : fullMetricName;
    }

    private ILongAverageDataAccumulator metricFor(String nodeName, String metricName) {
        String fullMetricName = String.valueOf(nodeName) + ":" + metricName;
        return this.getDataAccumulatorFactory().safeGetLongAverageDataAccumulator(fullMetricName);
    }

    private void recordMetric(ILongAverageDataAccumulator metric, long value) {
        if (this.shouldRecordMetric(metric)) {
            metric.ILongAggregatingDataAccumulator_recordDataPoint(value);
        }
    }

    private boolean shouldRecordMetric(ILongAverageDataAccumulator metric) {
        return metric != null && !metric.IDataAccumulator_isShutOff();
    }

    private long nonNegative(long value) {
        return value < 0L ? 0L : value;
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReentrancyLevel;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    protected void doOnAbortedTransactionEndTrace(int i, IStackElement iStackElement) {
    }

    public void doOnStartTrace(int i, IStackElement iStackElement, ITransactionElement iTransactionElement) {
    }

    public void doOnEndTrace(int i, IStackElement iStackElement, ITransactionElement iTransactionElement) {
    }

    private class ProcessorTimes {
        public long cpTime;
        public long zaapTime;
        public long ziipTime;

        public ProcessorTimes() {
            SystemInfo info = new SystemInfo();
            info.updateCurrentProcessorTimes();
            this.cpTime = info.getTotalTime();
            this.zaapTime = info.getZaapTime();
            this.ziipTime = info.getZiipTime();
        }
    }
}

