/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.KConstants;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.IWSNameFormatter;
import com.wily.powerpack.webservices.metricgrouping.WebservicesGroupPropertyHandler;
import com.wily.util.StringUtils;
import com.wily.util.properties.hot.PropertyGroupListner;
import java.util.concurrent.atomic.AtomicReference;

public abstract class ANameFormatter
implements IWSNameFormatter,
KConstants {
    private final IAgent fAgent;
    private static final AtomicReference<WebservicesGroupPropertyHandler> webservicesGroupPropertyHandlerHolder = new AtomicReference();

    public ANameFormatter(IAgent agent) {
        this.fAgent = agent;
        ANameFormatter.setupWSNamespaceGroupingSettings(this.fAgent);
    }

    @Override
    public String getServiceName(InvocationData data) {
        return "UnknownService";
    }

    public ClassLoader setClassLoader(ClassLoader cl, IAgent agent) {
        WSMUtils.getLogger().debug("anameformatter.setClassLoader()");
        return WSMUtils.setClassLoader(cl, agent);
    }

    protected Class getClassFromInvocationObjectLoader(String className, InvocationData data) throws ClassNotFoundException {
        Class<?> clazz = (Class<?>)data.get(className);
        if (clazz == null) {
            String classNameString = data.getInvocationObject().getClass().getName();
            ClassLoader cl = data.getInvocationObject().getClass().getClassLoader();
            if (classNameString.indexOf("com.wily") >= 0) {
                cl = cl.getParent();
            }
            WSMUtils.getLogger().debug("anameformatter.getClassFromInvocationObjectLoader(): " + data.getInvocationObject().getClass().getName());
            ClassLoader classLoader = this.setClassLoader(cl, this.getAgent());
            if (classLoader != null) {
                clazz = classLoader.loadClass(className);
                data.put(className, clazz);
            } else {
                WSMUtils.getLogger().error("anameformatter, wsdmclassloader is null");
            }
        }
        return clazz;
    }

    protected IAgent getAgent() {
        return this.fAgent;
    }

    public String INameFormatter_format(String name, InvocationData data) {
        String namespace = null;
        String operationName = null;
        if (name != null) {
            if (name.indexOf("{namespace}", 0) >= 0) {
                namespace = (String)data.get("com.wily.powerpack.webservices.trace.NamespaceKey");
                if ((namespace == null || namespace.equals("UnknownService")) && (namespace = this.getNamespace(data)) == null) {
                    namespace = "UnknownService";
                }
                namespace = WSMUtils.formatToBeResourceSafe(namespace);
                data.put("com.wily.powerpack.webservices.trace.NamespaceKey", (Object)namespace);
                namespace = webservicesGroupPropertyHandlerHolder.get().getNormalizedPath(namespace);
                name = StringUtils.replace((String)name, (String)"{namespace}", (String)namespace);
            }
            if (name.indexOf("{servicename}", 0) >= 0) {
                namespace = (String)data.get("com.wily.powerpack.webservices.trace.ServiceNameKey");
                if ((namespace == null || namespace.equals("UnknownService")) && (namespace = this.getServiceName(data)) == null) {
                    namespace = "UnknownService";
                }
                namespace = WSMUtils.formatToBeResourceSafe(namespace);
                data.put("com.wily.powerpack.webservices.trace.ServiceNameKey", (Object)namespace);
                namespace = webservicesGroupPropertyHandlerHolder.get().getNormalizedPath(namespace);
                name = StringUtils.replace((String)name, (String)"{servicename}", (String)namespace);
            }
            if (name.indexOf("{operationname}", 0) >= 0) {
                operationName = (String)data.get("com.wily.powerpack.webservices.trace.OperationNameKey");
                if ((operationName == null || operationName.equals("UnknownOperationName")) && (operationName = this.getOperationName(data)) == null) {
                    operationName = "UnknownOperationName";
                }
                operationName = WSMUtils.formatToBeResourceSafe(operationName);
                data.put("com.wily.powerpack.webservices.trace.OperationNameKey", (Object)operationName);
                name = StringUtils.replace((String)name, (String)"{operationname}", (String)operationName);
            }
        }
        return name;
    }

    private static void setupWSNamespaceGroupingSettings(IAgent agent) {
        if (webservicesGroupPropertyHandlerHolder.get() == null && webservicesGroupPropertyHandlerHolder.compareAndSet(null, new WebservicesGroupPropertyHandler(agent))) {
            agent.IAgent_getConfigurationManager().registerListener((PropertyGroupListner)webservicesGroupPropertyHandlerHolder.get());
        }
    }
}

