/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.async;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.async.AsyncVirtualStack;
import com.wily.introscope.agent.async.InjectedFieldCorrelationHelper;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.hc2.FrontendTracer;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.util.Map;

public class AsyncThreadFragmentCorrelationTracer
extends FrontendTracer {
    private final InjectedFieldCorrelationHelper correlationHelper;
    private static final String kContextObjextIndexKey = "contextObject";
    private static final int USE_THIS_AS_CONTEXT = -1;
    private static final int USE_RETVAL_AS_CONTEXT = 9999;
    private final int contextObjectIndex;
    protected final IModuleFeedbackChannel feedback;
    protected static Module module = new Module("AsyncThreadFragmentCorrelationTracer");
    public static final String kFragmentsCategoryPrefix = "Fragments|";

    public AsyncThreadFragmentCorrelationTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.feedback = agent.IAgent_getModuleFeedback();
        this.correlationHelper = new InjectedFieldCorrelationHelper(agent, parameters, probe, sampleTracedObject);
        this.contextObjectIndex = this.calculateIntegerParameter(kContextObjextIndexKey, -1);
    }

    private Object findContextObject(InvocationData data) {
        if (this.contextObjectIndex == -1) {
            return data.getInvocationObject();
        }
        if (this.contextObjectIndex == 9999) {
            return null;
        }
        return data.getInvocationParameterAsObject(this.contextObjectIndex);
    }

    @Override
    protected String getFrontendNameForComponent(String rootName) {
        return kFragmentsCategoryPrefix + rootName;
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        boolean enabled;
        Object contextObject = this.findContextObject(data);
        if (this.feedback.isDebugEnabled(module)) {
            String className = contextObject != null ? contextObject.getClass().getName() : data.getProbeInformation().getProbeIdentification().getRuntimeFullClassName();
            this.feedback.debug(module, "In thread " + Thread.currentThread().getName() + " start trace called for method " + className + "." + data.getProbeInformation().getProbeIdentification().getProbeMethodName() + "() ");
        }
        if (contextObject != null && (enabled = this.correlationHelper.processContext(data, contextObject))) {
            super.ITracer_startTrace(tracerIndex, data);
            data.put("asyn.thread.correlation.inserted", true);
            data.setParameterCallback(new IInvocationDataParameterCallback(){

                @Override
                public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map parameters) {
                    String frontendTxid = AsyncVirtualStack.getFrontendTransactionIdFromTransactionCache(data);
                    if (frontendTxid != null) {
                        parameters.put("FrontendTxnTraceId", frontendTxid);
                    }
                }
            });
        }
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        Object contextObject = this.findContextObject(data);
        if (this.feedback.isDebugEnabled(module)) {
            String className = contextObject != null ? contextObject.getClass().getName() : data.getProbeInformation().getProbeIdentification().getRuntimeFullClassName();
            this.feedback.debug(module, "In thread " + Thread.currentThread().getName() + " finish trace called for method " + className + "." + data.getProbeInformation().getProbeIdentification().getProbeMethodName() + "() ");
        }
        if (data.get("asyn.thread.correlation.inserted") != null) {
            super.ITracer_finishTrace(tracerIndex, data);
        }
    }
}

