/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.FrontendTracer;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.servlet.LoaderContext;
import com.wily.introscope.agent.trace.servlet.RequestWrapper;
import com.wily.introscope.agent.trace.servlet.ServletContextWrapper;
import com.wily.introscope.agent.trace.servlet.ServletObjectFactory;
import com.wily.introscope.agent.trace.servlet.ServletParameterLoader;
import com.wily.introscope.agent.trace.servlet.ServletWrapper;
import com.wily.introscope.agent.trace.servlet.SessionWrapper;
import com.wily.introscope.agent.urlgroup.URLComponents;
import com.wily.introscope.agent.urlgroup.URLGroupRuleContainer;
import com.wily.introscope.agent.urlgroup.URLMatchResult;
import com.wily.util.IConfigurationListener;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationPropertySet;
import com.wily.util.properties.hot.StringSetConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class HttpServletTracer
extends FrontendTracer
implements IInvocationDataParameterCallback {
    private static final Module kModule = new Module("HttpServletTracer");
    protected static final String kHttpServletTracerLoaderContext = "HttpServletTracer";
    private boolean fDoAppNaming;
    private String fCharEncoding;
    private static IAgent fAgent;
    private boolean traceDeepCalls;
    private int traceDeepCount;
    static final String kServletContextInterfaceName = "javax.servlet.ServletContext";
    static final String kServletInterfaceName = "javax.servlet.Servlet";
    private static final String kURLsNodeString = "|URLs|";
    private static final String kURLGroupPrefix = "introscope.agent.urlgroup";
    private static final String kURLGroupKeysKey = "introscope.agent.urlgroup.keys";
    private static final String kURLGroupKeyPrefix = "introscope.agent.urlgroup.group.";
    private static final String kURLGroupPathPrefixSuffix = ".pathprefix";
    private static final String kURLGroupFormatSuffix = ".format";
    private static final String kCharEncodingPropKey = "introscope.agent.charEncoding";
    protected static final String kTraceParamKey = "introscope.agent.HttpServletTracer.transactionTraceParameters";
    private static final String kNormalizedURLKey = "introscope.agent.HttpServletTracer.normalizedURL";
    private static final String kTraceDeepCalls = "introscope.agent.HttpServletTracer.traceDeepCalls";
    private static final String kTraceDeepCount = "introscope.agent.HttpServletTracer.traceDeepCount";
    private static final int kDefaultTraceDeepCount = 5;
    private static IndexedProperties fProps;
    private static final ThreadLocal servletTracingInProgress;
    private static volatile boolean sUrlGroupsInitialized;
    private static volatile URLGroupRuleContainer sRuleContainer;
    private static URLConfigurationListener sConfigListener;
    private static int sCompNameErrorCount;
    private static final int sCompNameConsecutiveErrorThreshold = 100;
    private static boolean sHaveGivenUpGettingCompName;
    private static ThreadLocal disabledIfSet;
    private static ThreadLocal stackDepth;
    private static int sNormalizationErrorCount;
    private static final int sConsecutiveErrorThreshold = 100;
    private static boolean sHaveGivenUpGettingComponents;
    private static int sGetURLErrorCount;
    private static final int sGetURLConsecutiveErrorThreshold = 100;
    private static boolean sHaveGivenUpGettingURL;

    static {
        servletTracingInProgress = new ThreadLocal(){

            protected Object initialValue() {
                return Boolean.FALSE;
            }
        };
        sUrlGroupsInitialized = false;
        sRuleContainer = null;
        sCompNameErrorCount = 0;
        sHaveGivenUpGettingCompName = false;
        disabledIfSet = new ThreadLocal(){

            public Object initialValue() {
                return Boolean.FALSE;
            }
        };
        stackDepth = new ThreadLocal(){

            public Object initialValue() {
                return new MutableInteger(0);
            }
        };
        sNormalizationErrorCount = 0;
        sHaveGivenUpGettingComponents = false;
        sGetURLErrorCount = 0;
        sHaveGivenUpGettingURL = false;
    }

    public static void initializeParameterLoader(IAgent agent) {
        final IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
        IStringLocalizer localizer = agent.IAgent_getStringLocalizer();
        ConfigurationManager cm = agent.IAgent_getConfigurationManager();
        ConfigurationProperty charEncoding = new ConfigurationProperty(kCharEncodingPropKey, null, null, null, false, true, feedback, kModule, localizer);
        cm.add(charEncoding);
        LoaderContext.setCharEncoding(feedback, kHttpServletTracerLoaderContext, (String)charEncoding.getValue());
        cm.add(new StringSetConfigurationProperty("introscope.agent.transactiontracer.parameter.httprequest.headers", new HashSet(), "Hot_Property_Configuration_Property", null, true, true, feedback, kModule, localizer){

            public final void set(Object value) {
                LoaderContext.setLoadHeaderParams(this.getFeedback(), HttpServletTracer.kHttpServletTracerLoaderContext, ((Set)value).toArray(new String[0]));
            }
        });
        cm.add(new StringSetConfigurationProperty("introscope.agent.transactiontracer.parameter.httprequest.parameters", new HashSet(), "Hot_Property_Configuration_Property", null, true, true, feedback, kModule, localizer){

            public final void set(Object value) {
                LoaderContext.setLoadRequestParams(this.getFeedback(), HttpServletTracer.kHttpServletTracerLoaderContext, ((Set)value).toArray(new String[0]));
            }
        });
        cm.add(new StringSetConfigurationProperty("introscope.agent.transactiontracer.parameter.httprequest.attributes", new HashSet(), "Hot_Property_Configuration_Property", null, true, true, feedback, kModule, localizer){

            public final void set(Object value) {
                LoaderContext.setLoadRequestAttributes(this.getFeedback(), HttpServletTracer.kHttpServletTracerLoaderContext, ((Set)value).toArray(new String[0]));
            }
        });
        cm.add(new StringSetConfigurationProperty("introscope.agent.transactiontracer.parameter.httpsession.attributes", new HashSet(), "Hot_Property_Configuration_Property", null, true, true, feedback, kModule, localizer){

            public final void set(Object value) {
                LoaderContext.setLoadSessionAttributes(this.getFeedback(), HttpServletTracer.kHttpServletTracerLoaderContext, ((Set)value).toArray(new String[0]));
            }
        });
        ConfigurationPropertySet userIdMethodKeySet = new ConfigurationPropertySet(){

            public final void set() {
                LoaderContext.setLoadUserId(feedback, HttpServletTracer.kHttpServletTracerLoaderContext, (String)this.getConfigurationProperty("introscope.agent.transactiontracer.userid.method").getValue(), (String)this.getConfigurationProperty("introscope.agent.transactiontracer.userid.key").getValue());
            }
        };
        userIdMethodKeySet.add(new ConfigurationProperty("introscope.agent.transactiontracer.userid.method", null, "Hot_Property_Configuration_Property", null, true, true, feedback, kModule, localizer));
        userIdMethodKeySet.add(new ConfigurationProperty("introscope.agent.transactiontracer.userid.key", null, "Hot_Property_Configuration_Property", null, true, true, feedback, kModule, localizer));
        cm.add(userIdMethodKeySet, true);
    }

    public HttpServletTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        fAgent = agent;
        fProps = agent.IAgent_getIndexedProperties();
        this.fDoAppNaming = true;
        try {
            String blameType = agent.IAgent_getIndexedProperties().getProperty("introscope.agent.blame.type");
            if (blameType != null) {
                this.fDoAppNaming = blameType.equals("boundary");
            }
            this.fCharEncoding = agent.IAgent_getIndexedProperties().getProperty(kCharEncodingPropKey);
        }
        catch (Exception e) {
            this.getModuleFeedback().debug(e);
            this.fDoAppNaming = false;
        }
        sConfigListener = new URLConfigurationListener(agent.IAgent_getModuleFeedback());
        agent.addConfigurationListener(sConfigListener);
        if (!sUrlGroupsInitialized) {
            HttpServletTracer.initializeURLGroups(agent);
            sUrlGroupsInitialized = true;
        }
        this.traceDeepCalls = this.getIndexedProperties().getBooleanProperty(kTraceDeepCalls, true);
        this.traceDeepCount = this.getIndexedProperties().getIntProperty(kTraceDeepCount, 5);
        if (this.traceDeepCount <= 0) {
            this.traceDeepCount = 5;
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        if (this.isDisabled()) {
            return;
        }
        Object invocationObject = data.getInvocationObject();
        if (invocationObject == null || this.getClassesToSkip().contains(invocationObject.getClass().getName())) {
            this.setSkippedClass();
            return;
        }
        if (!this.traceDeepCalls) {
            HttpServletTracer.incrementStackDepth();
            if (HttpServletTracer.getStackDepthValue() > this.traceDeepCount) {
                return;
            }
        }
        this.setServletTracingInProgress();
        this.getComponentTracer().setInURLTracingContext();
        data.setParameterCallback(this);
        if (this.fDoAppNaming) {
            String component = this.getComponentName(data);
            data.setComponentNameAt(component, tracerIndex);
            this.doStartFrontendTrace(tracerIndex, data, component);
        }
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (this.isDisabled() || this.isSkippedClass()) {
            return;
        }
        if (!this.traceDeepCalls) {
            HttpServletTracer.decrementStackDepth();
            if (HttpServletTracer.getStackDepthValue() >= this.traceDeepCount) {
                return;
            }
        }
        try {
            if (this.fDoAppNaming) {
                String component = data.getComponentNameAt(tracerIndex);
                this.doFinishFrontendTrace(tracerIndex, data, component);
            }
        }
        finally {
            this.getComponentTracer().clearInURLTracingContext();
            this.clearServletTracingInProgress();
        }
    }

    protected void setServletTracingInProgress() {
        servletTracingInProgress.set(Boolean.TRUE);
    }

    protected void clearServletTracingInProgress() {
        servletTracingInProgress.set(Boolean.FALSE);
    }

    protected boolean isServletTracingInProgress() {
        return (Boolean)servletTracingInProgress.get();
    }

    protected String getComponentName(InvocationData data) {
        String result;
        block9: {
            Object request;
            result = null;
            if (this.fDoAppNaming && !sHaveGivenUpGettingCompName && data.getInvocationParameterCount() > 0 && (request = data.getInvocationParameterAsObject(0)) != null) {
                try {
                    ServletObjectFactory objectFactory = ServletObjectFactory.getServletObjectFactory(request);
                    RequestWrapper requestWrapper = objectFactory.getRequestWrapper(request);
                    String url = this.getNormalizedURL(data, requestWrapper);
                    ServletWrapper servletWrapper = objectFactory.getServletWrapper(data.getInvocationObject());
                    String appName = this.getServletContextName(servletWrapper, requestWrapper);
                    StringBuffer sb = new StringBuffer();
                    sb.append("Frontends|Apps|");
                    sb.append(appName);
                    sb.append(kURLsNodeString);
                    sb.append(url);
                    result = sb.toString();
                    sCompNameErrorCount = 0;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    try {
                        this.getModuleFeedback().error("An error occurred while formatting servlet metrics: " + t);
                        this.getModuleFeedback().verbose(t);
                    }
                    catch (ThreadDeath td2) {
                        throw td2;
                    }
                    catch (Throwable throwable) {}
                    if (++sCompNameErrorCount < 100) break block9;
                    sHaveGivenUpGettingCompName = true;
                }
            }
        }
        if (result == null) {
            result = this.formatParameterizedName(data);
        }
        return result.intern();
    }

    public static void disableDownstreamServletTracing() {
        disabledIfSet.set(Boolean.TRUE);
    }

    public static void enableDownstreamServletTracing() {
        disabledIfSet.set(Boolean.FALSE);
    }

    protected boolean isDisabled() {
        Boolean disabledVal = (Boolean)disabledIfSet.get();
        return disabledVal;
    }

    public static void incrementStackDepth() {
        MutableInteger stackDepthValue = (MutableInteger)stackDepth.get();
        stackDepthValue.inc();
    }

    public static void decrementStackDepth() {
        MutableInteger stackDepthValue = (MutableInteger)stackDepth.get();
        stackDepthValue.dec();
    }

    public static int getStackDepthValue() {
        MutableInteger stackDepthValue = (MutableInteger)stackDepth.get();
        return stackDepthValue.getValue();
    }

    private String getNormalizedURL(InvocationData data, RequestWrapper rw) {
        String result = (String)data.get(kNormalizedURLKey);
        if (result == null) {
            if (!sHaveGivenUpGettingComponents) {
                if (sRuleContainer == null || sRuleContainer.size() == 0) {
                    result = this.getURL(rw);
                } else {
                    try {
                        if (this.fCharEncoding != null) {
                            rw.setCharacterEncoding(this.fCharEncoding);
                        }
                        Map parameterMap = Collections.EMPTY_MAP;
                        if (sRuleContainer.hasQueryParams()) {
                            parameterMap = rw.getParameterMap();
                        }
                        URLComponents comps = new URLComponents(rw.getProtocol(), rw.getServerName(), rw.getServerPort(), rw.getRequestURI(), parameterMap);
                        sNormalizationErrorCount = 0;
                        sHaveGivenUpGettingComponents = false;
                        URLMatchResult matchResult = sRuleContainer.matchFirstRule(comps, null);
                        if (matchResult != null) {
                            result = matchResult.getFormatted();
                        }
                        if (result == null) {
                            result = this.getURL(rw);
                        }
                    }
                    catch (Exception exception) {
                        if (++sNormalizationErrorCount >= 100) {
                            sHaveGivenUpGettingComponents = true;
                        }
                        result = this.getURL(rw);
                    }
                }
            } else {
                result = this.getURL(rw);
            }
            data.put(kNormalizedURLKey, result);
        }
        return result.replace(':', '%');
    }

    public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map parameters) {
        if (data.getInvocationParameterCount() > 0) {
            ServletParameterLoader loader = new ServletParameterLoader(fAgent, this.getModuleFeedback(), kHttpServletTracerLoaderContext, parameters);
            try {
                ServletObjectFactory objectFactory;
                RequestWrapper rw;
                String normalizedURL;
                loader.executeSafe(data);
                Object request = data.getInvocationParameterAsObject(0);
                if (request != null && (normalizedURL = this.getNormalizedURL(data, rw = (objectFactory = ServletObjectFactory.getServletObjectFactory(request)).getRequestWrapper(request))) != null) {
                    parameters.put("Normalized URL", normalizedURL);
                }
            }
            catch (Throwable t) {
                this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_Transaction_Trace_Servlet_Class_Error"));
                this.getModuleFeedback().verbose(t);
            }
        }
    }

    private String getServletContextName(ServletWrapper servlet, RequestWrapper request) {
        try {
            String result = request.getApplicationNameFromServlet(servlet);
            if (result != null && result.equals("")) {
                result = "rootContext";
            }
            return result;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.getModuleFeedback().verbose(t);
                this.getModuleFeedback().error("An error occurred getting the application name: " + t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
            return "UnknownApp";
        }
    }

    private String getURL(RequestWrapper request) {
        String result = "UnknownURL";
        if (!sHaveGivenUpGettingURL) {
            try {
                result = request.getRequestURI();
                sGetURLErrorCount = 0;
                sHaveGivenUpGettingURL = false;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                if (++sGetURLErrorCount >= 100) {
                    sHaveGivenUpGettingURL = true;
                }
                this.getModuleFeedback().verbose(t);
            }
        }
        return result;
    }

    static void debug_clearUserIDAccessor() {
    }

    static ServletContextWrapper getServletContext(RequestWrapper request) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        SessionWrapper session = request.getSession(false);
        if (session == null) {
            return null;
        }
        return session.getServletContext();
    }

    private static void initializeURLGroups(IAgent agent) {
        HttpServletTracer.initializeURLGroups(agent.IAgent_getIndexedProperties(), agent.IAgent_getModuleFeedback());
    }

    private static synchronized void initializeURLGroups(IndexedProperties props, IModuleFeedbackChannel feedback) {
        HttpServletTracer.initializeURLGroups(props, feedback, false);
    }

    private static synchronized void initializeURLGroups(IndexedProperties props, IModuleFeedbackChannel feedback, boolean force) {
        if (!force && sUrlGroupsInitialized) {
            return;
        }
        try {
            URLGroupRuleContainer container = new URLGroupRuleContainer();
            String keys = props.getProperty(kURLGroupKeysKey);
            if (keys != null && keys.length() > 0) {
                StringTokenizer strtok = new StringTokenizer(keys, ",", false);
                while (strtok.hasMoreTokens()) {
                    String currentKey = strtok.nextToken();
                    String propPrefix = kURLGroupKeyPrefix + currentKey;
                    String prefixPropKey = String.valueOf(propPrefix) + kURLGroupPathPrefixSuffix;
                    String formatPropKey = String.valueOf(propPrefix) + kURLGroupFormatSuffix;
                    String currentPathPrefix = props.getProperty(prefixPropKey);
                    String currentFormat = null;
                    if (currentPathPrefix != null && currentPathPrefix.length() > 0) {
                        currentFormat = props.getProperty(formatPropKey);
                        if (currentFormat != null && currentFormat.length() > 0) {
                            container.add(currentPathPrefix, currentFormat);
                            continue;
                        }
                        feedback.warn("Mis-configured agent properties: " + prefixPropKey + " has value " + currentPathPrefix + ", " + formatPropKey + " has value " + currentFormat + " (both must be non-null and non-empty)");
                        continue;
                    }
                    feedback.warn("Mis-configured agent properties: " + prefixPropKey + " has value " + currentPathPrefix + " -- it must be non-null and non-empty");
                }
                sRuleContainer = container;
            }
        }
        catch (Exception e) {
            try {
                feedback.error("HttpServletTracer: Could not initialize URL groupings");
                feedback.verbose(e);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {}
        }
        sUrlGroupsInitialized = true;
    }

    public static final class MutableInteger {
        private int i;

        public MutableInteger(int initValue) {
            this.i = initValue;
        }

        public void inc() {
            ++this.i;
        }

        public void dec() {
            --this.i;
        }

        public int getValue() {
            return this.i;
        }

        public void clear() {
            this.i = 0;
        }
    }

    private static class URLConfigurationListener
    implements IConfigurationListener {
        private IModuleFeedbackChannel feedback;

        private URLConfigurationListener(IModuleFeedbackChannel feedback) {
            this.feedback = feedback;
        }

        public void onChange(IndexedProperties props) {
            if (this.checkForChange(fProps, props)) {
                HttpServletTracer.initializeURLGroups(props, this.feedback, true);
            } else if (this.checkForChange(props, fProps)) {
                HttpServletTracer.initializeURLGroups(props, this.feedback, true);
            }
            fProps = props;
        }

        private boolean checkForChange(IndexedProperties props1, IndexedProperties props2) {
            Enumeration<?> eGlue = props1.propertyNames();
            while (eGlue.hasMoreElements()) {
                String key = (String)eGlue.nextElement();
                if (key.indexOf(HttpServletTracer.kURLGroupPrefix) < 0) continue;
                String key1Value = props1.getTrimmedProperty(key);
                String key2Value = props2.getTrimmedProperty(key);
                if (key1Value != null) {
                    if (key1Value.equals(key2Value)) continue;
                    fAgent.IAgent_getModuleFeedback().info("Url grouping: properties have changed, groups will be re-initialized");
                    return true;
                }
                if (key2Value == null) continue;
                fAgent.IAgent_getModuleFeedback().info("Url grouping: properties have changed, groups will be re-initialized");
                return true;
            }
            return false;
        }
    }
}

