/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.server.beans.properties;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class PropertyEvent
implements Externalizable {
    private static final long serialVersionUID = -2828287268716354826L;
    public static final PropertyEvent[] kEmptyPropertyEventArray = new PropertyEvent[0];
    public static final int kAdded = 1;
    public static final int kRemoved = 3;
    public static final int kChanged = 5;
    private String fName;
    private String fOldValue;
    private String fValue;
    private int fState;

    public PropertyEvent() {
    }

    private PropertyEvent(int state, String name, String value, String oldValue) {
        this.fState = state;
        this.fName = name;
        this.fValue = value;
        this.fOldValue = oldValue;
    }

    public static PropertyEvent createAddedEvent(String name, String value) {
        return new PropertyEvent(1, name, value, null);
    }

    public static PropertyEvent createRemovedEvent(String name, String value) {
        return new PropertyEvent(3, name, value, null);
    }

    public static PropertyEvent createChangedEvent(String name, String value, String oldValue) {
        return new PropertyEvent(5, name, value, oldValue);
    }

    public String getPropertyName() {
        return this.fName;
    }

    public String getOldPropertyValue() {
        return this.fOldValue;
    }

    public String getPropertyValue() {
        return this.fValue;
    }

    public boolean isAddedEvent() {
        return this.fState == 1;
    }

    public boolean isRemovedEvent() {
        return this.fState == 3;
    }

    public boolean isChangedEvent() {
        return this.fState == 5;
    }

    public int getState() {
        return this.fState;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof PropertyEvent)) {
            return false;
        }
        PropertyEvent e = (PropertyEvent)o;
        if (this.getState() != e.getState()) {
            return false;
        }
        if (!this.getPropertyName().equals(e.getPropertyName())) {
            return false;
        }
        if (this.getPropertyValue() == null ? e.getPropertyValue() != null : !this.getPropertyValue().equals(e.getPropertyValue())) {
            return false;
        }
        return !(this.getOldPropertyValue() == null ? e.getOldPropertyValue() != null : !this.getOldPropertyValue().equals(e.getOldPropertyValue()));
    }

    public int hashCode() {
        return this.fName.hashCode() ^ this.fState;
    }

    public String toString() {
        String state = this.getState() == 1 ? "Added " : (this.getState() == 3 ? "Removed " : "Changed ");
        StringBuffer buf = new StringBuffer();
        buf.append(state);
        buf.append(this.getPropertyName());
        buf.append("=");
        buf.append(this.getPropertyValue());
        if (this.getOldPropertyValue() != null) {
            buf.append(" (");
            buf.append(this.getOldPropertyValue());
            buf.append(")");
        }
        return buf.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fState = in.readInt();
        this.fName = (String)in.readObject();
        this.fValue = (String)in.readObject();
        this.fOldValue = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.fState);
        out.writeObject(this.fName);
        out.writeObject(this.fValue);
        out.writeObject(this.fOldValue);
    }

    public boolean getPropertyValueAsBoolean() {
        return Boolean.valueOf(this.fValue);
    }
}

