/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.io.ExtendedFile;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.resource.IResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class MQProperties
extends Properties {
    private IModuleFeedbackChannel feedback = null;
    private static Module kModule = new Module("MQProperties");
    private static MQProperties _instance = null;
    private boolean initialized = false;
    private static final char COMMENTCHAR = '#';
    private static final String SUBKEY_DELIMTER = ",";
    private static final String KEY_VALUE_DELIMTER = ":";
    public static final String MONITOR_MANAGER = ".monitor.manager";
    public static final String MONITOR_QUEUE = ".monitor.queue";
    public static final String MONITOR_CHANNEL = ".monitor.channel";
    public static final String MONITOR_CHANNELINITIATOR = ".monitor.channelinitiator";
    public static final String MONITOR_PAGESET = ".monitor.pagesets";
    public static final String MONITOR_LOG = ".monitor.log";
    public static final String RECOMENDED_METRIC_MANAGER = "recommended.metrics.manager";
    public static final String RECOMENDED_METRIC_QUEUE = "recommended.metrics.queue";
    public static final String RECOMENDED_METRIC_CHANNEL = "recommended.metrics.channel";
    public static final String RECOMENDED_METRIC_CHANNELINITIATOR = "recommended.metrics.channelinitiator";
    public static final String RECOMENDED_METRIC_PAGESETS = "recommended.metrics.pagesets";
    public static final String RECOMENDED_METRIC_LOG = "recommended.metrics.log";
    private static final String WILY_DIR_PATH = "../../common/";

    private MQProperties(IModuleFeedbackChannel feedback) {
        this.feedback = feedback;
    }

    public static synchronized MQProperties instance(IModuleFeedbackChannel feedback) {
        if (_instance == null) {
            MQProperties mqProperties = new MQProperties(feedback);
            boolean loaded = mqProperties.fileResourceFinder();
            if (!loaded) {
                mqProperties.systemResourceFinder();
                if (!loaded) {
                    loaded = mqProperties.wilyDirectorResourceFinder();
                    if (loaded) {
                        _instance = mqProperties;
                    } else {
                        feedback.error(kModule, "Failed to load property file MQAgent.properties. ");
                    }
                } else {
                    _instance = mqProperties;
                }
            } else {
                _instance = mqProperties;
            }
        }
        return _instance;
    }

    private boolean fileResourceFinder() {
        FileInputStream file = null;
        String mqMonitorPropertiesFilePath = null;
        mqMonitorPropertiesFilePath = System.getProperty("com.wily.mqpp.mqagentProfile");
        if (mqMonitorPropertiesFilePath == null || mqMonitorPropertiesFilePath.trim().length() == 0) {
            this.feedback.debug(kModule, "System property com.wily.mqpp.mqagentProfile is null. Reading com.wily.introscope.agentProfile");
            System.getProperty("com.wily.introscope.agentProfile");
            String commonFolderPath = null;
            try {
                IResource resource;
                IndexedProperties props = AgentShim.getAgent().IAgent_getIndexedProperties();
                commonFolderPath = props.getProperty("introscope.agent.common.directory");
                if (!ExtendedFile.isAbsolutePath((String)commonFolderPath) && (resource = AgentShim.getAgent().IAgent_getConfigurationResource()) != null && resource.IResource_isFileResource()) {
                    commonFolderPath = String.valueOf(new File(resource.IResource_getLocation()).getParent()) + "/" + commonFolderPath;
                }
            }
            catch (AgentNotAvailableException agentNotAvailableException) {}
            this.feedback.debug(kModule, "Introscope Common Directory is " + commonFolderPath);
            if (commonFolderPath != null && commonFolderPath.trim().length() > 0) {
                mqMonitorPropertiesFilePath = String.valueOf(commonFolderPath) + "/" + "MQAgent.properties";
            }
        } else {
            this.feedback.info(kModule, "System property com.wily.mqpp.mqagentProfile value is " + mqMonitorPropertiesFilePath);
        }
        if (mqMonitorPropertiesFilePath != null) {
            block13: {
                file = new FileInputStream(mqMonitorPropertiesFilePath);
                if (file == null) break block13;
                this.feedback.debug(kModule, "Found property file " + mqMonitorPropertiesFilePath + ".");
                this.load(file);
                try {
                    ((InputStream)file).close();
                }
                catch (Exception exception) {}
                return true;
            }
            try {
                this.feedback.error(kModule, "Failed to load property file " + mqMonitorPropertiesFilePath + ". Make sure that it is available in the place.");
            }
            catch (IOException e) {
                this.feedback.error(kModule, "Failed to load property file " + mqMonitorPropertiesFilePath + ". Make sure that it is available in the place.");
                this.feedback.debug(kModule, "Exception in loading property file", (Throwable)e);
            }
        } else {
            this.feedback.debug(kModule, "System property com.wily.mqpp.mqagentProfile or com.wily.introscope.agentProfile is not set. Make sure that the MQAgent property file path is provided.");
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean wilyDirectorResourceFinder() {
        FileInputStream file = null;
        String mqMonitorPropertiesFilePath = "wily/IntroscopeAgent.profile";
        try {
            File dir = new File("wily");
            File mqProperties = new File(dir, "IntroscopeAgent.profile");
            String absPath = mqProperties.getAbsolutePath();
            try {
                file = new FileInputStream(absPath);
                if (file == null) {
                    this.feedback.error(kModule, "Failed to load property file " + mqMonitorPropertiesFilePath + ". Make sure that it is available in the place.");
                    return false;
                }
                this.feedback.debug(kModule, "Found property file " + mqMonitorPropertiesFilePath + ".");
                this.load(file);
                try {
                    ((InputStream)file).close();
                    return true;
                }
                catch (Exception exception) {}
                return true;
            }
            catch (IOException iOException) {
                this.feedback.error(kModule, "Failed to load property file " + mqMonitorPropertiesFilePath + ". Make sure that it is available in the place.");
                return false;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    private boolean systemResourceFinder() {
        block7: {
            InputStream file = null;
            String mqMonitorPropertiesFilePath = null;
            String introscopeAgentProfileFilePath = System.getProperty("com.wily.introscope.agentResource");
            if (introscopeAgentProfileFilePath != null) {
                block8: {
                    mqMonitorPropertiesFilePath = this.prepareMQMonitorPath(introscopeAgentProfileFilePath);
                    file = this.getClass().getClassLoader().getResourceAsStream(mqMonitorPropertiesFilePath);
                    if (file != null) break block7;
                    file = ClassLoader.getSystemResourceAsStream(mqMonitorPropertiesFilePath);
                    if (file == null) break block8;
                    this.feedback.debug(kModule, "Found property file " + mqMonitorPropertiesFilePath + " in the classpath");
                    this.load(file);
                    try {
                        file.close();
                    }
                    catch (Exception exception) {}
                    return true;
                }
                try {
                    this.feedback.error(kModule, "Failed to load property file " + mqMonitorPropertiesFilePath + ". Make sure that it is available in the classpath.");
                }
                catch (IOException iOException) {
                    this.feedback.error(kModule, "Failed to load property file " + mqMonitorPropertiesFilePath + ". Make sure that it is available in the classpath.");
                }
            } else {
                this.feedback.debug(kModule, "Property com.wily.introscope.agentProfile is not set. Make sure that it is provided.");
            }
        }
        return false;
    }

    private String prepareMQMonitorPath(String introscopeAgentProfileFilePath) {
        String mqMonitorPropertiesFilePath = null;
        int lastIndexForward = introscopeAgentProfileFilePath.lastIndexOf("/");
        int lastIndexBackward = introscopeAgentProfileFilePath.lastIndexOf("\\");
        int lastIndex = -1;
        lastIndex = lastIndexForward > lastIndexBackward ? lastIndexForward : lastIndexBackward;
        String filePath = introscopeAgentProfileFilePath.substring(0, lastIndex + 1);
        filePath = String.valueOf(filePath) + WILY_DIR_PATH;
        mqMonitorPropertiesFilePath = String.valueOf(filePath) + "MQAgent.properties";
        return mqMonitorPropertiesFilePath;
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized boolean reload() {
        MQProperties mqProperties = _instance;
        boolean loaded = mqProperties.fileResourceFinder();
        if (loaded) {
            _instance = mqProperties;
            return true;
        }
        mqProperties.systemResourceFinder();
        if (loaded) {
            _instance = mqProperties;
            return true;
        }
        loaded = mqProperties.wilyDirectorResourceFinder();
        if (loaded) {
            _instance = mqProperties;
            return true;
        }
        this.feedback.error(kModule, "Failed to reload load property file MQAgent.properties. ");
        return false;
    }

    public static void main(String[] args) {
    }
}

